/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.commandline;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.AbstractEnvironment;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.environment.commandline.CommandLineSession;
import org.apache.cocoon.serialization.LinkSerializer;
import org.apache.log.Logger;
import org.xml.sax.SAXException;

public abstract class AbstractCommandLineEnvironment
extends AbstractEnvironment
implements Redirector {
    protected String contentType;
    protected OutputStream stream;
    protected int contentLength;
    protected boolean hasRedirected = false;

    public AbstractCommandLineEnvironment(String uri, String view, File context, OutputStream stream, Logger log) throws MalformedURLException {
        super(uri, view, context);
        this.setLogger(log);
        this.stream = stream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void redirect(boolean sessionmode, String newURL) throws IOException {
        this.hasRedirected = true;
        if (sessionmode) {
            CommandLineSession.getSession(true);
        }
        if (newURL.startsWith("cli:/")) {
            int pos = newURL.indexOf(47, 6);
            newURL = newURL.substring(pos + 1);
        }
        if (newURL.indexOf(":") == -1) {
            newURL = "cocoon:/" + newURL;
        }
        if (newURL.startsWith("cocoon:") && this.getView() != null && this.getView().equals("links")) {
            LinkSerializer ls = new LinkSerializer();
            ls.setOutputStream(this.stream);
            Source redirectSource = null;
            try {
                try {
                    redirectSource = this.resolve(newURL);
                    redirectSource.toSAX(ls);
                }
                catch (SAXException se) {
                    throw new IOException("SAXException: " + se);
                }
                catch (ProcessingException pe) {
                    throw new IOException("ProcessingException: " + (Object)((Object)pe));
                }
                Object var8_9 = null;
                if (redirectSource == null) return;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (redirectSource == null) throw throwable;
                redirectSource.recycle();
                throw throwable;
            }
            redirectSource.recycle();
            return;
        }
        Source redirectSource = null;
        try {
            try {
                redirectSource = this.resolve(newURL);
                InputStream is = redirectSource.getInputStream();
                byte[] buffer = new byte[8192];
                int length = -1;
                while ((length = is.read(buffer)) > -1) {
                    this.stream.write(buffer, 0, length);
                }
            }
            catch (SAXException se) {
                throw new IOException("SAXException: " + se);
            }
            catch (ProcessingException pe) {
                throw new IOException("ProcessingException: " + (Object)((Object)pe));
            }
            Object var10_17 = null;
            if (redirectSource == null) return;
        }
        catch (Throwable throwable) {
            Object var10_18 = null;
            if (redirectSource == null) throw throwable;
            redirectSource.recycle();
            throw throwable;
        }
        redirectSource.recycle();
    }

    public boolean hasRedirected() {
        return this.hasRedirected;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.stream;
    }
}

