/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.cocoon.util.BlobHelper;
import org.apache.cocoon.util.ClobHelper;
import org.apache.cocoon.util.JDBCxlobHelper;
import org.apache.excalibur.source.Source;

public class JDBCTypeConversions {
    public static final Map typeConstants;

    public static Object convert(Object value, String jType) {
        Object object = null;
        if (jType.equalsIgnoreCase("string")) {
            object = value instanceof String ? value : value.toString();
        } else if (jType.equalsIgnoreCase("int")) {
            if (value instanceof String) {
                object = Integer.decode((String)value);
            } else if (value instanceof Integer) {
                object = value;
            }
        } else if (jType.equalsIgnoreCase("long")) {
            if (value instanceof String) {
                object = Long.decode((String)value);
            } else if (value instanceof Long) {
                object = value;
            }
        }
        return object;
    }

    public static Object getColumn(ResultSet set, Configuration column) throws Exception {
        Integer type = (Integer)typeConstants.get(column.getAttribute("type"));
        String dbcol = column.getAttribute("name");
        Object value = null;
        switch (type) {
            case 1: 
            case 2005: {
                Clob dbClob = set.getClob(dbcol);
                int length = (int)dbClob.length();
                BufferedInputStream asciiStream = new BufferedInputStream(dbClob.getAsciiStream());
                byte[] buffer = new byte[length];
                ((InputStream)asciiStream).read(buffer);
                String str = new String(buffer);
                ((InputStream)asciiStream).close();
                value = str;
                break;
            }
            case -5: {
                value = set.getBigDecimal(dbcol);
                break;
            }
            case -6: {
                value = new Byte(set.getByte(dbcol));
                break;
            }
            case 12: {
                value = set.getString(dbcol);
                break;
            }
            case 91: {
                value = set.getDate(dbcol);
                break;
            }
            case 8: {
                value = new Double(set.getDouble(dbcol));
                break;
            }
            case 6: {
                value = new Float(set.getFloat(dbcol));
                break;
            }
            case 4: {
                value = new Integer(set.getInt(dbcol));
                break;
            }
            case 2: {
                value = new Long(set.getLong(dbcol));
                break;
            }
            case 5: {
                value = new Short(set.getShort(dbcol));
                break;
            }
            case 92: {
                value = set.getTime(dbcol);
                break;
            }
            case 93: {
                value = set.getTimestamp(dbcol);
                break;
            }
            case 2003: {
                value = set.getArray(dbcol);
                break;
            }
            case -7: {
                value = new Integer(set.getInt(dbcol));
                break;
            }
            case 2002: {
                value = (Struct)set.getObject(dbcol);
                break;
            }
            case 1111: {
                value = set.getObject(dbcol);
                break;
            }
            default: {
                value = "";
            }
        }
        return value;
    }

    public static void setColumn(PreparedStatement statement, int position, Object value, Integer typeObject) throws Exception {
        if (value instanceof String) {
            value = ((String)value).trim();
        }
        if (typeObject == null) {
            throw new SQLException("Can't set column because the type is unrecognized");
        }
        if (value == null) {
            statement.setNull(position, typeObject);
            return;
        }
        if ("".equals(value)) {
            switch (typeObject) {
                case 1: 
                case 12: 
                case 2005: {
                    break;
                }
                default: {
                    statement.setNull(position, typeObject);
                    return;
                }
            }
        }
        File file = null;
        int length = -1;
        InputStream asciiStream = null;
        switch (typeObject) {
            case 2005: {
                Clob clob = null;
                if (value instanceof Clob) {
                    clob = (Clob)value;
                } else if (value instanceof File) {
                    File asciiFile = (File)value;
                    asciiStream = new BufferedInputStream(new FileInputStream(asciiFile));
                    length = (int)asciiFile.length();
                    clob = new ClobHelper(asciiStream, length);
                } else if (value instanceof JDBCxlobHelper) {
                    asciiStream = ((JDBCxlobHelper)value).inputStream;
                    length = ((JDBCxlobHelper)value).length;
                    clob = new ClobHelper(asciiStream, length);
                } else if (value instanceof Source) {
                    asciiStream = ((Source)value).getInputStream();
                    length = (int)((Source)value).getContentLength();
                    clob = new ClobHelper(asciiStream, length);
                } else {
                    String asciiText = (String)value;
                    asciiStream = new ByteArrayInputStream(asciiText.getBytes());
                    length = asciiText.length();
                    clob = new ClobHelper(asciiStream, length);
                }
                statement.setClob(position, clob);
                break;
            }
            case 1: {
                if (value instanceof File) {
                    File asciiFile = (File)value;
                    asciiStream = new BufferedInputStream(new FileInputStream(asciiFile));
                    length = (int)asciiFile.length();
                } else if (value instanceof JDBCxlobHelper) {
                    asciiStream = ((JDBCxlobHelper)value).inputStream;
                    length = ((JDBCxlobHelper)value).length;
                } else if (value instanceof Source) {
                    asciiStream = ((Source)value).getInputStream();
                    length = (int)((Source)value).getContentLength();
                } else {
                    String asciiText = (String)value;
                    asciiStream = new BufferedInputStream(new ByteArrayInputStream(asciiText.getBytes()));
                    length = asciiText.length();
                }
                statement.setAsciiStream(position, asciiStream, length);
                break;
            }
            case -5: {
                BigDecimal bd = null;
                bd = value instanceof BigDecimal ? (BigDecimal)value : (value instanceof Number ? BigDecimal.valueOf(((Number)value).longValue()) : new BigDecimal((String)value));
                statement.setBigDecimal(position, bd);
                break;
            }
            case -6: {
                Byte b = null;
                b = value instanceof Byte ? (Byte)value : (value instanceof Number ? new Byte(((Number)value).byteValue()) : new Byte((String)value));
                statement.setByte(position, b);
                break;
            }
            case 91: {
                Date d = null;
                if (value instanceof Date) {
                    d = (Date)value;
                } else if (value instanceof java.util.Date) {
                    d = new Date(((java.util.Date)value).getTime());
                } else if (value instanceof Calendar) {
                    d = new Date(((Calendar)value).getTime().getTime());
                }
                statement.setDate(position, d);
                break;
            }
            case 8: {
                double db = value instanceof Number ? ((Number)value).doubleValue() : Double.parseDouble(String.valueOf(value));
                statement.setDouble(position, db);
                break;
            }
            case 6: {
                float f = value instanceof Number ? ((Number)value).floatValue() : Float.parseFloat(String.valueOf(value));
                statement.setFloat(position, f);
                break;
            }
            case 2: {
                long l = value instanceof Number ? ((Number)value).longValue() : Long.parseLong(String.valueOf(value));
                statement.setLong(position, l);
                break;
            }
            case 5: {
                Short s = null;
                s = value instanceof Short ? (Short)value : (value instanceof Number ? new Short(((Number)value).shortValue()) : new Short((String)value));
                statement.setShort(position, s);
                break;
            }
            case 92: {
                Time t = null;
                t = value instanceof Time ? (Time)value : (value instanceof java.util.Date ? new Time(((java.util.Date)value).getTime()) : Time.valueOf(value.toString()));
                statement.setTime(position, t);
                break;
            }
            case 93: {
                Timestamp ts = null;
                ts = value instanceof Time ? (Timestamp)value : (value instanceof java.util.Date ? new Timestamp(((java.util.Date)value).getTime()) : Timestamp.valueOf(value.toString()));
                statement.setTimestamp(position, ts);
                break;
            }
            case 2003: {
                statement.setArray(position, (Array)value);
                break;
            }
            case 1111: 
            case 2002: {
                statement.setObject(position, value);
                break;
            }
            case -4: {
                statement.setTimestamp(position, new Timestamp(new java.util.Date().getTime()));
                break;
            }
            case 12: {
                statement.setString(position, (String)value);
                break;
            }
            case 2004: {
                if (value instanceof JDBCxlobHelper) {
                    statement.setBinaryStream(position, ((JDBCxlobHelper)value).inputStream, ((JDBCxlobHelper)value).length);
                    break;
                }
                if (value instanceof Source) {
                    statement.setBinaryStream(position, ((Source)value).getInputStream(), (int)((Source)value).getContentLength());
                    break;
                }
                Blob blob = null;
                if (value instanceof Blob) {
                    blob = (Blob)value;
                } else if (value instanceof File) {
                    file = (File)value;
                    blob = new BlobHelper(new FileInputStream(file), (int)file.length());
                } else if (value instanceof String) {
                    file = new File((String)value);
                    blob = new BlobHelper(new FileInputStream(file), (int)file.length());
                } else {
                    throw new SQLException("Invalid type for blob: " + value.getClass().getName());
                }
                statement.setBlob(position, blob);
                break;
            }
            case -3: {
                if (value instanceof JDBCxlobHelper) {
                    statement.setBinaryStream(position, ((JDBCxlobHelper)value).inputStream, ((JDBCxlobHelper)value).length);
                    break;
                }
                if (value instanceof Source) {
                    statement.setBinaryStream(position, ((Source)value).getInputStream(), (int)((Source)value).getContentLength());
                    break;
                }
                if (value instanceof File) {
                    file = (File)value;
                } else if (value instanceof String) {
                    file = new File((String)value);
                } else {
                    throw new SQLException("Invalid type for blob: " + value.getClass().getName());
                }
                FileInputStream input = new FileInputStream(file);
                statement.setBinaryStream(position, (InputStream)input, (int)file.length());
                break;
            }
            case 4: {
                Integer i = null;
                i = value instanceof Integer ? (Integer)value : (value instanceof Number ? new Integer(((Number)value).intValue()) : new Integer(value.toString()));
                statement.setInt(position, i);
                break;
            }
            case -7: {
                Boolean bo = null;
                bo = value instanceof Boolean ? (Boolean)value : (value instanceof Number ? new Boolean(((Number)value).intValue() == 1) : new Boolean(value.toString()));
                statement.setBoolean(position, bo);
                break;
            }
            default: {
                throw new SQLException("Impossible exception - invalid type ");
            }
        }
    }

    static {
        HashMap<String, Integer> constants = new HashMap<String, Integer>();
        constants.put("clob", new Integer(2005));
        constants.put("ascii", new Integer(1));
        constants.put("big-decimal", new Integer(-5));
        constants.put("binary", new Integer(-3));
        constants.put("blob", new Integer(2004));
        constants.put("boolean", new Integer(-7));
        constants.put("byte", new Integer(-6));
        constants.put("string", new Integer(12));
        constants.put("date", new Integer(91));
        constants.put("double", new Integer(8));
        constants.put("float", new Integer(6));
        constants.put("int", new Integer(4));
        constants.put("long", new Integer(2));
        constants.put("short", new Integer(5));
        constants.put("time", new Integer(92));
        constants.put("time-stamp", new Integer(93));
        constants.put("array", new Integer(2003));
        constants.put("row", new Integer(2002));
        constants.put("object", new Integer(1111));
        typeConstants = Collections.unmodifiableMap(constants);
    }
}

