/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.server.impl.callback.socket;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import org.apache.excalibur.altrmi.client.AltrmiHostContext;
import org.apache.excalibur.altrmi.common.AltrmiConnectionClosedException;
import org.apache.excalibur.altrmi.common.AltrmiReply;
import org.apache.excalibur.altrmi.common.AltrmiRequest;
import org.apache.excalibur.altrmi.common.ExposedObjectProxy;
import org.apache.excalibur.altrmi.common.MethodRequest;
import org.apache.excalibur.altrmi.common.SerializationHelper;
import org.apache.excalibur.altrmi.server.impl.ServerStreamReadWriter;
import org.apache.excalibur.altrmi.server.impl.callback.CallbackHostContext;
import org.apache.excalibur.altrmi.server.impl.callback.CallbackServerClassAltrmiFactory;
import org.apache.excalibur.altrmi.server.impl.callback.socket.CallbackServerClientReadWriter;
import org.apache.excalibur.altrmi.server.impl.callback.stream.CallbackStreamInvocationHandler;

public class CallbackEnabledSocketCustomStreamReadWriter
extends ServerStreamReadWriter
implements Runnable {
    private DataInputStream mDataInputStream;
    private DataOutputStream mDataOutputStream;
    private Thread mMessageLoopThread = null;
    private boolean mIsStopped = false;
    private Object mRequestLock = new Object();
    private Object mReplyLock = new Object();
    private AltrmiRequest mRequest = null;
    private AltrmiReply mReply = null;
    private CallbackServerClientReadWriter mCallbackServerClientReadWriter;
    private CallbackStreamInvocationHandler mCallbackStreamInvocationHandler;
    private CallbackHostContext mCallbackHostContext;
    private CallbackServerClassAltrmiFactory mAltrmiFactory;

    protected void initialize() throws IOException {
        this.mDataInputStream = new DataInputStream(this.mInputStream);
        this.mDataOutputStream = new DataOutputStream(new BufferedOutputStream(this.mOutputStream));
        this.mMessageLoopThread = new Thread((Runnable)this, "CallbackEnabledServer Thread");
        this.mMessageLoopThread.start();
    }

    public void run() {
        this.mCallbackServerClientReadWriter = new CallbackServerClientReadWriter(this);
        this.mCallbackStreamInvocationHandler = new CallbackStreamInvocationHandler(this.getClass().getClassLoader());
        this.mCallbackStreamInvocationHandler.setObjectReadWriter(this.mCallbackServerClientReadWriter);
        this.mCallbackHostContext = new CallbackHostContext(this.mCallbackStreamInvocationHandler);
        this.mAltrmiFactory = new CallbackServerClassAltrmiFactory(false);
        this.mAltrmiFactory.setInitializedHostContext((AltrmiHostContext)this.mCallbackHostContext);
        while (!this.mIsStopped) {
            Object byteArray;
            try {
                Object object;
                int byteArraySize = this.mDataInputStream.readInt();
                byteArray = new byte[byteArraySize];
                this.mDataInputStream.read((byte[])byteArray);
                Object obj = SerializationHelper.getInstanceFromBytes((byte[])byteArray);
                if (obj instanceof AltrmiRequest) {
                    this.mRequest = (AltrmiRequest)obj;
                    object = this.mRequestLock;
                    synchronized (object) {
                        this.mRequestLock.notify();
                        continue;
                    }
                }
                if (!(obj instanceof AltrmiReply)) continue;
                this.mReply = (AltrmiReply)obj;
                object = this.mReplyLock;
                synchronized (object) {
                    this.mReplyLock.notify();
                }
            }
            catch (SocketException se) {
                this.mIsStopped = true;
                byteArray = this.mRequestLock;
                synchronized (byteArray) {
                    this.mRequestLock.notify();
                }
                Object object = this.mReplyLock;
                synchronized (object) {
                    this.mReplyLock.notify();
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.mIsStopped = true;
                return;
            }
            catch (ClassNotFoundException ce) {
                ce.printStackTrace();
                this.mIsStopped = true;
                return;
            }
        }
    }

    private AltrmiRequest getRequestFromMessageLoop() {
        if (this.mRequest == null) {
            Object object = this.mRequestLock;
            synchronized (object) {
                try {
                    this.mRequestLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.mRequest;
    }

    private AltrmiReply getReplyFromMessageLoop() {
        if (this.mReply == null) {
            Object object = this.mReplyLock;
            synchronized (object) {
                try {
                    this.mReplyLock.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return this.mReply;
    }

    protected AltrmiRequest writeReplyAndGetRequest(AltrmiReply altrmiReply) throws IOException, ClassNotFoundException {
        if (altrmiReply != null) {
            this.writeReply(altrmiReply);
        }
        AltrmiRequest req = this.readRequest();
        this.mRequest = null;
        return req;
    }

    private void writeReply(AltrmiReply altrmiReply) throws IOException {
        byte[] aBytes = SerializationHelper.getBytesFromInstance((Object)altrmiReply);
        this.mDataOutputStream.writeInt(aBytes.length);
        this.mDataOutputStream.write(aBytes);
        this.mDataOutputStream.flush();
    }

    private AltrmiRequest readRequest() throws IOException, ClassNotFoundException {
        AltrmiRequest altrmiRequest = this.getRequestFromMessageLoop();
        if (altrmiRequest instanceof MethodRequest) {
            this.correctArgs(((MethodRequest)altrmiRequest).getArgs());
        }
        return altrmiRequest;
    }

    protected AltrmiReply postRequest(AltrmiRequest altrmiRequest) throws IOException, ClassNotFoundException {
        if (this.mIsStopped) {
            throw new AltrmiConnectionClosedException("Client Closed Connection");
        }
        this.writeRequest(altrmiRequest);
        AltrmiReply r = this.readReply();
        if (r == null) {
            throw new InterruptedIOException("Client Connection Closed");
        }
        this.mReply = null;
        return r;
    }

    private void writeRequest(AltrmiRequest altrmiRequest) throws IOException {
        byte[] aBytes = SerializationHelper.getBytesFromInstance((Object)altrmiRequest);
        this.mDataOutputStream.writeInt(aBytes.length);
        this.mDataOutputStream.write(aBytes);
        this.mDataOutputStream.flush();
    }

    private AltrmiReply readReply() throws IOException, ClassNotFoundException {
        return this.getReplyFromMessageLoop();
    }

    public void correctArgs(Object[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i] instanceof ExposedObjectProxy) {
                ExposedObjectProxy exposedObjectProxy = (ExposedObjectProxy)args[i];
                try {
                    Object obj;
                    args[i] = obj = this.mAltrmiFactory.lookup(exposedObjectProxy.getPublishedName());
                }
                catch (Exception altrmiConnectionException) {
                    altrmiConnectionException.printStackTrace();
                }
            }
            ++i;
        }
    }
}

