/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.monitor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.avalon.excalibur.monitor.StreamResource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;

public final class SourceResource
extends StreamResource {
    private final Source m_source;
    private SourceValidity m_validity;

    public SourceResource(Source source) throws Exception {
        super(source.getSystemId());
        this.m_source = source;
        this.m_previousModified = System.currentTimeMillis();
        this.m_validity = source.getValidity();
    }

    public long lastModified() {
        if (this.m_validity == null) {
            return System.currentTimeMillis();
        }
        SourceValidity newVal = this.m_source.getValidity();
        if (newVal != null && this.m_validity.isValid(newVal)) {
            return this.m_previousModified;
        }
        this.m_validity = newVal;
        return System.currentTimeMillis();
    }

    public InputStream getResourceAsStream() throws IOException {
        try {
            return this.m_source.getInputStream();
        }
        catch (SourceException se) {
            throw new IOException("SourceException: " + se.getMessage());
        }
    }

    public Reader getResourceAsReader() throws IOException {
        return new InputStreamReader(this.getResourceAsStream());
    }

    public OutputStream setResourceAsStream() throws IOException {
        throw new IOException("setResourceAsStream() not supported for URLResource");
    }

    public Writer setResourceAsWriter() throws IOException {
        throw new IOException("setResourceAsWriter() not supported for URLResource");
    }

    public Source getSource() {
        return this.m_source;
    }
}

