/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.constants.Node;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

import java.util.Enumeration;
import java.util.Hashtable;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: Jul 28, 2003
 * Time: 12:07:43 PM
 * To change this template use Options | File Templates.
 */
//TODO: make bounds element part of the collectKey

public class ElementCountTransformation extends AbstractTransformation {

    int noKeys = -1;
    String boundsElem = null;

    boolean withinBoundsElem = false;
    Hashtable counter = new Hashtable();
    StringBuffer content = null;
    String collectKey = "";

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        noKeys = super.transParameters.getNames().length;
        if (noKeys > 0) {
            try {
                boundsElem = super.transParameters.getParameter("boundsElem");
            } catch (ParameterException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
        }
    }

    protected void count(String uri, String loc, String raw, Attributes atts) {
        //looking for elemName{1*} values equal to 'loc' or 'raw'
        for (int i = 0; i < noKeys; i++) {
            String intString = Integer.toString(i);
            String elemParamKey = "elemName" + intString;
            String elemName = transParameters.getParameter(elemParamKey, null);
            String attParamKey = "attName" + intString;
            String attName = transParameters.getParameter(attParamKey, null);
            String attValParamKey = "attValue" + intString;
            String attValue = transParameters.getParameter(attValParamKey, null);
            if (Utilities.checkString(elemName)) {
                String elemCountKey = null;
                if (elemName.equals(loc))
                    elemCountKey = loc;
                else if (elemName.equals(raw))
                    elemCountKey = raw;
                if (Utilities.checkString(elemCountKey)) {
                    elemCountKey = "elem_" + elemCountKey;
                    this.collectKey = elemCountKey;
                    this.content = new StringBuffer();
                }
            }
            //looking for attName{1*} values equal to 'raw'
            else if (Utilities.checkString(attName)) {
                String attCountKey = null;
                String attVal = atts.getValue(attName);
                if (Utilities.checkString(attValue))
                    attCountKey = "attName_" + attName + "%%" + attVal;
                if (Utilities.checkString(attCountKey)) {
                    this.collectKey = attCountKey;
                    this.content = new StringBuffer();
                }
            }
            //looking for attValue{1*} values equal to 'raw'
            else if (Utilities.checkString(attValue)) {
                String attCountKey = null;
                for (int j = 0; j < atts.getLength(); j++) {
                    String attNameLoc = atts.getLocalName(j);
                    String attVal = atts.getValue(j);
                    if (attValue.equals(attVal)) {
                        attCountKey = "attValue_" + attNameLoc + "%%" + attValue;
                        if (Utilities.checkString(attCountKey)) {
                            this.collectKey = attCountKey;
                            this.content = new StringBuffer();
                        }

                    }

                }
            }

        }
    }


    public void startElement(String uri, String loc, String raw, Attributes a)
            throws SAXException {
        super.startElement(uri, loc, raw, a);
        if (!withinBoundsElem) {
            if (boundsElem.equals(loc) || boundsElem.equals(raw)) {
                this.resetFields();
                withinBoundsElem = true;
            }
        } else if (withinBoundsElem)
            count(uri, loc, raw, a);

    }


    public void endElement(String uri, String loc, String raw)
            throws SAXException {
        if (withinBoundsElem) {
            if (this.content != null) {
                String content = this.content.toString();
                String contentKey = this.collectKey + "%%%" + content;
                Integer occurence = (Integer) counter.get(contentKey);
                if (occurence != null) {
                    int occurInt = occurence.intValue();
                    occurence = new Integer(++occurInt);
                } else
                    occurence = new Integer(1);
                this.counter.put(contentKey, occurence);
                this.collectKey = "";
            }
            if (boundsElem.equals(loc) || boundsElem.equals(raw)) {
                withinBoundsElem = false;
                sendSummary();
                this.resetFields();
            }

            this.content = null;
        }

        super.endElement(uri, loc, raw);

    }

    protected void sendSummary() throws SAXException {
        Enumeration keys = counter.keys();
        while (keys.hasMoreElements()) {
            String key = (String) keys.nextElement();
            Integer value = (Integer) counter.get(key);
            String countType = "";
            String countName = key.substring(key.indexOf("_") + 1, key.indexOf("%%"));
            String nodeValue = key.substring(key.indexOf("%%%") + 3, key.length());
            char[] chars = nodeValue.toCharArray();
            AttributesImpl atts = new AttributesImpl();
            if (key.startsWith("elem_")) {
                countType = "element";
            } else if (key.startsWith("attName_")) {
                countType = "attributeName";
                String attValue = key.substring(key.indexOf("%%") + 2, key.indexOf("%%%"));
                atts.addAttribute("", "att-value", "att-value", Node.Type.CDATA, attValue);
            } else if (key.startsWith("attValue_")) {
                countType = "attributeValue";
                atts.addAttribute("", "count-value", "count-value", Node.Type.CDATA, key.substring(key.indexOf("%%") + 2, key.indexOf("%%%")));
            }
            atts.addAttribute("", "count-type", "count-type", Node.Type.CDATA, countType);
            atts.addAttribute("", "count-name", "count-name", Node.Type.CDATA, countName);
            atts.addAttribute("", "occurs", "occurs", Node.Type.CDATA, value.toString());
            super.startElement("", "count", "count", atts);
            super.characters(chars, 0, chars.length);
            super.endElement("", "count", "count");
        }
    }

    protected void resetFields() {
        withinBoundsElem = false;
        counter = new Hashtable();
        content = null;
        collectKey = "";
    }

    public void characters(char c[], int start, int len)
            throws SAXException {
        super.characters(c, start, len);
        if (withinBoundsElem) {
            if (this.content != null)
                this.content.append(c, start, len);
        }
    }


}
