<?xml version="1.0" encoding="UTF-8"?>
<!--
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx" exclude-result-prefixes="sdx">
    <xsl:import href="skin.xsl"/>
    <!-- list of terms -->
    <xsl:template match="sdx:terms">
        <br/>
        <h2>Liste des titres</h2>
        <table width="100%" cellpadding="0" cellspacing="0" border="0">
            <tr>
                <td class="highlight">
                    <div>
                        <xsl:call-template name="sdx:results-head">
                            <xsl:with-param name="search"/>
                        </xsl:call-template>
                    </div>
                </td>
            </tr>
        </table>
        <br/>
        <xsl:apply-templates/>
        <xsl:if test="not(sdx:term)">
			Aucun document document indexé.
			</xsl:if>
        <br/>
        <div class="highlight">
            <xsl:call-template name="sdx:results-foot">
                <xsl:with-param name="search"/>
            </xsl:call-template>
        </div>
    </xsl:template>
    <!-- generic term matching -->
    <xsl:template match="sdx:term">
        <div>
            <b>
                <xsl:value-of select="@no"/>
            </b>
            <xsl:text>&#160;</xsl:text>
            <xsl:choose>
                <xsl:when test="@id">
                    <a href="document.xsp?id={@id}&amp;base={@base}&amp;app={@app}">
                        &#160;<xsl:value-of select="@value"/>
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <a href="results.xsp?v={@escapedValue}&amp;f=titre">
                        &#160;<xsl:value-of select="@value"/>
                    </a>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="@dbId='apps'"> (notice)</xsl:when>
                <xsl:when test="@dbId='sites'"> (site)</xsl:when>
            </xsl:choose>
        </div>
    </xsl:template>
</xsl:stylesheet>
