/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail;

import java.io.IOException;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.mail.search.FromStringTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.mail.MailContext;
import org.apache.cocoon.mail.command.AbstractMailCommand;
import org.apache.cocoon.mail.command.MailCommands;

public class MailCommandManager
extends AbstractLogEnabled {
    public static final String DEFAULT_FOLDER_NAME = "INBOX";
    public static final String DEFAULT_FOLDER_PATTERN = "%";
    public static final String CONTEXT_FOLDER_ENTRY = "folder";
    public static final String CONTEXT_UID_ENTRY = "uid";
    public static final String CONTEXT_ID_ENTRY = "id";
    public static final String CONTEXT_PARTID_ENTRY = "part-id";
    public static final String CONTEXT_FOLDER_PATTERN_ENTRY = "folder-pattern";
    public static final String CONTEXT_MAX_FOLDER_LEVEL_ENTRY = "max-folder-level";

    public static void openFolder(Folder f, int mode) throws MessagingException {
        if (!f.isOpen()) {
            f.open(mode);
        }
    }

    public static void closeFolder(Folder f) throws MessagingException {
        if (f != null && f.isOpen()) {
            f.close(false);
        }
    }

    public static void openStore(Store s) throws MessagingException {
        if (!s.isConnected()) {
            s.connect();
        }
    }

    public static void closeStore(Store s) throws MessagingException {
        if (s != null && s.isConnected()) {
            s.close();
        }
    }

    public List execute(List aList) {
        MailCommands folderCommands = new MailCommands(aList);
        try {
            folderCommands.execute();
        }
        catch (MessagingException me) {
            this.getLogger().error("Cannot execute", (Throwable)me);
        }
        return folderCommands.getResults();
    }

    public List execute(AbstractMailCommand amfa) {
        try {
            amfa.execute();
        }
        catch (MessagingException me) {
            this.getLogger().error("Cannot execute", (Throwable)me);
        }
        return amfa.getResults();
    }

    public static class MailSearchMessagesCommand
    extends AbstractMailCommand
    implements Contextualizable {
        private Folder aFolder;
        private SearchTerm searchTerm;

        public void contextualize(Context ctx) throws ContextException {
            MailContext mctx = (MailContext)ctx;
            this.aFolder = mctx.getTheFolder(MailCommandManager.CONTEXT_FOLDER_ENTRY);
            String searchString = (String)ctx.get((Object)"param:search");
            if (searchString == null) {
                searchString = "";
            }
            this.searchTerm = new OrTerm((SearchTerm)new SubjectTerm(searchString), (SearchTerm)new FromStringTerm(searchString));
        }

        public void execute() throws MessagingException {
            MailCommandManager.openFolder(this.aFolder, 1);
            this.addResult(this.aFolder);
            Message[] msgs = this.aFolder.search(this.searchTerm);
            this.addResult(msgs);
        }
    }

    public static class MailCatAttachmentMessageByIdCommand
    extends AbstractMailCommand
    implements Contextualizable {
        private int msgId = -1;
        private int partId = -1;
        private Folder aFolder;

        public void contextualize(Context ctx) throws ContextException {
            MailContext mctx = (MailContext)ctx;
            this.aFolder = mctx.getTheFolder(MailCommandManager.CONTEXT_FOLDER_ENTRY);
            Integer i = (Integer)ctx.get((Object)"param-integer:id");
            if (i == null) {
                String message = "Missing mandatory context entry " + String.valueOf(MailCommandManager.CONTEXT_ID_ENTRY);
                throw new ContextException(message);
            }
            this.msgId = i;
            i = (Integer)ctx.get((Object)"param-integer:part-id");
            if (i == null) {
                String message = "Missing mandatory context entry " + String.valueOf(MailCommandManager.CONTEXT_PARTID_ENTRY);
                throw new ContextException(message);
            }
            this.partId = i;
        }

        public void execute() throws MessagingException {
            MailCommandManager.openFolder(this.aFolder, 1);
            this.addResult(this.aFolder);
            Message msg = this.aFolder.getMessage(this.msgId);
            if (msg == null) {
                String message = "Cannot get message for id " + String.valueOf(this.msgId);
                this.getLogger().warn(message);
                return;
            }
            try {
                BodyPart part = null;
                Object objRef = msg.getContent();
                if (!(objRef instanceof Multipart)) {
                    String message = "Message of id " + String.valueOf(this.msgId) + " is not a multipart message!";
                    this.getLogger().warn(message);
                    return;
                }
                Multipart multipart = (Multipart)objRef;
                int numParts = multipart.getCount();
                if (this.partId < numParts) {
                    part = multipart.getBodyPart(this.partId);
                } else {
                    String message = "Invalid part id " + String.valueOf(this.partId) + " of message id " + String.valueOf(this.msgId);
                    this.getLogger().warn(message);
                }
                this.addResult(part);
            }
            catch (IOException ioe) {
                String message = "Cannot get content of message for id " + String.valueOf(this.msgId);
                throw new MessagingException(message, ioe);
            }
        }
    }

    public static class MailCatMessageByIdCommand
    extends AbstractMailCommand
    implements Contextualizable {
        private int msgId = 1;
        private Folder aFolder;

        public void contextualize(Context ctx) throws ContextException {
            MailContext mctx = (MailContext)ctx;
            this.aFolder = mctx.getTheFolder(MailCommandManager.CONTEXT_FOLDER_ENTRY);
            try {
                Integer i = (Integer)ctx.get((Object)"param-integer:id");
                this.msgId = i;
            }
            catch (ContextException ce) {
                String message = "Missing mandatory context entry " + String.valueOf(MailCommandManager.CONTEXT_ID_ENTRY);
                throw new ContextException(message);
            }
        }

        public void execute() throws MessagingException {
            MailCommandManager.openFolder(this.aFolder, 1);
            this.addResult(this.aFolder);
            Message msg = this.aFolder.getMessage(this.msgId);
            this.addResult(msg);
        }
    }

    public static class MailCatMessageByUIDCommand
    extends AbstractMailCommand
    implements Contextualizable {
        private int msgUID = 1;
        private Folder aFolder;

        public void contextualize(Context ctx) throws ContextException {
            MailContext mctx = (MailContext)ctx;
            this.aFolder = mctx.getTheFolder(MailCommandManager.CONTEXT_FOLDER_ENTRY);
            Integer i = (Integer)ctx.get((Object)"param-integer:uid");
            if (i == null) {
                String message = "Missing mandatory context entry " + String.valueOf(MailCommandManager.CONTEXT_UID_ENTRY);
                throw new ContextException(message);
            }
            this.msgUID = i;
        }

        public void execute() throws MessagingException {
            UIDFolder uidFolder = (UIDFolder)this.aFolder;
            MailCommandManager.openFolder(this.aFolder, 1);
            this.addResult(this.aFolder);
            Message msg = uidFolder.getMessageByUID(this.msgUID);
            this.addResult(msg);
        }
    }

    public static class MailListFolderCommand
    extends AbstractMailCommand
    implements Contextualizable {
        private Folder aFolder;
        private String folderPattern = "%";

        public String getFolderPattern() {
            return this.folderPattern;
        }

        public void contextualize(Context ctx) throws ContextException {
            MailContext mctx = (MailContext)ctx;
            this.aFolder = mctx.getTheFolder(MailCommandManager.CONTEXT_FOLDER_ENTRY);
            try {
                this.folderPattern = (String)ctx.get((Object)"param:folder-pattern");
            }
            catch (ContextException ce) {
                this.folderPattern = MailCommandManager.DEFAULT_FOLDER_PATTERN;
            }
        }

        public void execute() throws MessagingException {
            Folder[] subFolders = this.aFolder.list(this.folderPattern);
            this.getLogger().debug("Adding " + String.valueOf(subFolders.length) + " subFolders ");
            int i = 0;
            while (i < subFolders.length) {
                this.getLogger().debug("subFolder " + String.valueOf(i) + " name " + subFolders[i].getFullName());
                ++i;
            }
            this.addResult(subFolders);
        }
    }

    public static class MailListMessagesCommand
    extends AbstractMailCommand
    implements Contextualizable {
        private Folder aFolder;

        public void contextualize(Context ctx) throws ContextException {
            MailContext mctx = (MailContext)ctx;
            this.aFolder = mctx.getTheFolder(MailCommandManager.CONTEXT_FOLDER_ENTRY);
        }

        public void execute() throws MessagingException {
            MailCommandManager.openFolder(this.aFolder, 1);
            this.addResult(this.aFolder);
            Message[] messages = this.aFolder.getMessages();
            FetchProfile fp = new FetchProfile();
            fp.add(FetchProfile.Item.ENVELOPE);
            fp.add(FetchProfile.Item.FLAGS);
            fp.add("X-Mailer");
            this.aFolder.fetch(messages, fp);
            this.addResult(messages);
        }
    }

    public static class MailRefreshFolderCommand
    extends AbstractMailCommand
    implements Contextualizable {
        private Folder aFolder;

        public void contextualize(Context ctx) throws ContextException {
            MailContext mctx = (MailContext)ctx;
            this.aFolder = mctx.getTheFolder(MailCommandManager.CONTEXT_FOLDER_ENTRY);
        }

        public void execute() throws MessagingException {
            MailCommandManager.closeFolder(this.aFolder);
            MailCommandManager.openFolder(this.aFolder, 1);
            this.addResult(this.aFolder);
        }
    }

    public static class MailFolderCatCommand
    extends AbstractMailCommand
    implements Contextualizable {
        private Folder aFolder;

        public void contextualize(Context ctx) throws ContextException {
            MailContext mctx = (MailContext)ctx;
            this.aFolder = mctx.getTheFolder(MailCommandManager.CONTEXT_FOLDER_ENTRY);
        }

        public void execute() throws MessagingException {
            MailCommandManager.openFolder(this.aFolder, 1);
            this.addResult(this.aFolder);
        }
    }
}

