/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.ParameterList;
import javax.mail.internet.ParseException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.mail.ContentTypePreference;
import org.apache.cocoon.mail.MailCtPref;
import org.apache.excalibur.xml.sax.XMLizable;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class MailContentHandlerDelegate
extends AbstractLogEnabled {
    public static final String URI = "http://apache.org/cocoon/mail/1.0";
    public static final String PREFIX = "mail";
    private ContentHandler contentHandler;
    private AttributesImpl attributes = null;
    private SimpleDateFormat sdf;
    private ContentTypePreference alternativeMailCtPref = new MailCtPref();

    public MailContentHandlerDelegate(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void setSimpleDateFormat(SimpleDateFormat sdf) {
        this.sdf = sdf;
    }

    public SimpleDateFormat getSimpleDateFormat() {
        return this.sdf;
    }

    public void startDocument() throws SAXException {
        this.startDocumentInternal(true);
    }

    public void startDocumentXMLizer() throws SAXException {
        this.startDocumentInternal(false);
    }

    public void endDocument() throws SAXException {
        this.endDocumentInternal(true);
    }

    public void endDocumentXMLizer() throws SAXException {
        this.endDocumentInternal(false);
    }

    public void marshalFolderToSAX(Folder folder) {
        try {
            this.folderToSAX(this.contentHandler, folder);
        }
        catch (Exception e) {
            this.getLogger().error("Cannot generate SAX events from folder", (Throwable)e);
        }
    }

    public void marshalFolderToSAX(Folder[] folders) {
        try {
            int i = 0;
            while (i < folders.length) {
                this.folderToSAX(this.contentHandler, folders[i]);
                ++i;
            }
        }
        catch (Exception e) {
            this.getLogger().error("Cannot generate SAX events from folders", (Throwable)e);
        }
    }

    public void marshalMessageEnvelopeToSAX(Message message) {
        try {
            this.messageEnvelopeToSAX(this.contentHandler, message);
        }
        catch (Exception e) {
            this.getLogger().error("Cannot generate SAX events from message envelope ", (Throwable)e);
        }
    }

    public void marshalMessageToSAX(Message message) {
        try {
            this.messageEnvelopeToSAX(this.contentHandler, message);
            this.partToSAX(this.contentHandler, (Part)message, 0);
        }
        catch (Exception e) {
            this.getLogger().error("Cannot generate SAX events from message ", (Throwable)e);
        }
    }

    public void marshalPartToSAX(Part part) {
        try {
            this.partToSAX(this.contentHandler, part, 0);
        }
        catch (Exception e) {
            this.getLogger().error("Cannot generate SAX events part", (Throwable)e);
        }
    }

    protected void startDocumentInternal(boolean emitStartDocument) throws SAXException {
        if (emitStartDocument) {
            this.contentHandler.startDocument();
        }
        this.contentHandler.startPrefixMapping(PREFIX, URI);
        this.attributes = new AttributesImpl();
        this.attributes.clear();
        this.attributes.addAttribute("", PREFIX, "xmlns:mail", "CDATA", URI);
        this.startElement(PREFIX, this.attributes);
    }

    protected void endDocumentInternal(boolean emitEndDocument) throws SAXException {
        this.endElement(PREFIX);
        this.contentHandler.endPrefixMapping(PREFIX);
        if (emitEndDocument) {
            this.contentHandler.endDocument();
        }
    }

    protected void folderToSAX(ContentHandler contentHandler, Folder folder) throws MessagingException, SAXException {
        this.attributes.clear();
        this.addAttribute("name", folder.getName());
        this.addAttribute("full-name", folder.getFullName());
        this.addAttribute("url-name", folder.getURLName().toString());
        this.addAttribute("is-subscribed", folder.isSubscribed() ? "yes" : "no");
        this.addAttribute("is-directory", (folder.getType() & 2) != 0 ? "yes" : "no");
        if ((folder.getType() & 1) != 0) {
            this.addAttribute("holds-messages", "yes");
            this.addAttribute("has-new-messages", folder.hasNewMessages() ? "yes" : "no");
            this.addAttribute("total-messages", String.valueOf(folder.getMessageCount()));
            this.addAttribute("new-messages", String.valueOf(folder.getNewMessageCount()));
            this.addAttribute("deleted-messages", String.valueOf(folder.getDeletedMessageCount()));
            this.addAttribute("unread-messages", String.valueOf(folder.getUnreadMessageCount()));
        }
        this.startElement("folder", this.attributes);
        this.endElement("folder");
    }

    protected void messageEnvelopeToSAX(ContentHandler contentHandler, Message message) throws MessagingException, SAXException {
        int j;
        this.attributes.clear();
        this.startElement("message-envelope", this.attributes);
        Address[] a = message.getFrom();
        if (a != null) {
            j = 0;
            while (j < a.length) {
                this.emitAddress("from", a[j]);
                ++j;
            }
        }
        if ((a = message.getRecipients(Message.RecipientType.TO)) != null) {
            j = 0;
            while (j < a.length) {
                this.emitAddress("to", a[j]);
                ++j;
            }
        }
        if ((a = message.getRecipients(Message.RecipientType.CC)) != null) {
            j = 0;
            while (j < a.length) {
                this.emitAddress("cc", a[j]);
                ++j;
            }
        }
        if ((a = message.getRecipients(Message.RecipientType.BCC)) != null) {
            j = 0;
            while (j < a.length) {
                this.emitAddress("bcc", a[j]);
                ++j;
            }
        }
        if ((a = message.getReplyTo()) != null) {
            j = 0;
            while (j < a.length) {
                this.emitAddress("reply-to", a[j]);
                ++j;
            }
        }
        this.attributes.clear();
        this.startElement("subject", this.attributes);
        this.characters(message.getSubject());
        this.endElement("subject");
        Date d = message.getSentDate();
        this.emitDate("sent-date", d);
        d = message.getReceivedDate();
        this.emitDate("received-date", d);
        this.attributes.clear();
        this.startElement("size", this.attributes);
        this.characters(String.valueOf(message.getSize()));
        this.endElement("size");
        this.attributes.clear();
        this.startElement("message-number", this.attributes);
        this.characters(String.valueOf(message.getMessageNumber()));
        this.endElement("message-number");
        Flags flags = message.getFlags();
        Flags.Flag[] sf = flags.getSystemFlags();
        this.attributes.clear();
        int i = 0;
        while (i < sf.length) {
            Flags.Flag flag = sf[i];
            if (flag == Flags.Flag.ANSWERED) {
                this.addAttribute("answered", "yes");
            } else if (flag == Flags.Flag.DELETED) {
                this.addAttribute("deleted", "yes");
            } else if (flag == Flags.Flag.DRAFT) {
                this.addAttribute("draft", "yes");
            } else if (flag == Flags.Flag.FLAGGED) {
                this.addAttribute("flagged", "yes");
            } else if (flag == Flags.Flag.RECENT) {
                this.addAttribute("recent", "yes");
            } else if (flag == Flags.Flag.SEEN) {
                this.addAttribute("seen", "yes");
            }
            ++i;
        }
        this.startElement("flags", this.attributes);
        this.endElement("flags");
        String[] uf = flags.getUserFlags();
        int i2 = 0;
        while (i2 < uf.length) {
            this.attributes.clear();
            this.startElement("user-flags", this.attributes);
            this.characters(uf[i2]);
            this.endElement("user-flags");
            ++i2;
        }
        Enumeration allHeaders = message.getAllHeaders();
        if (allHeaders != null) {
            while (allHeaders.hasMoreElements()) {
                Header header = (Header)allHeaders.nextElement();
                this.attributes.clear();
                this.addAttribute("name", header.getName());
                this.addAttribute("value", header.getValue());
                this.startElement("header", this.attributes);
                this.endElement("header");
            }
        }
        this.endElement("message-envelope");
    }

    protected void partToSAX(ContentHandler contentHandler, Part part, int i) throws MessagingException, IOException, SAXException {
        this.attributes.clear();
        String v = part.getContentType();
        if (v != null) {
            this.addAttribute("content-type", v);
            try {
                ContentType ct = new ContentType(v);
                String s = ct.getPrimaryType();
                if (s != null) {
                    this.addAttribute("primary-type", s.toLowerCase());
                }
                if ((s = ct.getSubType()) != null) {
                    this.addAttribute("secondary-type", s.toLowerCase());
                }
                if ((s = ct.getBaseType()) != null) {
                    this.addAttribute("base-type", s.toLowerCase());
                }
                ParameterList pl = ct.getParameterList();
                Enumeration names = pl.getNames();
                while (names.hasMoreElements()) {
                    String key = (String)names.nextElement();
                    String value = pl.get(key);
                    this.addAttribute(key, value);
                }
            }
            catch (ParseException pe) {
                String message = "Cannot parse content-type " + String.valueOf(v);
                this.getLogger().error(message, (Throwable)pe);
            }
        }
        if (i > 0) {
            this.addAttribute("part-num", String.valueOf(i));
            if (part.getDescription() != null) {
                this.addAttribute("description", part.getDescription());
            }
            if (part.getDisposition() != null) {
                this.addAttribute("disposition", part.getDisposition());
                this.addAttribute("disposition-inline", String.valueOf(part.getDisposition().equals(Part.INLINE)));
            }
            if (part.getFileName() != null) {
                this.addAttribute("file-name", part.getFileName());
            }
        } else {
            Multipart mp;
            boolean hasAttachments = false;
            if (part.isMimeType("multipart/*") && (mp = (Multipart)part.getContent()).getCount() > 1) {
                hasAttachments = true;
                this.addAttribute("num-parts", String.valueOf(mp.getCount()));
            }
            this.addAttribute("has-attachments", String.valueOf(hasAttachments));
        }
        this.startElement("part", this.attributes);
        this.contentToSAX(contentHandler, part);
        this.endElement("part");
    }

    protected void contentToSAX(ContentHandler contentHandler, Part part) throws MessagingException, IOException, SAXException {
        this.attributes.clear();
        this.startElement("content", this.attributes);
        if (part.getContent() instanceof String && part.isMimeType("text/plain")) {
            this.characters((String)part.getContent());
        } else if (part.isMimeType("multipart/alternative")) {
            MimeMultipart mp = (MimeMultipart)part.getContent();
            MimePart bestPart = null;
            int ctMax = 0;
            int i = 0;
            while (i < mp.getCount()) {
                MimePart p = (MimePart)mp.getBodyPart(i);
                int ctPrefN = this.alternativeMailCtPref.preference(p);
                if (ctPrefN > ctMax) {
                    ctMax = ctPrefN;
                    bestPart = p;
                }
                ++i;
            }
            if (bestPart != null) {
                this.partToSAX(contentHandler, (Part)bestPart, 0);
            }
        } else if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            int i = 0;
            while (i < count) {
                this.partToSAX(contentHandler, (Part)mp.getBodyPart(i), i);
                ++i;
            }
        } else if (part.isMimeType("message/rfc822")) {
            this.partToSAX(contentHandler, (Part)part.getContent(), 0);
        }
        this.endElement("content");
    }

    protected void emitAddress(String nodeName, Address address) throws SAXException {
        this.attributes.clear();
        if (address instanceof InternetAddress) {
            String emailAddress;
            InternetAddress internetAddress = (InternetAddress)address;
            String personal = internetAddress.getPersonal();
            if (personal != null) {
                this.addAttribute("personal", personal);
            }
            if ((emailAddress = internetAddress.getAddress()) != null) {
                this.addAttribute("email-address", emailAddress);
            }
        }
        this.startElement(nodeName, this.attributes);
        String addressAsString = address.toString();
        this.characters(addressAsString);
        this.endElement(nodeName);
    }

    protected void emitDate(String nodeName, Date d) throws SAXException {
        this.attributes.clear();
        this.startElement(nodeName, this.attributes);
        if (d != null) {
            if (this.sdf != null) {
                String formattedDate = this.sdf.format(d);
                this.characters(formattedDate);
            } else {
                this.characters(d.toString());
            }
        }
        this.endElement(nodeName);
    }

    private void startElement(String nodeName, Attributes attributes) throws SAXException {
        this.contentHandler.startElement(URI, nodeName, "mail:" + nodeName, attributes);
    }

    private void characters(String s) throws SAXException {
        if (s != null) {
            StringBuffer sb = new StringBuffer();
            char[] stringCharacters = s.toCharArray();
            int i = 0;
            while (i < stringCharacters.length) {
                if (stringCharacters[i] != '\r') {
                    sb.append(stringCharacters[i]);
                }
                ++i;
            }
            stringCharacters = sb.toString().toCharArray();
            this.contentHandler.characters(stringCharacters, 0, stringCharacters.length);
        }
    }

    private void endElement(String nodeName) throws SAXException {
        this.contentHandler.endElement(URI, nodeName, "mail:" + nodeName);
    }

    private void addAttribute(String nodeName, String nodeValue) {
        this.attributes.addAttribute("", nodeName, nodeName, "CDATA", nodeValue);
    }

    static class MessageXMLizer
    extends AbstractLogEnabled
    implements XMLizable {
        private Message message;
        private SimpleDateFormat sdf;

        public MessageXMLizer(Message message) {
            this.message = message;
        }

        public void setSimpleDateFormat(SimpleDateFormat sdf) {
            this.sdf = sdf;
        }

        public void getSimpleDateFormat(SimpleDateFormat sdf) {
            this.sdf = sdf;
        }

        public void toSAX(ContentHandler handler) throws SAXException {
            MailContentHandlerDelegate mailContentHandlerDelegate = new MailContentHandlerDelegate(handler);
            mailContentHandlerDelegate.enableLogging(this.getLogger());
            mailContentHandlerDelegate.setSimpleDateFormat(this.sdf);
            mailContentHandlerDelegate.startDocumentXMLizer();
            mailContentHandlerDelegate.marshalMessageToSAX(this.message);
            mailContentHandlerDelegate.endDocumentXMLizer();
        }
    }

    static class MessageEnvelopeXMLizer
    extends AbstractLogEnabled
    implements XMLizable {
        private Message[] messages;
        private SimpleDateFormat sdf;

        public MessageEnvelopeXMLizer(Message message) {
            this.messages = new Message[1];
            this.messages[0] = message;
        }

        public MessageEnvelopeXMLizer(Message[] messages) {
            this.messages = messages;
        }

        public void setSimpleDateFormat(SimpleDateFormat sdf) {
            this.sdf = sdf;
        }

        public void getSimpleDateFormat(SimpleDateFormat sdf) {
            this.sdf = sdf;
        }

        public void toSAX(ContentHandler handler) throws SAXException {
            MailContentHandlerDelegate mailContentHandlerDelegate = new MailContentHandlerDelegate(handler);
            mailContentHandlerDelegate.enableLogging(this.getLogger());
            mailContentHandlerDelegate.setSimpleDateFormat(this.sdf);
            mailContentHandlerDelegate.startDocumentXMLizer();
            int i = 0;
            while (i < this.messages.length) {
                mailContentHandlerDelegate.marshalMessageEnvelopeToSAX(this.messages[i]);
                ++i;
            }
            mailContentHandlerDelegate.endDocumentXMLizer();
        }
    }

    static class FolderXMLizer
    extends AbstractLogEnabled
    implements XMLizable {
        private Folder[] folders;

        FolderXMLizer(Folder folder) {
            this.folders = new Folder[]{folder};
        }

        FolderXMLizer(Folder[] folders) {
            this.folders = folders;
        }

        public void toSAX(ContentHandler handler) throws SAXException {
            MailContentHandlerDelegate mailContentHandlerDelegate = new MailContentHandlerDelegate(handler);
            mailContentHandlerDelegate.enableLogging(this.getLogger());
            mailContentHandlerDelegate.startDocumentXMLizer();
            int i = 0;
            while (i < this.folders.length) {
                mailContentHandlerDelegate.marshalFolderToSAX(this.folders[i]);
                ++i;
            }
            mailContentHandlerDelegate.endDocumentXMLizer();
        }
    }
}

