/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.mail.datasource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.apache.excalibur.source.Source;

public class SourceDataSource
implements DataSource {
    private Source src;
    private String contentType = null;
    private String name = null;

    public SourceDataSource(Source src) {
        this(src, null, null);
    }

    public SourceDataSource(Source src, String type, String name) {
        this.src = src;
        this.contentType = type;
        this.name = name;
        if (this.isNullOrEmpty(this.name)) {
            this.name = null;
        }
        if (this.isNullOrEmpty(this.contentType)) {
            this.contentType = null;
        }
    }

    private boolean isNullOrEmpty(String str) {
        return str == null || "".equals(str) || "null".equals(str);
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        String mimeType = this.src.getMimeType();
        if (this.isNullOrEmpty(mimeType)) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    public InputStream getInputStream() throws IOException {
        return this.src.getInputStream();
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        String name = this.src.getURI();
        return "".equals(name = name.substring(name.lastIndexOf(47) + 1)) ? "attachment" : name;
    }

    public OutputStream getOutputStream() throws IOException {
        throw new IOException("no data sink available");
    }
}

