/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.authentication.context;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.webapps.authentication.components.DefaultAuthenticationManager;
import org.apache.cocoon.webapps.authentication.configuration.ApplicationConfiguration;
import org.apache.cocoon.webapps.authentication.user.RequestState;
import org.apache.cocoon.webapps.authentication.user.UserHandler;
import org.apache.cocoon.webapps.session.context.SessionContext;
import org.apache.cocoon.webapps.session.context.SimpleSessionContext;
import org.apache.cocoon.xml.dom.DOMUtil;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public class AuthenticationContext
implements SessionContext {
    protected String name;
    protected UserHandler handler;
    protected SessionContext authContext;
    protected String handlerName;
    protected boolean initialized;
    protected Context context;
    protected XPathProcessor xpathProcessor;
    protected SourceResolver resolver;

    public AuthenticationContext(Context context, XPathProcessor processor, SourceResolver resolver) {
        this.context = context;
        this.xpathProcessor = processor;
        this.resolver = resolver;
    }

    public void init(UserHandler handler) {
        this.name = "authentication";
        this.handler = handler;
        this.handlerName = this.handler.getHandlerName();
        try {
            this.authContext = new SimpleSessionContext(this.xpathProcessor, this.resolver);
        }
        catch (ProcessingException pe) {
            throw new CascadingRuntimeException("Unable to create simple context.", (Throwable)pe);
        }
    }

    protected RequestState getState() {
        return DefaultAuthenticationManager.getRequestState(this.context);
    }

    public void init(Document doc) throws ProcessingException {
        if (this.initialized) {
            throw new ProcessingException("The context can only be initialized once.");
        }
        this.authContext.setNode("/", doc.getFirstChild());
    }

    public void setup(String value, String load, String save) {
    }

    public String getName() {
        return this.name;
    }

    /*
     * Unable to fully structure code
     */
    public DocumentFragment getXML(String path) throws ProcessingException {
        block12: {
            block11: {
                if (path == null) {
                    throw new ProcessingException("getXML: Path is required");
                }
                if (!path.startsWith("/")) {
                    path = '/' + path;
                }
                applicationName = this.getState().getApplicationName();
                frag = null;
                if (!path.equals("/")) break block11;
                frag = this.authContext.getXML("/authentication");
                if (frag != null) {
                    root = frag.getOwnerDocument().createElementNS(null, "authentication");
                    while (frag.hasChildNodes()) {
                        child = frag.getFirstChild();
                        frag.removeChild(child);
                        root.appendChild(child);
                    }
                    frag.appendChild(root);
                }
                if (applicationName == null || (appFrag = this.authContext.getXML("/applications/" + applicationName)) == null) break block12;
                root = appFrag.getOwnerDocument().createElementNS(null, "application");
                while (appFrag.hasChildNodes()) {
                    child = appFrag.getFirstChild();
                    appFrag.removeChild(child);
                    root.appendChild(child);
                }
                appFrag.appendChild(root);
                if (frag != null) ** GOTO lbl40
                frag = appFrag;
                break block12;
lbl-1000:
                // 1 sources

                {
                    child = appFrag.getFirstChild();
                    appFrag.removeChild(child);
                    child = frag.getOwnerDocument().importNode(child, true);
                    frag.appendChild(child);
lbl40:
                    // 2 sources

                    ** while (appFrag.hasChildNodes())
                }
lbl41:
                // 1 sources

                break block12;
            }
            if (path.startsWith("/authentication")) {
                frag = this.authContext.getXML(path);
            } else if (path.equals("/application") || path.startsWith("/application/")) {
                if (applicationName != null) {
                    appPath = path.equals("/application") != false ? "/" : path.substring("/application".length());
                    frag = this.authContext.getXML("/applications/" + applicationName + appPath);
                }
            } else {
                frag = this.authContext.getXML(path);
            }
        }
        return frag;
    }

    public void setXML(String path, DocumentFragment fragment) throws ProcessingException {
        if (path == null) {
            throw new ProcessingException("setXML: Path is required");
        }
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        String applicationName = this.getState().getApplicationName();
        if (path.equals("/")) {
            throw new ProcessingException("Path '/' is not allowed");
        }
        if (path.startsWith("/authentication")) {
            this.cleanParametersCache();
            this.authContext.setXML(path, fragment);
        } else if (path.equals("/application") || path.startsWith("/application/")) {
            if (applicationName == null) {
                throw new ProcessingException("Application is required");
            }
            String appPath = path.equals("/application") ? "/" : path.substring("/application".length());
            this.authContext.setXML("/applications/" + applicationName + appPath, fragment);
        } else {
            this.authContext.setXML(path, fragment);
        }
    }

    public void appendXML(String path, DocumentFragment fragment) throws ProcessingException {
        if (path == null) {
            throw new ProcessingException("appendXML: Path is required");
        }
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        String applicationName = this.getState().getApplicationName();
        if (path.equals("/")) {
            throw new ProcessingException("Path '/' is not allowed");
        }
        if (path.startsWith("/authentication")) {
            this.cleanParametersCache();
            this.authContext.appendXML(path, fragment);
        } else if (path.equals("/application") || path.startsWith("/application/")) {
            if (applicationName == null) {
                throw new ProcessingException("Application is required");
            }
            String appPath = path.equals("/application") ? "/" : path.substring("/application".length());
            this.authContext.appendXML("/applications/" + applicationName + appPath, fragment);
        } else {
            this.authContext.appendXML(path, fragment);
        }
    }

    public void removeXML(String path) throws ProcessingException {
        if (path == null) {
            throw new ProcessingException("removeXML: Path is required");
        }
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        String applicationName = this.getState().getApplicationName();
        if (path.equals("/")) {
            this.cleanParametersCache();
            this.authContext.removeXML("/");
        } else if (path.startsWith("/authentication")) {
            this.cleanParametersCache();
            this.authContext.removeXML(path);
        } else if (path.equals("/application") || path.startsWith("/application/")) {
            if (applicationName == null) {
                throw new ProcessingException("removeXML: Application is required for path " + path);
            }
            String appPath = path.equals("/application") ? "/" : path.substring("/application".length());
            this.authContext.removeXML("/applications/" + applicationName + appPath);
        } else {
            this.authContext.removeXML(path);
        }
    }

    public void setAttribute(String key, Object value) throws ProcessingException {
        this.authContext.setAttribute(key, value);
    }

    public Object getAttribute(String key) throws ProcessingException {
        return this.authContext.getAttribute(key);
    }

    public Object getAttribute(String key, Object defaultObject) throws ProcessingException {
        return this.authContext.getAttribute(key, defaultObject);
    }

    public Node getSingleNode(String path) throws ProcessingException {
        throw new ProcessingException("This method is not supported by the authenticaton session context.");
    }

    public NodeList getNodeList(String path) throws ProcessingException {
        throw new ProcessingException("This method is not supported by the authenticaton session context.");
    }

    public void setNode(String path, Node node) throws ProcessingException {
        throw new ProcessingException("This method is not supported by the authenticaton session context.");
    }

    public String getValueOfNode(String path) throws ProcessingException {
        throw new ProcessingException("This method is not supported by the authenticaton session context.");
    }

    public void setValueOfNode(String path, String value) throws ProcessingException {
        throw new ProcessingException("This method is not supported by the authenticaton session context.");
    }

    public boolean streamXML(String path, ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException, ProcessingException {
        if (path == null) {
            throw new ProcessingException("streamXML: Path is required");
        }
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        String applicationName = this.getState().getApplicationName();
        if (path.equals("/")) {
            contentHandler.startElement("", "authentication", "authentication", new AttributesImpl());
            this.authContext.streamXML("/authentication", contentHandler, lexicalHandler);
            contentHandler.endElement("", "authentication", "authentication");
            if (applicationName != null) {
                contentHandler.startElement("", "application", "application", new AttributesImpl());
                this.authContext.streamXML("/applications/" + applicationName, contentHandler, lexicalHandler);
                contentHandler.endElement("", "application", "application");
            }
            return true;
        }
        if (path.startsWith("/authentication")) {
            return this.authContext.streamXML(path, contentHandler, lexicalHandler);
        }
        if (path.equals("/application") || path.startsWith("/application/")) {
            if (applicationName != null) {
                String appPath = path.equals("/application") ? "/" : path.substring("/application".length());
                return this.authContext.streamXML("/applications/" + applicationName + appPath, contentHandler, lexicalHandler);
            }
        } else {
            return this.authContext.streamXML(path, contentHandler, lexicalHandler);
        }
        return false;
    }

    public void loadXML(String path, SourceParameters parameters) throws SAXException, ProcessingException, IOException {
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        String applicationName = this.getState().getApplicationName();
        if (path.equals("/")) {
            this.loadAuthenticationXML("/authentication", parameters, this.resolver);
            if (applicationName != null) {
                this.loadApplicationXML("/", parameters, this.resolver);
            }
        } else if (path.startsWith("/authentication")) {
            this.loadAuthenticationXML(path, parameters, this.resolver);
        } else if (path.equals("/application") && applicationName != null) {
            this.loadApplicationXML("/", parameters, this.resolver);
        } else if (path.startsWith("/application/") && applicationName != null) {
            this.loadApplicationXML(path.substring(12), parameters, this.resolver);
        } else {
            throw new ProcessingException("loadXML: Path is not valid: " + path);
        }
    }

    public void saveXML(String path, SourceParameters parameters) throws SAXException, ProcessingException, IOException {
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        String applicationName = this.getState().getApplicationName();
        if (path.equals("/")) {
            this.saveAuthenticationXML("/authentication", parameters, this.resolver);
            if (applicationName != null) {
                this.saveApplicationXML("/", parameters, this.resolver);
            }
        } else if (path.startsWith("/authentication")) {
            this.saveAuthenticationXML(path, parameters, this.resolver);
        } else if (path.equals("/application") && applicationName != null) {
            this.saveApplicationXML("/", parameters, this.resolver);
        } else if (path.startsWith("/application/") && applicationName != null) {
            this.saveApplicationXML(path.substring(12), parameters, this.resolver);
        } else {
            throw new ProcessingException("saveXML: Path is not valid: " + path);
        }
    }

    private void cleanParametersCache() throws ProcessingException {
        this.authContext.setAttribute("cachedmap", null);
        this.authContext.setAttribute("cachedpar", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAuthenticationXML(String path, SourceParameters parameters, SourceResolver resolver) throws ProcessingException {
        String authSaveResource = this.handler.getHandlerConfiguration().getSaveResource();
        SourceParameters authSaveResourceParameters = this.handler.getHandlerConfiguration().getSaveResourceParameters();
        if (authSaveResource == null) {
            throw new ProcessingException("The context " + this.name + " does not support saving.");
        }
        SessionContext sessionContext = this.authContext;
        synchronized (sessionContext) {
            DocumentFragment fragment = this.getXML(path);
            if (fragment == null) {
                fragment = DOMUtil.createDocument().createDocumentFragment();
            }
            if (parameters != null) {
                parameters = (SourceParameters)parameters.clone();
                parameters.add(authSaveResourceParameters);
            } else if (authSaveResourceParameters != null) {
                parameters = (SourceParameters)authSaveResourceParameters.clone();
            }
            parameters = this.createParameters(parameters, path, false);
            SourceUtil.writeDOM((String)authSaveResource, null, (SourceParameters)parameters, (DocumentFragment)fragment, (SourceResolver)resolver, (String)"xml");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAuthenticationXML(String path, SourceParameters parameters, SourceResolver resolver) throws ProcessingException {
        String authLoadResource = this.handler.getHandlerConfiguration().getLoadResource();
        SourceParameters authLoadResourceParameters = this.handler.getHandlerConfiguration().getLoadResourceParameters();
        if (authLoadResource == null) {
            throw new ProcessingException("The context " + this.name + " does not support loading.");
        }
        SessionContext sessionContext = this.authContext;
        synchronized (sessionContext) {
            if (parameters != null) {
                parameters = (SourceParameters)parameters.clone();
                parameters.add(authLoadResourceParameters);
            } else if (authLoadResourceParameters != null) {
                parameters = (SourceParameters)authLoadResourceParameters.clone();
            }
            parameters = this.createParameters(parameters, path, false);
            DocumentFragment frag = SourceUtil.readDOM((String)authLoadResource, null, (SourceParameters)parameters, (SourceResolver)resolver);
            this.setXML(path, frag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadApplicationXML(String path, SourceParameters parameters, SourceResolver resolver) throws ProcessingException {
        String applicationName = this.getState().getApplicationName();
        ApplicationConfiguration conf = (ApplicationConfiguration)this.handler.getHandlerConfiguration().getApplications().get(applicationName);
        String loadResource = conf.getLoadResource();
        SourceParameters loadResourceParameters = conf.getLoadResourceParameters();
        if (loadResource == null) {
            throw new ProcessingException("The context " + this.name + " does not support loading.");
        }
        SessionContext sessionContext = this.authContext;
        synchronized (sessionContext) {
            if (parameters != null) {
                parameters = (SourceParameters)parameters.clone();
                parameters.add(loadResourceParameters);
            } else if (loadResourceParameters != null) {
                parameters = (SourceParameters)loadResourceParameters.clone();
            }
            parameters = this.createParameters(parameters, path, true);
            DocumentFragment fragment = SourceUtil.readDOM((String)loadResource, null, (SourceParameters)parameters, (SourceResolver)resolver);
            this.authContext.setXML("/applications/" + applicationName + '/', fragment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveApplicationXML(String path, SourceParameters parameters, SourceResolver resolver) throws ProcessingException {
        String applicationName = this.getState().getApplicationName();
        ApplicationConfiguration conf = (ApplicationConfiguration)this.handler.getHandlerConfiguration().getApplications().get(applicationName);
        String saveResource = conf.getSaveResource();
        SourceParameters saveResourceParameters = conf.getSaveResourceParameters();
        if (saveResource == null) {
            throw new ProcessingException("The context " + this.name + " does not support saving.");
        }
        SessionContext sessionContext = this.authContext;
        synchronized (sessionContext) {
            if (parameters != null) {
                parameters = (SourceParameters)parameters.clone();
                parameters.add(saveResourceParameters);
            } else if (saveResourceParameters != null) {
                parameters = (SourceParameters)saveResourceParameters.clone();
            }
            parameters = this.createParameters(parameters, path, true);
            DocumentFragment fragment = this.getXML("/application" + path);
            if (fragment == null) {
                fragment = DOMUtil.createDocument().createDocumentFragment();
            }
            SourceUtil.writeDOM((String)saveResource, null, (SourceParameters)parameters, (DocumentFragment)fragment, (SourceResolver)resolver, (String)"xml");
        }
    }

    private SourceParameters createParameters(SourceParameters parameters, String path, boolean appendAppInfo) throws ProcessingException {
        if (parameters == null) {
            parameters = new SourceParameters();
        }
        String applicationName = this.getState().getApplicationName();
        this.addParametersFromAuthenticationXML("/data", parameters);
        this.addParametersFromAuthenticationXML("", parameters);
        parameters.setSingleParameterValue("handler", this.handlerName);
        if (appendAppInfo && applicationName != null) {
            parameters.setSingleParameterValue("application", applicationName);
        }
        if (path != null) {
            parameters.setSingleParameterValue("path", path);
        }
        return parameters;
    }

    private void addParametersFromAuthenticationXML(String path, SourceParameters parameters) throws ProcessingException {
        NodeList childs;
        DocumentFragment fragment = this.authContext.getXML("/authentication" + path);
        if (fragment != null && (childs = fragment.getChildNodes()) != null) {
            int i = 0;
            while (i < childs.getLength()) {
                Node current = childs.item(i);
                if (current.getNodeType() == 1) {
                    current.normalize();
                    NodeList valueChilds = current.getChildNodes();
                    String key = current.getNodeName();
                    StringBuffer valueBuffer = new StringBuffer();
                    int m = 0;
                    while (m < valueChilds.getLength()) {
                        current = valueChilds.item(m);
                        if (current.getNodeType() == 3) {
                            if (valueBuffer.length() > 0) {
                                valueBuffer.append(' ');
                            }
                            valueBuffer.append(current.getNodeValue());
                        }
                        ++m;
                    }
                    String value = valueBuffer.toString().trim();
                    if (key != null && value != null && value.length() > 0) {
                        parameters.setParameter(key, value);
                    }
                }
                ++i;
            }
        }
    }

    public Map getContextInfo() throws ProcessingException {
        HashMap<String, String> map = (HashMap<String, String>)this.authContext.getAttribute("cachedmap");
        if (map == null) {
            map = new HashMap<String, String>(20);
            Parameters pars = this.createParameters(null, null, false).getFirstParameters();
            String[] names = pars.getNames();
            if (names != null) {
                int i = 0;
                while (i < names.length) {
                    String key = names[i];
                    String value = pars.getParameter(key, null);
                    if (value != null) {
                        map.put(key, value);
                    }
                    ++i;
                }
            }
            this.authContext.setAttribute("cachedmap", map);
        }
        return map;
    }

    public SourceParameters getContextInfoAsParameters() throws ProcessingException {
        SourceParameters pars = (SourceParameters)this.authContext.getAttribute("cachedpar");
        if (pars == null) {
            pars = this.createParameters(null, null, false);
            this.authContext.setAttribute("cachedpar", (Object)pars);
        }
        return pars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadApplicationXML(ApplicationConfiguration appConf, SourceResolver resolver) throws ProcessingException {
        String loadResource = appConf.getLoadResource();
        SourceParameters loadResourceParameters = appConf.getLoadResourceParameters();
        if (!this.handler.isApplicationLoaded(appConf) && loadResource != null) {
            SessionContext sessionContext = this.authContext;
            synchronized (sessionContext) {
                SourceParameters parameters = loadResourceParameters != null ? (SourceParameters)loadResourceParameters.clone() : new SourceParameters();
                parameters = this.createParameters(parameters, null, true);
                DocumentFragment fragment = SourceUtil.readDOM((String)loadResource, null, (SourceParameters)parameters, (SourceResolver)resolver);
                this.authContext.setXML("/applications/" + appConf.getName() + '/', fragment);
            }
        }
        this.handler.setApplicationIsLoaded(appConf);
    }
}

