/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;
import org.apache.cocoon.components.elementprocessor.types.Validator;

public class StyleOrientation {
    private int _alignment;
    private static final int _horiz = 1;
    private static final int _vert_horiz_text = 2;
    private static final int _vert_vert_text = 4;
    private static final int _vert_vert_text2 = 8;
    private static final Validator _validator = new Validator(){

        public IOException validate(Number number) {
            int value = number.intValue();
            return value >= 0 && value <= 15 ? null : new IOException("\"" + number + "\" is out of range");
        }
    };

    public StyleOrientation(String value) throws IOException {
        this._alignment = NumericConverter.extractInteger(value, _validator).intValue();
    }

    public boolean isHoriz() {
        return (this._alignment & 1) == 1;
    }

    public boolean isVertHorizText() {
        return (this._alignment & 2) == 2;
    }

    public boolean isVertVertText() {
        return (this._alignment & 4) == 4;
    }

    public boolean isVertVertText2() {
        return (this._alignment & 8) == 8;
    }
}

