/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.IDReferences;
import org.apache.fop.fo.DirectPropertyListBuilder;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.LinkSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;

public abstract class XMLObj
extends FObj {
    protected String tagName;
    protected Element element;
    protected Document doc;
    protected static HashMap ns = new HashMap();

    public XMLObj(FObj parent, PropertyList propertyList, String tag, String systemId, int line, int column) {
        super(parent, propertyList, systemId, line, column);
        this.tagName = tag;
    }

    protected void addCharacters(char[] data, int start, int length) {
        String str = new String(data, start, length);
        Text text = this.doc.createTextNode(str);
        this.element.appendChild(text);
    }

    protected void addChild(FONode child) {
        if (child instanceof XMLObj) {
            ((XMLObj)child).addGraphic(this.doc, this.element);
        }
    }

    public void addGraphic(Document doc, Element parent) {
        this.doc = doc;
        this.element = doc.createElementNS(this.getNameSpace(), this.tagName);
        if (this.properties instanceof DirectPropertyListBuilder.AttrPropertyList) {
            Attributes attr = ((DirectPropertyListBuilder.AttrPropertyList)this.properties).getAttributes();
            int count = 0;
            while (count < attr.getLength()) {
                String rf = attr.getValue(count);
                String qname = attr.getQName(count);
                if (qname.indexOf(":") == -1) {
                    this.element.setAttribute(qname, rf);
                } else {
                    String pref = qname.substring(0, qname.indexOf(":"));
                    if (pref.equals("xmlns")) {
                        ns.put(qname.substring(qname.indexOf(":") + 1), rf);
                    }
                    ns.put("xlink", "http://www.w3.org/1999/xlink");
                    this.element.setAttributeNS((String)ns.get(pref), qname, rf);
                }
                ++count;
            }
        }
        parent.appendChild(this.element);
    }

    public void buildTopLevel(Document doc, Element svgRoot) {
        if (this.properties instanceof DirectPropertyListBuilder.AttrPropertyList) {
            Attributes attr = ((DirectPropertyListBuilder.AttrPropertyList)this.properties).getAttributes();
            int count = 0;
            while (count < attr.getLength()) {
                String rf = attr.getValue(count);
                String qname = attr.getQName(count);
                if (qname.indexOf(":") == -1) {
                    this.element.setAttribute(qname, rf);
                } else {
                    String pref = qname.substring(0, qname.indexOf(":"));
                    if (pref.equals("xmlns")) {
                        ns.put(qname.substring(qname.indexOf(":") + 1), rf);
                    }
                    ns.put("xlink", "http://www.w3.org/1999/xlink");
                    this.element.setAttributeNS((String)ns.get(pref), qname, rf);
                }
                ++count;
            }
        }
    }

    public Document createBasicDocument() {
        this.doc = null;
        this.element = null;
        try {
            this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element el = this.doc.createElement("graph");
            this.doc.appendChild(el);
            this.element = this.doc.getDocumentElement();
            this.buildTopLevel(this.doc, this.element);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.doc;
    }

    public void forceStartOffset(int offset) {
    }

    public void forceWidth(int width) {
    }

    public ArrayList getMarkerSnapshot(ArrayList snapshot) {
        return snapshot;
    }

    public abstract String getNameSpace();

    public int layout(Area area) throws FOPException {
        this.log.error(this.tagName + " outside foreign xml");
        return 1;
    }

    public void removeID(IDReferences idReferences) {
    }

    public void resetMarker() {
    }

    public void rollback(ArrayList snapshot) {
    }

    public void setIsInTableCell() {
    }

    public void setLinkSet(LinkSet linkSet) {
    }

    protected void setWritingMode() {
    }
}

