/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.servlet;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.http.HttpFields;
import org.mortbay.util.Code;
import org.mortbay.util.IO;
import org.mortbay.util.LineInput;
import org.mortbay.util.StringUtil;

public class CGI
extends HttpServlet {
    protected File _docRoot;
    protected String _path;
    protected String _cmdPrefix;
    protected EnvList _env;

    public void init() throws ServletException {
        this._env = new EnvList();
        this._cmdPrefix = this.getInitParameter("commandPrefix");
        String tmp = this.getInitParameter("cgibinResourceBase");
        if (tmp == null) {
            tmp = this.getServletContext().getRealPath("/");
        }
        Code.debug("CGI: CGI bin " + tmp);
        if (tmp == null) {
            Code.warning("CGI: no CGI bin !");
            throw new ServletException();
        }
        File dir = new File(tmp);
        if (!dir.exists()) {
            Code.warning("CGI: CGI bin does not exist - " + dir);
            throw new ServletException();
        }
        if (!dir.canRead()) {
            Code.warning("CGI: CGI bin is not readable - " + dir);
            throw new ServletException();
        }
        if (!dir.isDirectory()) {
            Code.warning("CGI: CGI bin is not a directory - " + dir);
            throw new ServletException();
        }
        try {
            this._docRoot = dir.getCanonicalFile();
            Code.debug("CGI: CGI bin accepted - " + this._docRoot);
        }
        catch (IOException e) {
            Code.warning("CGI: CGI bin failed - " + dir);
            e.printStackTrace();
            throw new ServletException();
        }
        this._path = this.getInitParameter("Path");
        Code.debug("CGI: PATH accepted - " + this._path);
        if (this._path != null) {
            this._env.set("PATH", this._path);
        }
        Enumeration e = this.getInitParameterNames();
        while (e.hasMoreElements()) {
            String n = (String)e.nextElement();
            if (n == null || !n.startsWith("ENV_")) continue;
            this._env.set(n.substring(4), this.getInitParameter(n));
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String both;
        String pathInContext = StringUtil.nonNull(req.getServletPath()) + StringUtil.nonNull(req.getPathInfo());
        Code.debug("CGI: req.getContextPath() : " + req.getContextPath());
        Code.debug("CGI: req.getServletPath() : " + req.getServletPath());
        Code.debug("CGI: req.getPathInfo()    : " + req.getPathInfo());
        Code.debug("CGI: _docRoot             : " + this._docRoot);
        String first = both = pathInContext;
        String last = "";
        File exe = new File(this._docRoot, first);
        while ((first.endsWith("/") || !exe.exists()) && first.length() >= 0) {
            int index = first.lastIndexOf(47);
            first = first.substring(0, index);
            last = both.substring(index, both.length());
            exe = new File(this._docRoot, first);
        }
        if (first.length() == 0 || !exe.exists() || !exe.getCanonicalPath().equals(exe.getAbsolutePath()) || exe.isDirectory()) {
            res.sendError(404);
        } else {
            Code.debug("CGI: script is " + exe);
            Code.debug("CGI: pathInfo is " + last);
            this.exec(exe, last, req, res);
        }
    }

    private void exec(File command, String pathInfo, HttpServletRequest req, HttpServletResponse res) throws IOException {
        Process p;
        block15: {
            String path = command.toString();
            File dir = command.getParentFile();
            Code.debug("CGI: execing: " + path);
            EnvList env = new EnvList(this._env);
            env.set("AUTH_TYPE", req.getAuthType());
            env.set("CONTENT_LENGTH", Integer.toString(req.getContentLength()));
            env.set("CONTENT_TYPE", req.getContentType());
            env.set("GATEWAY_INTERFACE", "CGI/1.1");
            env.set("PATH_INFO", pathInfo);
            env.set("PATH_TRANSLATED", req.getPathTranslated());
            env.set("QUERY_STRING", req.getQueryString());
            env.set("REMOTE_ADDR", req.getRemoteAddr());
            env.set("REMOTE_HOST", req.getRemoteHost());
            env.set("REMOTE_USER", req.getRemoteUser());
            env.set("REQUEST_METHOD", req.getMethod());
            env.set("SCRIPT_NAME", req.getRequestURI().substring(0, req.getRequestURI().length() - pathInfo.length()));
            env.set("SERVER_NAME", req.getServerName());
            env.set("SERVER_PORT", Integer.toString(req.getServerPort()));
            env.set("SERVER_PROTOCOL", req.getProtocol());
            env.set("SERVER_SOFTWARE", this.getServletContext().getServerInfo());
            Enumeration enumeration = req.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String value = req.getHeader(name);
                env.set("HTTP_" + name.toUpperCase().replace('-', '_'), value);
            }
            env.set("HTTPS", req.isSecure() ? "ON" : "OFF");
            String execCmd = path;
            if (execCmd.indexOf(" ") >= 0) {
                execCmd = "\"" + execCmd + "\"";
            }
            if (this._cmdPrefix != null) {
                execCmd = this._cmdPrefix + " " + execCmd;
            }
            p = dir == null ? Runtime.getRuntime().exec(execCmd, env.getEnvArray()) : Runtime.getRuntime().exec(execCmd, env.getEnvArray(), dir);
            ServletInputStream inFromReq = req.getInputStream();
            OutputStream outToCgi = p.getOutputStream();
            final int inputLength = req.getContentLength();
            new Thread(new Runnable((InputStream)inFromReq, outToCgi){
                private final /* synthetic */ InputStream val$inFromReq;
                private final /* synthetic */ OutputStream val$outToCgi;
                {
                    this.val$inFromReq = val$inFromReq;
                    this.val$outToCgi = val$outToCgi;
                }

                public void run() {
                    try {
                        if (inputLength > 0) {
                            IO.copy(this.val$inFromReq, this.val$outToCgi, (long)inputLength);
                        }
                        this.val$outToCgi.close();
                    }
                    catch (IOException e) {
                        Code.ignore(e);
                    }
                }
            }).start();
            try {
                block14: {
                    try {
                        LineInput li = new LineInput(p.getInputStream());
                        HttpFields fields = new HttpFields();
                        fields.read(li);
                        String ContentStatus = "Status";
                        String redirect = fields.get("Location");
                        String status = fields.get(ContentStatus);
                        if (status != null) {
                            Code.debug("Found a Status header - setting status on response");
                            fields.remove(ContentStatus);
                            int i = status.indexOf(32);
                            if (i > 0) {
                                status = status.substring(0, i);
                            }
                            res.setStatus(Integer.parseInt(status));
                        }
                        Iterator i = fields.iterator();
                        while (i.hasNext()) {
                            HttpFields.Entry e = (HttpFields.Entry)i.next();
                            res.addHeader(e.getKey(), e.getValue());
                        }
                        if (status == null && redirect != null) {
                            if (!redirect.startsWith("http:/") && !redirect.startsWith("https:/")) {
                                res.sendRedirect(redirect);
                            } else {
                                res.setStatus(302);
                            }
                        }
                        IO.copy(li, (OutputStream)res.getOutputStream());
                        p.waitFor();
                        int exitValue = p.exitValue();
                        Code.debug("CGI: p.exitValue(): " + exitValue);
                        if (0 == exitValue) break block14;
                        Code.warning("Non-zero exit status (" + exitValue + ") from CGI program: " + path);
                        if (res.isCommitted()) break block14;
                        res.sendError(500, "Failed to exec CGI");
                    }
                    catch (IOException e) {
                        Code.debug("CGI: Client closed connection!");
                        Object var22_26 = null;
                        p.destroy();
                        break block15;
                    }
                    catch (InterruptedException ie) {
                        Code.debug("CGI: interrupted!");
                        Object var22_27 = null;
                        p.destroy();
                    }
                }
                Object var22_25 = null;
                p.destroy();
            }
            catch (Throwable throwable) {
                Object var22_28 = null;
                p.destroy();
                throw throwable;
            }
        }
        Code.debug("CGI: Finished exec: " + p);
    }

    private static class EnvList {
        private Map envMap;

        EnvList() {
            this.envMap = new HashMap();
        }

        EnvList(EnvList l) {
            this.envMap = new HashMap(l.envMap);
        }

        public void set(String name, String value) {
            this.envMap.put(name, name + "=" + StringUtil.nonNull(value));
        }

        public String[] getEnvArray() {
            return this.envMap.values().toArray(new String[this.envMap.size()]);
        }
    }
}

