/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.flow.javascript.fom;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.flow.AbstractInterpreter;
import org.apache.cocoon.components.flow.Interpreter;
import org.apache.cocoon.components.flow.InvalidContinuationException;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.components.flow.javascript.JSErrorReporter;
import org.apache.cocoon.components.flow.javascript.ScriptablePointerFactory;
import org.apache.cocoon.components.flow.javascript.fom.AO_FOM_Cocoon;
import org.apache.cocoon.components.flow.javascript.fom.FOM_JavaScriptFlowHelper;
import org.apache.cocoon.components.flow.javascript.fom.FOM_WebContinuation;
import org.apache.cocoon.components.flow.javascript.fom.JavaScriptAspectWeaver;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.continuations.Continuation;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.debugger.Main;
import org.mozilla.javascript.tools.shell.Global;

public class AO_FOM_JavaScriptInterpreter
extends AbstractInterpreter
implements Serviceable,
Configurable,
Initializable {
    private SourceResolver sourceResolver;
    private static final String LAST_EXEC_TIME = "__PRIVATE_LAST_EXEC_TIME__";
    public static final String USER_GLOBAL_SCOPE = "FOM JavaScript GLOBAL SCOPE";
    static int OPTIMIZATION_LEVEL = -2;
    public static final String INTERCEPTION_POSTFIX = "_intercepted.js";
    protected long lastTimeCheck = 0L;
    private boolean isInterceptionEnabled;
    Global scope;
    List topLevelScripts = new ArrayList();
    Map compiledScripts = new HashMap();
    JSErrorReporter errorReporter;
    boolean enableDebugger = false;
    static Main debugger;
    Configuration stopExecutionFunctionsConf = null;
    boolean serializeResultScript = false;
    static /* synthetic */ Class class$org$mozilla$javascript$Scriptable;
    static /* synthetic */ Class class$org$apache$cocoon$components$flow$javascript$ScriptablePropertyHandler;

    static synchronized Main getDebugger() {
        if (debugger == null) {
            final Main db = new Main("Cocoon Flow Debugger");
            db.pack();
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            size.width = (int)((double)size.width * 0.75);
            size.height = (int)((double)size.height * 0.75);
            db.setSize(size);
            db.setExitAction(new Runnable(){

                public void run() {
                    db.setVisible(false);
                }
            });
            db.setOptimizationLevel(OPTIMIZATION_LEVEL);
            db.setVisible(true);
            debugger = db;
            Context.addContextListener((ContextListener)debugger);
        }
        return debugger;
    }

    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this.sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void configure(Configuration config) throws ConfigurationException {
        String debugger;
        super.configure(config);
        String loadOnStartup = config.getChild("load-on-startup", true).getValue(null);
        if (loadOnStartup != null) {
            this.register(loadOnStartup);
        }
        if ("enabled".equalsIgnoreCase(debugger = config.getChild("debugger").getValue(null))) {
            this.enableDebugger = true;
        }
        this.isInterceptionEnabled = config.getChild("enable-interception").getValueAsBoolean(true);
        this.stopExecutionFunctionsConf = config.getChild("cont-creating-functions");
        this.serializeResultScript = config.getChild("serialize-result-script").getValueAsBoolean(false);
    }

    public void initialize() throws Exception {
        if (this.enableDebugger) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Flow debugger enabled, creating");
            }
            AO_FOM_JavaScriptInterpreter.getDebugger().doBreak();
        }
        Context context = Context.enter();
        context.setOptimizationLevel(OPTIMIZATION_LEVEL);
        context.setCompileFunctionsWithDynamicScope(true);
        context.setGeneratingDebug(true);
        JXPathIntrospector.registerDynamicClass((Class)(class$org$mozilla$javascript$Scriptable == null ? (class$org$mozilla$javascript$Scriptable = AO_FOM_JavaScriptInterpreter.class$("org.mozilla.javascript.Scriptable")) : class$org$mozilla$javascript$Scriptable), (Class)(class$org$apache$cocoon$components$flow$javascript$ScriptablePropertyHandler == null ? (class$org$apache$cocoon$components$flow$javascript$ScriptablePropertyHandler = AO_FOM_JavaScriptInterpreter.class$("org.apache.cocoon.components.flow.javascript.ScriptablePropertyHandler")) : class$org$apache$cocoon$components$flow$javascript$ScriptablePropertyHandler));
        JXPathContextReferenceImpl.addNodePointerFactory((NodePointerFactory)new ScriptablePointerFactory());
        try {
            this.scope = new Global(context);
            AO_FOM_Cocoon.init((Scriptable)this.scope);
            this.errorReporter = new JSErrorReporter(this.getLogger());
        }
        catch (Exception e) {
            Context.exit();
            e.printStackTrace();
            throw e;
        }
    }

    private Scriptable getSessionScope() throws Exception {
        HashMap userScopes;
        Request request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this.avalonContext);
        Scriptable scope = null;
        Session session = request.getSession(false);
        if (session != null && (userScopes = (HashMap)session.getAttribute(USER_GLOBAL_SCOPE)) != null) {
            Source src = this.sourceResolver.resolveURI(".");
            String uriPrefix = src.getURI();
            this.sourceResolver.release(src);
            scope = (Scriptable)userScopes.get(uriPrefix);
        }
        if (scope == null) {
            scope = this.createThreadScope();
        }
        return scope;
    }

    void updateSession(Scriptable scope) throws Exception {
        ThreadScope thrScope = (ThreadScope)scope;
        if (thrScope.useSession) {
            this.setSessionScope(scope);
        }
    }

    private Scriptable setSessionScope(Scriptable scope) throws Exception {
        Request request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this.avalonContext);
        Session session = request.getSession(true);
        HashMap<String, Scriptable> userScopes = (HashMap<String, Scriptable>)session.getAttribute(USER_GLOBAL_SCOPE);
        if (userScopes == null) {
            userScopes = new HashMap<String, Scriptable>();
            session.setAttribute(USER_GLOBAL_SCOPE, userScopes);
        }
        Source src = this.sourceResolver.resolveURI(".");
        String uriPrefix = src.getURI();
        this.sourceResolver.release(src);
        userScopes.put(uriPrefix, scope);
        return scope;
    }

    private Scriptable createThreadScope() throws Exception {
        Context context = Context.getCurrentContext();
        ThreadScope thrScope = new ThreadScope();
        thrScope.setPrototype((Scriptable)this.scope);
        thrScope.setParentScope(null);
        Object[] args = new Object[]{};
        AO_FOM_Cocoon cocoon = (AO_FOM_Cocoon)context.newObject((Scriptable)thrScope, "AO_FOM_Cocoon", args);
        cocoon.setParentScope((Scriptable)thrScope);
        thrScope.put("cocoon", (Scriptable)thrScope, (Object)cocoon);
        thrScope.defineProperty(LAST_EXEC_TIME, new Long(0L), 6);
        thrScope.reset();
        return thrScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupContext(Redirector redirector, Context context, Scriptable thrScope) throws Exception {
        AO_FOM_Cocoon cocoon = (AO_FOM_Cocoon)((Object)thrScope.get("cocoon", thrScope));
        long lastExecTime = (Long)thrScope.get(LAST_EXEC_TIME, thrScope);
        cocoon.setup(this, redirector, this.avalonContext, this.manager, this.getLogger());
        Map map = this.compiledScripts;
        synchronized (map) {
            ArrayList execList = new ArrayList();
            boolean needsRefresh = false;
            if (this.reloadScripts) {
                long now = System.currentTimeMillis();
                if (now >= this.lastTimeCheck + this.checkTime) {
                    needsRefresh = true;
                }
                this.lastTimeCheck = now;
            }
            if (lastExecTime == 0L || needsRefresh || this.needResolve.size() > 0) {
                this.topLevelScripts.addAll(this.needResolve);
                if (lastExecTime != 0L && !needsRefresh) {
                    execList.addAll(this.needResolve);
                } else {
                    execList.addAll(this.topLevelScripts);
                }
                this.needResolve.clear();
            }
            int i = 0;
            int size = execList.size();
            while (i < size) {
                String sourceURI = (String)execList.get(i);
                ScriptSourceEntry entry = (ScriptSourceEntry)this.compiledScripts.get(sourceURI);
                if (entry == null) {
                    Source src = this.sourceResolver.resolveURI(sourceURI);
                    entry = new ScriptSourceEntry(src);
                    this.compiledScripts.put(sourceURI, entry);
                }
                if (this.isInterceptionEnabled) {
                    JavaScriptAspectWeaver aspectWeaver = new JavaScriptAspectWeaver();
                    aspectWeaver.enableLogging(this.getLogger());
                    aspectWeaver.service(this.manager);
                    aspectWeaver.setSerializeResultScriptParam(this.serializeResultScript);
                    aspectWeaver.setStopExecutionFunctionsConf(this.stopExecutionFunctionsConf);
                    entry.setAspectWeaver(aspectWeaver);
                }
                entry.getScript(context, (Scriptable)this.scope, needsRefresh);
                ++i;
            }
            int i2 = 0;
            int size2 = execList.size();
            while (i2 < size2) {
                String sourceURI = (String)execList.get(i2);
                ScriptSourceEntry entry = (ScriptSourceEntry)this.compiledScripts.get(sourceURI);
                long lastMod = entry.getSource().getLastModified();
                Script script = entry.getScript(context, (Scriptable)this.scope, false);
                if (lastExecTime == 0L || lastMod > lastExecTime) {
                    script.exec(context, thrScope);
                    thrScope.put(LAST_EXEC_TIME, thrScope, (Object)new Long(System.currentTimeMillis()));
                    ((ThreadScope)thrScope).reset();
                }
                ++i2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Script compileScript(Context cx, String fileName) throws Exception {
        Source src = this.sourceResolver.resolveURI(fileName);
        if (src == null) {
            throw new ResourceNotFoundException(fileName + ": not found");
        }
        Map map = this.compiledScripts;
        synchronized (map) {
            ScriptSourceEntry entry = (ScriptSourceEntry)this.compiledScripts.get(src.getURI());
            Script compiledScript = null;
            if (entry == null) {
                entry = new ScriptSourceEntry(src);
                this.compiledScripts.put(src.getURI(), entry);
            }
            compiledScript = entry.getScript(cx, (Scriptable)this.scope, false);
            return compiledScript;
        }
    }

    protected Script compileScript(Context cx, Scriptable scope, Source src, JavaScriptAspectWeaver aspectWeaver) throws Exception {
        Script compiledScript = null;
        boolean areScriptsApplied = false;
        if (aspectWeaver != null) {
            aspectWeaver.setBaseScript(src);
            areScriptsApplied = aspectWeaver.areScriptsApplied();
        }
        if (aspectWeaver == null || !areScriptsApplied) {
            InputStream is = src.getInputStream();
            if (is == null) {
                throw new ResourceNotFoundException(src.getURI() + ": not found");
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            compiledScript = cx.compileReader(scope, (Reader)reader, src.getURI(), 1, null);
        } else {
            this.getLogger().info("Adding interceptions to script " + src.getURI());
            BufferedReader reader = new BufferedReader(aspectWeaver.getInterceptedScriptAsReader());
            compiledScript = cx.compileReader(scope, (Reader)reader, src.getURI() + INTERCEPTION_POSTFIX, 1, null);
        }
        return compiledScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void callFunction(String funName, List params, Redirector redirector) throws Exception {
        Scriptable thrScope;
        Context context = Context.enter();
        context.setOptimizationLevel(OPTIMIZATION_LEVEL);
        context.setGeneratingDebug(true);
        context.setCompileFunctionsWithDynamicScope(true);
        context.setErrorReporter((ErrorReporter)this.errorReporter);
        AO_FOM_Cocoon cocoon = null;
        Scriptable scriptable = thrScope = this.getSessionScope();
        synchronized (scriptable) {
            try {
                try {
                    this.setupContext(redirector, context, thrScope);
                    cocoon = (AO_FOM_Cocoon)((Object)thrScope.get("cocoon", thrScope));
                    if (this.enableDebugger && !AO_FOM_JavaScriptInterpreter.getDebugger().isVisible()) {
                        AO_FOM_JavaScriptInterpreter.getDebugger().setVisible(true);
                    }
                    int size = params != null ? params.size() : 0;
                    Object[] funArgs = new Object[size];
                    Scriptable parameters = context.newObject(thrScope);
                    if (size != 0) {
                        int i = 0;
                        while (i < size) {
                            Interpreter.Argument arg = (Interpreter.Argument)params.get(i);
                            funArgs[i] = arg.value;
                            if (arg.name == null) {
                                arg.name = "";
                            }
                            parameters.put(arg.name, parameters, (Object)arg.value);
                            ++i;
                        }
                    }
                    cocoon.setParameters(parameters);
                    Object fun = ScriptableObject.getProperty((Scriptable)thrScope, (String)funName);
                    if (fun == Scriptable.NOT_FOUND) {
                        throw new ResourceNotFoundException("Function \"javascript:" + funName + "()\" not found");
                    }
                    ScriptRuntime.call((Context)context, (Object)fun, (Object)thrScope, (Object[])funArgs, (Scriptable)thrScope);
                }
                catch (JavaScriptException ex) {
                    EvaluatorException ee = Context.reportRuntimeError((String)ToolErrorReporter.getMessage((String)"msg.uncaughtJSException", (String)ex.getMessage()));
                    Throwable unwrapped = this.unwrap(ex);
                    if (!(unwrapped instanceof ProcessingException)) throw new CascadingRuntimeException(ee.getMessage(), unwrapped);
                    throw (ProcessingException)unwrapped;
                }
                catch (EcmaError ee) {
                    String msg = ToolErrorReporter.getMessage((String)"msg.uncaughtJSException", (String)ee.toString());
                    if (ee.getSourceName() != null) {
                        Context.reportRuntimeError((String)msg, (String)ee.getSourceName(), (int)ee.getLineNumber(), (String)ee.getLineSource(), (int)ee.getColumnNumber());
                        throw new CascadingRuntimeException(ee.getMessage(), (Throwable)ee);
                    }
                    Context.reportRuntimeError((String)msg);
                    throw new CascadingRuntimeException(ee.getMessage(), (Throwable)ee);
                }
                Object var14_19 = null;
            }
            catch (Throwable throwable) {
                Object var14_20 = null;
                this.updateSession(thrScope);
                if (cocoon != null) {
                    cocoon.invalidate();
                }
                Context.exit();
                throw throwable;
            }
            this.updateSession(thrScope);
            if (cocoon != null) {
                cocoon.invalidate();
            }
            Context.exit();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleContinuation(String id, List params, Redirector redirector) throws Exception {
        Scriptable kScope;
        WebContinuation wk = this.continuationsMgr.lookupWebContinuation(id);
        if (wk == null) {
            throw new InvalidContinuationException("The continuation ID " + id + " is invalid.");
        }
        Context context = Context.enter();
        context.setOptimizationLevel(OPTIMIZATION_LEVEL);
        context.setGeneratingDebug(true);
        context.setCompileFunctionsWithDynamicScope(true);
        Continuation k = (Continuation)wk.getContinuation();
        Scriptable scriptable = kScope = k.getParentScope();
        synchronized (scriptable) {
            AO_FOM_Cocoon cocoon = (AO_FOM_Cocoon)((Object)kScope.get("cocoon", kScope));
            cocoon.setup(this, redirector, this.avalonContext, this.manager, this.getLogger());
            if (this.enableDebugger) {
                AO_FOM_JavaScriptInterpreter.getDebugger().setVisible(true);
            }
            int size = params != null ? params.size() : 0;
            Scriptable parameters = context.newObject(kScope);
            if (size != 0) {
                int i = 0;
                while (i < size) {
                    Interpreter.Argument arg = (Interpreter.Argument)params.get(i);
                    parameters.put(arg.name, parameters, (Object)arg.value);
                    ++i;
                }
            }
            cocoon.setParameters(parameters);
            FOM_WebContinuation fom_wk = new FOM_WebContinuation(wk);
            fom_wk.setParentScope(kScope);
            fom_wk.setPrototype(ScriptableObject.getClassPrototype((Scriptable)kScope, (String)fom_wk.getClassName()));
            Object[] args = new Object[]{k, fom_wk};
            try {
                try {
                    ScriptableObject.callMethod((Scriptable)cocoon, (String)"handleContinuation", (Object[])args);
                }
                catch (JavaScriptException ex) {
                    EvaluatorException ee = Context.reportRuntimeError((String)ToolErrorReporter.getMessage((String)"msg.uncaughtJSException", (String)ex.getMessage()));
                    Throwable unwrapped = this.unwrap(ex);
                    if (unwrapped instanceof ProcessingException) {
                        throw (ProcessingException)unwrapped;
                    }
                    throw new CascadingRuntimeException(ee.getMessage(), unwrapped);
                }
                catch (EcmaError ee) {
                    String msg = ToolErrorReporter.getMessage((String)"msg.uncaughtJSException", (String)ee.toString());
                    if (ee.getSourceName() != null) {
                        Context.reportRuntimeError((String)msg, (String)ee.getSourceName(), (int)ee.getLineNumber(), (String)ee.getLineSource(), (int)ee.getColumnNumber());
                    } else {
                        Context.reportRuntimeError((String)msg);
                    }
                    throw new CascadingRuntimeException(ee.getMessage(), (Throwable)ee);
                }
                Object var18_15 = null;
            }
            catch (Throwable throwable) {
                Object var18_16 = null;
                this.updateSession(kScope);
                cocoon.invalidate();
                Context.exit();
                throw throwable;
            }
            this.updateSession(kScope);
            cocoon.invalidate();
            Context.exit();
        }
    }

    private Throwable unwrap(JavaScriptException e) {
        Object value = e.getValue();
        while (value instanceof Wrapper) {
            value = ((Wrapper)value).unwrap();
        }
        if (value instanceof Throwable) {
            return (Throwable)value;
        }
        return e;
    }

    public void forwardTo(Scriptable scope, AO_FOM_Cocoon cocoon, String uri, Object bizData, FOM_WebContinuation fom_wk, Redirector redirector) throws Exception {
        this.setupView(scope, cocoon, fom_wk);
        super.forwardTo(uri, bizData, fom_wk == null ? null : fom_wk.getWebContinuation(), redirector);
    }

    void process(Scriptable scope, AO_FOM_Cocoon cocoon, String uri, Object bizData, OutputStream out) throws Exception {
        this.setupView(scope, cocoon, null);
        super.process(uri, bizData, out);
    }

    private void setupView(Scriptable scope, AO_FOM_Cocoon cocoon, FOM_WebContinuation kont) {
        Map objectModel = ContextHelper.getObjectModel((org.apache.avalon.framework.context.Context)this.avalonContext);
        FOM_JavaScriptFlowHelper.setPackages((Map)objectModel, (Scriptable)((Scriptable)ScriptableObject.getProperty((Scriptable)scope, (String)"Packages")));
        FOM_JavaScriptFlowHelper.setJavaPackage((Map)objectModel, (Scriptable)((Scriptable)ScriptableObject.getProperty((Scriptable)scope, (String)"java")));
        FOM_JavaScriptFlowHelper.setFOM_Request((Map)objectModel, (Scriptable)cocoon.jsGet_request());
        FOM_JavaScriptFlowHelper.setFOM_Response((Map)objectModel, (Scriptable)cocoon.jsGet_response());
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        AO_FOM_Cocoon.FOM_Session session = null;
        if (request.getSession(false) != null) {
            session = cocoon.jsGet_session();
        }
        FOM_JavaScriptFlowHelper.setFOM_Session((Map)objectModel, (Scriptable)session);
        FOM_JavaScriptFlowHelper.setFOM_Context((Map)objectModel, (Scriptable)cocoon.jsGet_context());
        if (kont != null) {
            FOM_JavaScriptFlowHelper.setFOM_WebContinuation((Map)objectModel, (Scriptable)kont);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class ThreadScope
    extends ScriptableObject {
        boolean useSession = false;

        public String getClassName() {
            return "ThreadScope";
        }

        public void put(String name, Scriptable start, Object value) {
            this.useSession = true;
            super.put(name, start, value);
        }

        public void put(int index, Scriptable start, Object value) {
            this.useSession = true;
            super.put(index, start, value);
        }

        void reset() {
            this.useSession = false;
        }
    }

    class ScriptSourceEntry {
        private final Source source;
        private Script script;
        private long compileTime;
        private JavaScriptAspectWeaver aspectWeaver = null;

        public ScriptSourceEntry(Source source) {
            this.source = source;
        }

        public ScriptSourceEntry(Source source, Script script, long t) {
            this.source = source;
            this.script = script;
            this.compileTime = t;
        }

        public Source getSource() {
            return this.source;
        }

        public void setAspectWeaver(JavaScriptAspectWeaver aspectWeaver) {
            this.aspectWeaver = aspectWeaver;
        }

        public Script getScript(Context context, Scriptable scope, boolean refresh) throws Exception {
            if (refresh) {
                this.source.refresh();
            }
            if (this.script == null || this.compileTime < this.source.getLastModified()) {
                this.script = AO_FOM_JavaScriptInterpreter.this.compileScript(context, scope, this.source, this.aspectWeaver);
                this.compileTime = this.source.getLastModified();
            }
            return this.script;
        }
    }
}

