/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.coplet.adapter.impl;

import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.components.sax.XMLByteStreamCompiler;
import org.apache.cocoon.components.sax.XMLByteStreamInterpreter;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.coplet.adapter.impl.URICopletAdapter;
import org.apache.cocoon.portal.event.CopletInstanceEvent;
import org.apache.cocoon.portal.event.Event;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CachingURICopletAdapter
extends URICopletAdapter
implements Parameterizable {
    public static final String CACHE = "cacheData";
    public static final String CACHE_VALIDITY = "cacheValidity";
    public static final String DO_NOT_CACHE = "doNotCache";
    public static final String CACHE_VALID = "1";
    public static final String CACHE_INVALID = "0";
    public static final String PARAMETER_DISABLE_CACHING = "disable_caching";
    private boolean disableCaching = false;

    public void parameterize(Parameters parameters) {
        if (parameters != null) {
            this.disableCaching = parameters.getParameterAsBoolean(PARAMETER_DISABLE_CACHING, false);
            if (this.disableCaching) {
                this.getLogger().info(this.getClass().getName() + " Caching is disabled.");
            } else {
                this.getLogger().info(this.getClass().getName() + " Caching is enabled.");
            }
        }
    }

    public void streamContent(CopletInstanceData coplet, ContentHandler contentHandler) throws SAXException {
        this.streamContent(coplet, (String)coplet.getCopletData().getAttribute("uri"), contentHandler);
    }

    public void streamContent(CopletInstanceData coplet, String uri, ContentHandler contentHandler) throws SAXException {
        if (this.isValidCache(coplet)) {
            this.toSAXFromCache(coplet, contentHandler);
        } else {
            XMLByteStreamCompiler bc = new XMLByteStreamCompiler();
            super.streamContent(coplet, uri, (ContentHandler)bc);
            if (coplet.getAttribute(DO_NOT_CACHE) != null) {
                coplet.removeAttribute(DO_NOT_CACHE);
                this.setCacheInvalid(coplet);
                XMLByteStreamInterpreter bi = new XMLByteStreamInterpreter();
                bi.setContentHandler(contentHandler);
                bi.deserialize(bc.getSAXFragment());
            } else {
                this.toCache(coplet, bc.getSAXFragment());
                this.toSAXFromCache(coplet, contentHandler);
            }
        }
    }

    private void toCache(CopletInstanceData coplet, Object data) {
        coplet.setAttribute(CACHE, data);
        this.setCacheValid(coplet);
    }

    private void toSAXFromCache(CopletInstanceData coplet, ContentHandler contentHandler) throws SAXException {
        XMLByteStreamInterpreter bi = new XMLByteStreamInterpreter();
        bi.setContentHandler(contentHandler);
        bi.deserialize(coplet.getAttribute(CACHE));
    }

    public boolean isValidCache(CopletInstanceData coplet) {
        if (this.disableCaching) {
            return false;
        }
        String cacheValidity = (String)coplet.getAttribute(CACHE_VALIDITY);
        if (cacheValidity == null) {
            return false;
        }
        return CACHE_VALID.equals(cacheValidity);
    }

    public void setCacheValid(CopletInstanceData coplet) {
        coplet.setAttribute(CACHE_VALIDITY, CACHE_VALID);
    }

    public void setCacheInvalid(CopletInstanceData coplet) {
        coplet.setAttribute(CACHE_VALIDITY, CACHE_INVALID);
    }

    public void inform(Event e) {
        if (e instanceof CopletInstanceEvent) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("CopletInstanceEvent " + e + " caught by CachingURICopletAdapter");
            }
            this.handleCopletInstanceEvent(e);
        }
        super.inform(e);
    }

    public void handleCopletInstanceEvent(Event e) {
        CopletInstanceEvent event = (CopletInstanceEvent)e;
        CopletInstanceData coplet = (CopletInstanceData)event.getTarget();
        this.setCacheInvalid(coplet);
    }
}

