/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.session.transformation;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.transformation.AbstractSAXTransformer;
import org.apache.cocoon.webapps.session.ContextManager;
import org.apache.cocoon.webapps.session.FormManager;
import org.apache.cocoon.webapps.session.SessionManager;

public abstract class AbstractSessionTransformer
extends AbstractSAXTransformer {
    private SessionManager sessionManager;
    private FormManager formManager;
    private ContextManager contextManager;

    protected SessionManager getSessionManager() throws ProcessingException {
        if (this.sessionManager == null) {
            try {
                this.sessionManager = (SessionManager)this.manager.lookup(SessionManager.ROLE);
            }
            catch (ServiceException ce) {
                throw new ProcessingException("Error during lookup of SessionManager component.", (Throwable)ce);
            }
        }
        return this.sessionManager;
    }

    protected ContextManager getContextManager() throws ProcessingException {
        if (this.contextManager == null) {
            try {
                this.contextManager = (ContextManager)this.manager.lookup(ContextManager.ROLE);
            }
            catch (ServiceException ce) {
                throw new ProcessingException("Error during lookup of ContextManager component.", (Throwable)ce);
            }
        }
        return this.contextManager;
    }

    protected FormManager getFormManager() throws ProcessingException {
        if (this.formManager == null) {
            try {
                this.formManager = (FormManager)this.manager.lookup(FormManager.ROLE);
            }
            catch (ServiceException ce) {
                throw new ProcessingException("Error during lookup of FormManager component.", (Throwable)ce);
            }
        }
        return this.formManager;
    }

    public void recycle() {
        super.recycle();
        this.manager.release((Object)this.sessionManager);
        this.manager.release((Object)this.formManager);
        this.manager.release((Object)this.contextManager);
        this.sessionManager = null;
        this.formManager = null;
        this.contextManager = null;
    }

    public Session getSession() throws ProcessingException {
        return this.getSessionManager().getSession(false);
    }
}

