/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.InspectableSource;
import org.apache.cocoon.components.source.LockableSource;
import org.apache.cocoon.components.source.RestrictableSource;
import org.apache.cocoon.components.source.VersionableSource;
import org.apache.cocoon.components.source.helpers.GroupSourcePermission;
import org.apache.cocoon.components.source.helpers.PrincipalSourcePermission;
import org.apache.cocoon.components.source.helpers.SourceLock;
import org.apache.cocoon.components.source.helpers.SourcePermission;
import org.apache.cocoon.components.source.helpers.SourceProperty;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.TraversableGenerator;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.TraversableSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class TraversableSourceDescriptionGenerator
extends TraversableGenerator {
    protected static final String MIME_TYPE_ATTR_NAME = "mimeType";
    private static final String REVISION_ATTR_NAME = "revision";
    private static final String REVISIONBRANCH_ATTR_NAME = "branch";
    private static final String PROPERTIES_NODE_NAME = "properties";
    private static final String PROPERTIES_NODE_QNAME = "collection:properties";
    private static final String PERMISSIONS_NODE_NAME = "permissions";
    private static final String PERMISSIONS_NODE_QNAME = "collection:permissions";
    private static final String PERMISSION_NODE_NAME = "permission";
    private static final String PERMISSION_NODE_QNAME = "collection:permission";
    private static final String LOCKS_NODE_NAME = "locks";
    private static final String LOCKS_NODE_QNAME = "collection:locks";
    private static final String LOCK_NODE_NAME = "lock";
    private static final String LOCK_NODE_QNAME = "collection:lock";
    private static final String PRINCIPAL_ATTR_NAME = "principal";
    private static final String GROUP_ATTR_NAME = "group";
    private static final String PRIVILEGE_ATTR_NAME = "privilege";
    private static final String INHERITABLE_ATTR_NAME = "inheritable";
    private static final String NEGATIVE_ATTR_NAME = "negative";
    private static final String TYPE_ATTR_NAME = "type";
    private static final String EXPIRATION_ATTR_NAME = "expiration";
    private static final String EXCLUSIVE_ATTR_NAME = "exclusive";
    private boolean properties = true;
    private boolean permissions = true;
    private boolean locks = true;
    private boolean version = true;

    public void setup(SourceResolver resolver, Map objectModel, String location, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, location, parameters);
        this.properties = parameters.getParameterAsBoolean(PROPERTIES_NODE_NAME, true);
        this.cacheKeyParList.add(String.valueOf(this.permissions));
        this.permissions = parameters.getParameterAsBoolean(PERMISSIONS_NODE_NAME, true);
        this.cacheKeyParList.add(String.valueOf(this.permissions));
        this.locks = parameters.getParameterAsBoolean(LOCKS_NODE_NAME, true);
        this.cacheKeyParList.add(String.valueOf(this.locks));
        this.version = parameters.getParameterAsBoolean("version", true);
        this.cacheKeyParList.add(String.valueOf(this.version));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("properties: " + this.properties);
            this.getLogger().debug("permissions: " + this.permissions);
            this.getLogger().debug("locks: " + this.locks);
            this.getLogger().debug("version: " + this.version);
        }
    }

    protected final void addContent(TraversableSource source) throws SAXException, ProcessingException {
        super.addContent(source);
        try {
            if (this.properties && source instanceof InspectableSource) {
                this.pushSourceProperties((InspectableSource)source);
            }
            if (this.permissions && source instanceof RestrictableSource) {
                this.pushSourcePermissions((RestrictableSource)source);
            }
            if (this.locks && source instanceof LockableSource) {
                this.pushSourceLocks((LockableSource)source);
            }
        }
        catch (SourceException e) {
            throw new ProcessingException((Exception)((Object)e));
        }
    }

    protected void setNodeAttributes(TraversableSource source) throws SAXException, ProcessingException {
        String mimeType;
        super.setNodeAttributes(source);
        if (!source.isCollection() && (mimeType = source.getMimeType()) != null) {
            this.attributes.addAttribute("", MIME_TYPE_ATTR_NAME, MIME_TYPE_ATTR_NAME, "CDATA", source.getMimeType());
        }
        if (this.version && source instanceof VersionableSource) {
            try {
                VersionableSource versionablesource = (VersionableSource)source;
                if (versionablesource.isVersioned()) {
                    if (versionablesource.getSourceRevision() != null && versionablesource.getSourceRevision().length() > 0) {
                        this.attributes.addAttribute("", REVISION_ATTR_NAME, REVISION_ATTR_NAME, "CDATA", versionablesource.getSourceRevision());
                    }
                    if (versionablesource.getSourceRevisionBranch() != null && versionablesource.getSourceRevisionBranch().length() > 0) {
                        this.attributes.addAttribute("", REVISIONBRANCH_ATTR_NAME, REVISIONBRANCH_ATTR_NAME, "CDATA", versionablesource.getSourceRevisionBranch());
                    }
                }
            }
            catch (SourceException e) {
                throw new ProcessingException((Exception)((Object)e));
            }
        }
    }

    private void pushSourceProperties(InspectableSource source) throws SAXException, SourceException {
        SourceProperty[] properties = source.getSourceProperties();
        if (properties != null && properties.length > 0) {
            AttributesImpl attributes = new AttributesImpl();
            this.contentHandler.startElement("http://apache.org/cocoon/collection/1.0", PROPERTIES_NODE_NAME, PROPERTIES_NODE_QNAME, attributes);
            int i = 0;
            while (i < properties.length) {
                SourceProperty property = properties[i];
                property.toSAX(this.contentHandler);
                ++i;
            }
            this.contentHandler.endElement("http://apache.org/cocoon/collection/1.0", PROPERTIES_NODE_NAME, PROPERTIES_NODE_QNAME);
        }
    }

    private void pushSourcePermissions(RestrictableSource source) throws SAXException, SourceException {
        SourcePermission[] permissions = source.getSourcePermissions();
        if (permissions != null && permissions.length > 0) {
            this.contentHandler.startElement("http://apache.org/cocoon/collection/1.0", PERMISSIONS_NODE_NAME, PERMISSIONS_NODE_QNAME, new AttributesImpl());
            int i = 0;
            while (i < permissions.length) {
                AttributesImpl attributes = new AttributesImpl();
                if (permissions[i] instanceof PrincipalSourcePermission) {
                    attributes.addAttribute("", PRINCIPAL_ATTR_NAME, PRINCIPAL_ATTR_NAME, "CDATA", ((PrincipalSourcePermission)permissions[i]).getPrincipal());
                } else if (permissions[i] instanceof GroupSourcePermission) {
                    attributes.addAttribute("", GROUP_ATTR_NAME, GROUP_ATTR_NAME, "CDATA", ((GroupSourcePermission)permissions[i]).getGroup());
                }
                attributes.addAttribute("", PRIVILEGE_ATTR_NAME, PRIVILEGE_ATTR_NAME, "CDATA", permissions[i].getPrivilege());
                attributes.addAttribute("", INHERITABLE_ATTR_NAME, INHERITABLE_ATTR_NAME, "CDATA", String.valueOf(permissions[i].isInheritable()));
                attributes.addAttribute("", NEGATIVE_ATTR_NAME, NEGATIVE_ATTR_NAME, "CDATA", String.valueOf(permissions[i].isNegative()));
                this.contentHandler.startElement("http://apache.org/cocoon/collection/1.0", PERMISSION_NODE_NAME, PERMISSION_NODE_QNAME, attributes);
                this.contentHandler.endElement("http://apache.org/cocoon/collection/1.0", PERMISSION_NODE_NAME, PERMISSION_NODE_QNAME);
                ++i;
            }
            this.contentHandler.endElement("http://apache.org/cocoon/collection/1.0", PERMISSIONS_NODE_NAME, PERMISSIONS_NODE_QNAME);
        }
    }

    public void pushSourceLocks(LockableSource source) throws SAXException, SourceException {
        SourceLock[] locks = source.getSourceLocks();
        if (locks != null && locks.length > 0) {
            this.contentHandler.startElement("http://apache.org/cocoon/collection/1.0", LOCKS_NODE_NAME, LOCKS_NODE_QNAME, new AttributesImpl());
            int i = 0;
            while (locks.length > 0) {
                SourceLock lock = locks[i];
                AttributesImpl attributes = new AttributesImpl();
                attributes = new AttributesImpl();
                attributes.addAttribute("", PRINCIPAL_ATTR_NAME, PRINCIPAL_ATTR_NAME, "CDATA", lock.getSubject());
                attributes.addAttribute("", TYPE_ATTR_NAME, TYPE_ATTR_NAME, "CDATA", lock.getType());
                attributes.addAttribute("", EXPIRATION_ATTR_NAME, EXPIRATION_ATTR_NAME, "CDATA", lock.getExpiration().toString());
                attributes.addAttribute("", INHERITABLE_ATTR_NAME, INHERITABLE_ATTR_NAME, "CDATA", String.valueOf(lock.isInheritable()));
                attributes.addAttribute("", EXCLUSIVE_ATTR_NAME, EXCLUSIVE_ATTR_NAME, "CDATA", String.valueOf(lock.isExclusive()));
                this.contentHandler.startElement("http://apache.org/cocoon/collection/1.0", LOCK_NODE_NAME, LOCK_NODE_QNAME, attributes);
                this.contentHandler.endElement("http://apache.org/cocoon/collection/1.0", LOCK_NODE_NAME, LOCK_NODE_QNAME);
                ++i;
            }
            this.contentHandler.endElement("http://apache.org/cocoon/collection/1.0", LOCKS_NODE_NAME, LOCKS_NODE_QNAME);
        }
    }
}

