/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.i18n;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;

public class Translate
extends MatchingTask {
    private String bundle;
    private String bundleLanguage;
    private String bundleCountry;
    private String bundleVariant;
    private File toDir;
    private String srcEncoding;
    private String destEncoding;
    private String bundleEncoding;
    private String startToken;
    private String endToken;
    private boolean forceOverwrite;
    private Vector filesets = new Vector();
    private Hashtable resourceMap = new Hashtable();
    private Locale locale;
    private FileUtils fileUtils = FileUtils.newFileUtils();
    private long[] bundleLastModified = new long[7];
    private long srcLastModified;
    private long destLastModified;
    private boolean loaded = false;

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public void setBundleLanguage(String bundleLanguage) {
        this.bundleLanguage = bundleLanguage;
    }

    public void setBundleCountry(String bundleCountry) {
        this.bundleCountry = bundleCountry;
    }

    public void setBundleVariant(String bundleVariant) {
        this.bundleVariant = bundleVariant;
    }

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }

    public void setStartToken(String startToken) {
        this.startToken = startToken;
    }

    public void setEndToken(String endToken) {
        this.endToken = endToken;
    }

    public void setSrcEncoding(String srcEncoding) {
        this.srcEncoding = srcEncoding;
    }

    public void setDestEncoding(String destEncoding) {
        this.destEncoding = destEncoding;
    }

    public void setBundleEncoding(String bundleEncoding) {
        this.bundleEncoding = bundleEncoding;
    }

    public void setForceOverwrite(boolean forceOverwrite) {
        this.forceOverwrite = forceOverwrite;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    public void execute() throws BuildException {
        Locale l;
        if (this.bundle == null) {
            throw new BuildException("The bundle attribute must be set.", ((Task)this).location);
        }
        if (this.startToken == null) {
            throw new BuildException("The starttoken attribute must be set.", ((Task)this).location);
        }
        if (this.startToken.length() != 1) {
            throw new BuildException("The starttoken attribute must be a single character.", ((Task)this).location);
        }
        if (this.endToken == null) {
            throw new BuildException("The endtoken attribute must be set.", ((Task)this).location);
        }
        if (this.endToken.length() != 1) {
            throw new BuildException("The endtoken attribute must be a single character.", ((Task)this).location);
        }
        if (this.bundleLanguage == null) {
            l = Locale.getDefault();
            this.bundleLanguage = l.getLanguage();
        }
        if (this.bundleCountry == null) {
            this.bundleCountry = Locale.getDefault().getCountry();
        }
        this.locale = new Locale(this.bundleLanguage, this.bundleCountry);
        if (this.bundleVariant == null) {
            l = new Locale(this.bundleLanguage, this.bundleCountry);
            this.bundleVariant = l.getVariant();
        }
        if (this.toDir == null) {
            throw new BuildException("The todir attribute must be set.", ((Task)this).location);
        }
        if (!this.toDir.exists()) {
            this.toDir.mkdirs();
        } else if (this.toDir.isFile()) {
            throw new BuildException(this.toDir + " is not a directory");
        }
        if (this.srcEncoding == null) {
            this.srcEncoding = System.getProperty("file.encoding");
        }
        if (this.destEncoding == null) {
            this.destEncoding = this.srcEncoding;
        }
        if (this.bundleEncoding == null) {
            this.bundleEncoding = this.srcEncoding;
        }
        this.loadResourceMaps();
        this.translate();
    }

    private void loadResourceMaps() throws BuildException {
        Locale locale = new Locale(this.bundleLanguage, this.bundleCountry, this.bundleVariant);
        String language = locale.getLanguage().length() > 0 ? "_" + locale.getLanguage() : "";
        String country = locale.getCountry().length() > 0 ? "_" + locale.getCountry() : "";
        String variant = locale.getVariant().length() > 0 ? "_" + locale.getVariant() : "";
        String bundleFile = this.bundle + language + country + variant;
        this.processBundle(bundleFile, 0, false);
        bundleFile = this.bundle + language + country;
        this.processBundle(bundleFile, 1, false);
        bundleFile = this.bundle + language;
        this.processBundle(bundleFile, 2, false);
        bundleFile = this.bundle;
        this.processBundle(bundleFile, 3, false);
        locale = Locale.getDefault();
        language = locale.getLanguage().length() > 0 ? "_" + locale.getLanguage() : "";
        country = locale.getCountry().length() > 0 ? "_" + locale.getCountry() : "";
        variant = locale.getVariant().length() > 0 ? "_" + locale.getVariant() : "";
        this.bundleEncoding = System.getProperty("file.encoding");
        bundleFile = this.bundle + language + country + variant;
        this.processBundle(bundleFile, 4, false);
        bundleFile = this.bundle + language + country;
        this.processBundle(bundleFile, 5, false);
        bundleFile = this.bundle + language;
        this.processBundle(bundleFile, 6, true);
    }

    private void processBundle(String bundleFile, int i, boolean checkLoaded) throws BuildException {
        block2: {
            File propsFile = new File(bundleFile + ".properties");
            FileInputStream ins = null;
            try {
                ins = new FileInputStream(propsFile);
                this.loaded = true;
                this.bundleLastModified[i] = propsFile.lastModified();
                this.log("Using " + propsFile, 4);
                this.loadResourceMap(ins);
            }
            catch (IOException ioe) {
                this.log(propsFile + " not found.", 4);
                if (this.loaded || !checkLoaded) break block2;
                throw new BuildException(ioe.getMessage(), ((Task)this).location);
            }
        }
    }

    private void loadResourceMap(FileInputStream ins) throws BuildException {
        try {
            BufferedReader in = null;
            InputStreamReader isr = new InputStreamReader((InputStream)ins, this.bundleEncoding);
            in = new BufferedReader(isr);
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().length() <= 1 || '#' == line.charAt(0) || '!' == line.charAt(0)) continue;
                int sepIndex = line.indexOf(61);
                if (-1 == sepIndex) {
                    sepIndex = line.indexOf(58);
                }
                if (-1 == sepIndex) {
                    int k = 0;
                    while (k < line.length()) {
                        if (Character.isSpaceChar(line.charAt(k))) {
                            sepIndex = k;
                            break;
                        }
                        ++k;
                    }
                }
                if (-1 == sepIndex) continue;
                String key = line.substring(0, sepIndex).trim();
                String value = line.substring(sepIndex + 1).trim();
                while (value.endsWith("\\")) {
                    value = value.substring(0, value.length() - 1);
                    line = in.readLine();
                    if (line == null) break;
                    value = value + line.trim();
                }
                if (key.length() <= 0 || this.resourceMap.get(key) != null) continue;
                this.resourceMap.put(key, value);
            }
            if (in != null) {
                in.close();
            }
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.getMessage(), ((Task)this).location);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void translate() throws BuildException {
        int i = 0;
        while (i < this.filesets.size()) {
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(((ProjectComponent)this).project);
            String[] srcFiles = ds.getIncludedFiles();
            int j = 0;
            while (j < srcFiles.length) {
                try {
                    File dest = this.fileUtils.resolveFile(this.toDir, srcFiles[j]);
                    try {
                        File destDir = new File(dest.getParent());
                        if (!destDir.exists()) {
                            destDir.mkdirs();
                        }
                    }
                    catch (Exception e) {
                        this.log("Exception occured while trying to check/create  parent directory.  " + e.getMessage(), 4);
                    }
                    this.destLastModified = dest.lastModified();
                    File src = this.fileUtils.resolveFile(ds.getBasedir(), srcFiles[j]);
                    this.srcLastModified = src.lastModified();
                    if (this.forceOverwrite || this.destLastModified < this.srcLastModified || this.destLastModified < this.bundleLastModified[0] || this.destLastModified < this.bundleLastModified[1] || this.destLastModified < this.bundleLastModified[2] || this.destLastModified < this.bundleLastModified[3] || this.destLastModified < this.bundleLastModified[4] || this.destLastModified < this.bundleLastModified[5] || this.destLastModified < this.bundleLastModified[6]) {
                        String line;
                        this.log("Processing " + srcFiles[j], 4);
                        FileOutputStream fos = new FileOutputStream(dest);
                        BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.destEncoding));
                        FileInputStream fis = new FileInputStream(src);
                        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fis, this.srcEncoding));
                        while ((line = in.readLine()) != null) {
                            void var12_14;
                            int startIndex = -1;
                            int endIndex = -1;
                            block7: while ((startIndex = var12_14.indexOf(this.startToken, endIndex + 1)) >= 0 && startIndex + 1 < var12_14.length() && (endIndex = var12_14.indexOf(this.endToken, startIndex + 1)) >= 0) {
                                String matches = var12_14.substring(startIndex + 1, endIndex);
                                int k = 0;
                                while (k < matches.length()) {
                                    char c = matches.charAt(k);
                                    if (c == ':' || c == '=' || Character.isSpaceChar(c)) {
                                        --endIndex;
                                        continue block7;
                                    }
                                    ++k;
                                }
                                String replace = null;
                                replace = (String)this.resourceMap.get(matches);
                                if (replace == null) {
                                    this.log("Warning: The key: " + matches + " hasn't been defined.", 4);
                                    replace = matches;
                                }
                                line = var12_14.substring(0, startIndex) + replace + var12_14.substring(endIndex + 1);
                                endIndex = startIndex + replace.length() + 1;
                                if (endIndex + 1 < line.length()) continue;
                            }
                            out.write(line);
                            out.newLine();
                        }
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            out.close();
                        }
                    } else {
                        this.log("Skipping " + srcFiles[j] + " as destination file is up to date", 3);
                    }
                }
                catch (IOException ioe) {
                    throw new BuildException(ioe.getMessage(), ((Task)this).location);
                }
                ++j;
            }
            ++i;
        }
    }
}

