/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.excalibur.instrument.manager.AbstractInstrumentSample;
import org.apache.excalibur.instrument.manager.CounterInstrumentListener;
import org.apache.excalibur.instrument.manager.InstrumentProxy;

class CounterInstrumentSample
extends AbstractInstrumentSample
implements CounterInstrumentListener {
    protected int m_count = 0;

    CounterInstrumentSample(InstrumentProxy instrumentProxy, String name, long interval, int size, String description, long lease) {
        super(instrumentProxy, name, interval, size, description, lease);
    }

    public int getType() {
        return 101;
    }

    public final int getInstrumentType() {
        return 1;
    }

    public int getValueInner() {
        return this.m_count;
    }

    protected void advanceToNextSample() {
        this.m_count = 0;
    }

    protected void loadState(int value, Configuration state) throws ConfigurationException {
        this.m_count = value;
    }

    protected void postSaveNeedsReset() {
        this.m_count = 0;
    }

    public void increment(String instrumentName, int count, long time) {
        this.increment(count, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increment(int count, long time) {
        long sampleTime;
        int sampleValue;
        CounterInstrumentSample counterInstrumentSample = this;
        synchronized (counterInstrumentSample) {
            this.update(time);
            this.m_count += count;
            sampleValue = this.m_count;
            sampleTime = this.m_time;
        }
        this.updateListeners(sampleValue, sampleTime);
    }
}

