/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/

package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.filter.Filter;

/**
 *	Interface pour toutes les classes qui repr�sentent des requ�tes de recherche.
 */
public interface Query extends fr.gouv.culture.sdx.search.Query {

    // TODO:FG unify operators and connectors ?
    /** The "AND" operator */
    // public final static int OPERATOR_AND = 0;
    public final static int OPERATOR_AND = 1;

    /**The "OR" operator */
    // public final static int OPERATOR_OR = 1;
    public final static int OPERATOR_OR = 0;

    /** The "NOT" operator */
    public final static int OPERATOR_NOT = 2;

    /** The search engine specification */
    public final static String SEARCH_ENGINE = "lucene";

    /** The default operator, currently set to OPERATOR_AND */
    public final static int defaultOperator = OPERATOR_AND;

    public static final int LUCENE_BOOLEAN_QUERY_MAX_CLAUSES = Integer.parseInt(System.getProperty("org.apache.lucene.maxClauseCount",
            "1000000"));

    /**
     * Executes a query and returns results.
     */
    public Results execute() throws SDXException;

    /**
     * Returns the internal Lucene representation of the query.
     */
    public org.apache.lucene.search.Query getLuceneQuery();

    /**
     * Adds a base query to the current query.
     *
     * @param   baseResults     The results obtained from the base query.
     * @param   operator        The operator linking the query with the base query.
     */
    public void addBaseQuery(Results baseResults, int operator);


    /**Adds a base query to the current query
     *
     * @param query     The query object
     * @param operator  The operator linking the query with the base query
     */
    public void addBaseQuery(Query query, int operator);

    /**
     * Adds a sort specification for this query.
     *
     * @param   ss      The sort specification.
     */
    public void addSortSpecification(SortSpecification ss);

    /**
     * Adds a filter for this query.
     *
     * @param   f       The filter.
     */
    public void addFilter(Filter f);

    /**
     * Prepares a query for proper execution.
     *
     * <p>
     * This method makes sure that all filters are correctly applied.
     *
     * @return A filter defined for this query.
     */
    public Filter prepare();
    
    /**
     * Returns the boost on the query.
     *
     * <p>
     * This method returns the boost on the query.
     *
     * @return the boost value by a float.
     */
    public float getBoost();
    
    /**
     * Change the boost on the query.
     *
     * <p>
     * This method changes the boost on the query to make it more significant.
     *
     * @param get the boost value by a float.
     */
    public void setBoost(float boost);
    
    /**
     * Change the boost on the query.
     *
     * <p>
     * This method changes the boost on the query to make it more significant.
     * If the String is not a valid float, no changes occur.
     *
     * @param get the boost value by a string.
     */
    public void setBoost(String boost);

    public SearchLocations getSearchLocations();

    public void setUp(SearchLocations sLocs, org.apache.lucene.search.Query query) throws SDXException;

    public void setLuceneQuery(org.apache.lucene.search.Query query);

    org.apache.lucene.search.Query getCachedQuery();

}
