/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import fr.gouv.culture.sdx.utils.AbstractSdxObject;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.lucene.document.Document;

/**
 *	A result document of a search.
 */
public class ResultDocument extends AbstractSdxObject implements LogEnabled {

    public static final String CLASS_NAME_SUFFIX = "ResultDocument";

    /** The Lucene document */
    private Document document;

    /** The relevance ranking. */
    private float score;

    /**Creates a ResultDocument object
     *
     * <p>
     * A super.getLog() must be set and then this object must be setUp.
     *
     * @see #enableLogging
     * @see #setUp
     */
    public ResultDocument() {
    }

    /**
     *	Builds a ResultDocument with a Lucene document and a relavance ranking.
     *
     * @param   doc     The Lucene document
     * @param   score   The relavance ranking
     */
    public void setUp(Document doc, float score) throws SDXException {
        if (doc == null) throw new SDXException(super.getLog(), SDXExceptionCode.ERROR_LUCENE_DOCUMENT_NULL, null, null);
        document = doc;
        this.score = score;
    }

    /**
     * Returns the value of a field within this document.
     *
     * This method never returns <code>null</code>,
     * it will turn over a <code>null</code> String
     * if the field does not exist.
     *
     *	@param	field	The name of the field.
     */
    public String getFieldValue(String field) {
        String fieldValue = document.get(field);
        if (fieldValue == null)
            return "";
        else
            return fieldValue;
    }

    /**
     *	Returns the relavance ranking for this document.
     */
    public float getScore() {
        return score;
    }

    /**
     *	Returns the Lucene document associated with this result.
     */
    public Document getDocument() {
        return document;
    }

    protected String getClassNameSuffix() {
        return ResultDocument.CLASS_NAME_SUFFIX;
    }

	/* (non-Javadoc)
	 * @see fr.gouv.culture.sdx.utils.AbstractSdxObject#initToSax()
	 */
	protected boolean initToSax() {
		return true;
	}

	/**Init the LinkedHashMap _xmlizable_volatile_objects with the objects in order to describ them in XML
	 * Some objects need to be refresh each time a toSAX is called*/
	protected void initVolatileObjectsToSax() {
	
	}


}
