package fr.gouv.culture.sdx.utils;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: 22 mars 2004
 * Time: 12:21:31
 * To change this template use Options | File Templates.
 */
public class SAXUtils {

	public static String prefixNodeName(String prefix, String elemName) {
		if (!Utilities.checkString(elemName)) return null;
		String qualifiedElementName = "";
		if (Utilities.checkString(prefix))
			qualifiedElementName += prefix + ":";
		qualifiedElementName += elemName;
		return qualifiedElementName;
	}

	/**Sends a element with the simple character content
	 * provided by the <code>elemContent</code> param
	 *
	 * @param uri   The namespace uri
	 * @param localName The local name
	 * @param qName The qualified name
	 * @param atts The attributes
	 * @param elemContent The character content
	 * @throws SAXException
	 */
	public static void sendElement(ContentHandler handler, String uri, String localName, String qName, Attributes atts, String elemContent) throws SAXException {
		if (atts == null) atts = new AttributesImpl();
		handler.startElement(uri, localName, qName, atts);
		SAXUtils.sendElementContent(handler, elemContent);
		handler.endElement(uri, localName, qName);
	}

	/**Sends character content from the provided string
	 *
	 * @param content The string of characters to send
	 */
	public static void sendElementContent(ContentHandler handler, String content) throws SAXException {
		if (Utilities.checkString(content)) {
			char[] chars = content.toCharArray();
			handler.characters(chars, 0, chars.length);
		}
	}

}
