/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.altrmi.server.impl.socket;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.excalibur.altrmi.server.AltrmiServerException;
import org.apache.excalibur.altrmi.server.impl.AbstractServer;
import org.apache.excalibur.altrmi.server.impl.ServerStreamReadWriter;
import org.apache.excalibur.altrmi.server.impl.adapters.InvocationHandlerAdapter;
import org.apache.excalibur.altrmi.server.impl.socket.SocketStreamServerConnection;

public abstract class AbstractCompleteSocketStreamServer
extends AbstractServer
implements Runnable {
    private ServerSocket mServerSocket;
    private Thread mThread;

    public AbstractCompleteSocketStreamServer(int port) throws AltrmiServerException {
        try {
            this.mServerSocket = new ServerSocket(port);
        }
        catch (IOException ioe) {
            throw new AltrmiServerException("Some problem setting up server : " + ioe.getMessage());
        }
    }

    public AbstractCompleteSocketStreamServer(InvocationHandlerAdapter invocationHandlerAdapter, int port) throws AltrmiServerException {
        super(invocationHandlerAdapter);
        try {
            this.mServerSocket = new ServerSocket(port);
        }
        catch (IOException ioe) {
            throw new AltrmiServerException("Some problem setting up server : " + ioe.getMessage());
        }
    }

    public void run() {
        block3: {
            boolean accepting = false;
            try {
                while (this.mState == 22) {
                    accepting = true;
                    Socket sock = this.mServerSocket.accept();
                    accepting = false;
                    sock.setSoTimeout(36000);
                    ServerStreamReadWriter ssrw = this.createServerStreamReadWriter();
                    ssrw.setStreams(sock.getInputStream(), sock.getOutputStream());
                    SocketStreamServerConnection sssc = new SocketStreamServerConnection(this, sock, sock.getInputStream(), sock.getOutputStream(), ssrw);
                    sssc.enableLogging(this.getLogger());
                    Thread thread = new Thread((Runnable)sssc, "SocketStreamServerConnection Thread");
                    thread.start();
                }
            }
            catch (IOException ioe) {
                if (accepting & ioe.getMessage().equals("socket closed")) break block3;
                System.err.println("Some problem connecting client via sockets: " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    public void start() {
        this.mState = 22;
        this.getThread().start();
    }

    public void stop() {
        this.mState = 11;
        try {
            this.mServerSocket.close();
        }
        catch (IOException e) {
            System.out.println("Unable to close the server socket.");
        }
        this.killAllConnections();
        this.getThread().interrupt();
        this.mState = 33;
    }

    private Thread getThread() {
        if (this.mThread == null) {
            this.mThread = new Thread((Runnable)this, "AltrmiSocketStreamServer");
        }
        return this.mThread;
    }

    protected abstract ServerStreamReadWriter createServerStreamReadWriter();
}

