/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.net.MalformedURLException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.flow.AbstractFlow;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.FopImageFactory;
import org.apache.fop.layout.AbsolutePositionProps;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.ColumnArea;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.HyphenationProps;
import org.apache.fop.layout.MarginInlineProps;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RelativePositionProps;
import org.apache.fop.layout.TextState;

public class PropertyManager {
    private PropertyList properties;
    private FontState fontState = null;
    private BorderAndPadding borderAndPadding = null;
    private HyphenationProps hyphProps = null;
    private BackgroundProps bgProps = null;
    private String[] saLeft;
    private String[] saRight;
    private String[] saTop;
    private String[] saBottom;
    private static final String padding = new String("padding-");
    private static final String border = new String("border-");
    private static final String width = new String("-width");
    private static final String color = new String("-color");
    private static final String style = new String("-style");

    public PropertyManager(PropertyList pList) {
        this.properties = pList;
    }

    public int checkBreakAfter(Area area) {
        switch (this.properties.get("break-after").getEnum()) {
            case 83: {
                return 4;
            }
            case 80: {
                return 6;
            }
            case 35: {
                return 5;
            }
            case 20: {
                return 7;
            }
        }
        return 1;
    }

    public int checkBreakBefore(Area area) {
        if (!(area instanceof ColumnArea)) {
            switch (this.properties.get("break-before").getEnum()) {
                case 83: {
                    return 4;
                }
                case 80: {
                    return 6;
                }
                case 35: {
                    return 5;
                }
                case 20: {
                    return 7;
                }
            }
            return 1;
        }
        ColumnArea colArea = (ColumnArea)area;
        switch (this.properties.get("break-before").getEnum()) {
            case 83: {
                if (!colArea.hasChildren() && colArea.getColumnIndex() == 1) {
                    return 1;
                }
                return 4;
            }
            case 80: {
                if (!colArea.hasChildren() && colArea.getColumnIndex() == 1 && colArea.getPage().getNumber() % 2 != 0) {
                    return 1;
                }
                return 6;
            }
            case 35: {
                if (!colArea.hasChildren() && colArea.getColumnIndex() == 1 && colArea.getPage().getNumber() % 2 == 0) {
                    return 1;
                }
                return 5;
            }
            case 20: {
                if (!area.hasChildren()) {
                    return 1;
                }
                return 7;
            }
        }
        return 1;
    }

    private String formatColor(String[] saSide) {
        StringBuffer sb = new StringBuffer(19);
        return sb.append(border).append(saSide[0]).append(color).toString();
    }

    private String formatPadding(String[] saSide) {
        StringBuffer sb = new StringBuffer(14);
        return sb.append(padding).append(saSide[0]).toString();
    }

    private String formatStyle(String[] saSide) {
        StringBuffer sb = new StringBuffer(19);
        return sb.append(border).append(saSide[0]).append(style).toString();
    }

    private String formatWidth(String[] saSide) {
        StringBuffer sb = new StringBuffer(19);
        return sb.append(border).append(saSide[0]).append(width).toString();
    }

    public AbsolutePositionProps getAbsolutePositionProps() {
        AbsolutePositionProps props = new AbsolutePositionProps();
        return props;
    }

    public AccessibilityProps getAccessibilityProps() {
        AccessibilityProps props = new AccessibilityProps();
        String str = this.properties.get("source-document").getString();
        if (!"none".equals(str)) {
            props.sourceDoc = str;
        }
        if (!"none".equals(str = this.properties.get("role").getString())) {
            props.role = str;
        }
        return props;
    }

    public AuralProps getAuralProps() {
        AuralProps props = new AuralProps();
        return props;
    }

    public BackgroundProps getBackgroundProps() {
        if (this.bgProps == null) {
            this.bgProps = new BackgroundProps();
            this.bgProps.backColor = this.properties.get("background-color").getColorType();
            String src = this.properties.get("background-image").getString();
            if (src.equalsIgnoreCase("none")) {
                this.bgProps.backImage = null;
            } else if (src.equalsIgnoreCase("inherit")) {
                this.bgProps.backImage = null;
            } else {
                try {
                    this.bgProps.backImage = FopImageFactory.Make(src);
                }
                catch (MalformedURLException urlex) {
                    this.bgProps.backImage = null;
                    System.out.println("Error creating background image: " + urlex.getMessage());
                }
                catch (FopImageException imgex) {
                    this.bgProps.backImage = null;
                    System.out.println("Error creating background image: " + imgex.getMessage());
                }
            }
            this.bgProps.backRepeat = this.properties.get("background-repeat").getEnum();
        }
        return this.bgProps;
    }

    public BorderAndPadding getBorderAndPadding() {
        if (this.borderAndPadding == null) {
            this.borderAndPadding = new BorderAndPadding();
            this.initDirections();
            this.initBorderInfo(0, this.saTop);
            this.initBorderInfo(2, this.saBottom);
            this.initBorderInfo(3, this.saLeft);
            this.initBorderInfo(1, this.saRight);
        }
        return this.borderAndPadding;
    }

    public FontState getFontState(FontInfo fontInfo) throws FOPException {
        if (this.fontState == null) {
            String fontFamily = this.properties.get("font-family").getString();
            String fontStyle = this.properties.get("font-style").getString();
            String fontWeight = this.properties.get("font-weight").getString();
            int fontSize = this.properties.get("font-size").getLength().mvalue();
            int fontVariant = this.properties.get("font-variant").getEnum();
            this.fontState = new FontState(fontInfo, fontFamily, fontStyle, fontWeight, fontSize, fontVariant);
        }
        return this.fontState;
    }

    public HyphenationProps getHyphenationProps() {
        if (this.hyphProps == null) {
            this.hyphProps = new HyphenationProps();
            this.hyphProps.hyphenate = this.properties.get("hyphenate").getEnum();
            this.hyphProps.hyphenationChar = this.properties.get("hyphenation-character").getCharacter();
            this.hyphProps.hyphenationPushCharacterCount = this.properties.get("hyphenation-push-character-count").getNumber().intValue();
            this.hyphProps.hyphenationRemainCharacterCount = this.properties.get("hyphenation-remain-character-count").getNumber().intValue();
            this.hyphProps.language = this.properties.get("language").getString();
            this.hyphProps.country = this.properties.get("country").getString();
        }
        return this.hyphProps;
    }

    public MarginInlineProps getMarginInlineProps() {
        MarginInlineProps props = new MarginInlineProps();
        return props;
    }

    public MarginProps getMarginProps() {
        MarginProps props = new MarginProps();
        props.marginTop = this.properties.get("margin-top").getLength().mvalue();
        props.marginBottom = this.properties.get("margin-bottom").getLength().mvalue();
        props.marginLeft = this.properties.get("margin-left").getLength().mvalue();
        props.marginRight = this.properties.get("margin-right").getLength().mvalue();
        return props;
    }

    public RelativePositionProps getRelativePositionProps() {
        RelativePositionProps props = new RelativePositionProps();
        return props;
    }

    public TextState getTextDecoration(FObj parent) throws FOPException {
        int textDecoration;
        TextState tsp = null;
        boolean found = false;
        do {
            if (parent instanceof AbstractFlow) {
                found = true;
            } else if (parent instanceof FObjMixed) {
                FObjMixed fom = (FObjMixed)parent;
                tsp = fom.getTextState();
                found = true;
            }
            parent = parent.getParent();
        } while (!found);
        TextState ts = new TextState();
        if (tsp != null) {
            ts.setUnderlined(tsp.getUnderlined());
            ts.setOverlined(tsp.getOverlined());
            ts.setLineThrough(tsp.getLineThrough());
        }
        if ((textDecoration = this.properties.get("text-decoration").getEnum()) == 121) {
            ts.setUnderlined(true);
        }
        if (textDecoration == 82) {
            ts.setOverlined(true);
        }
        if (textDecoration == 59) {
            ts.setLineThrough(true);
        }
        if (textDecoration == 72) {
            ts.setUnderlined(false);
        }
        if (textDecoration == 70) {
            ts.setOverlined(false);
        }
        if (textDecoration == 69) {
            ts.setLineThrough(false);
        }
        return ts;
    }

    private void initBorderInfo(int whichSide, String[] saSide) {
        this.borderAndPadding.setPadding(whichSide, this.properties.get(this.formatPadding(saSide)).getCondLength());
        int style = this.properties.get(this.formatStyle(saSide)).getEnum();
        if (style != 75) {
            this.borderAndPadding.setBorder(whichSide, style, this.properties.get(this.formatWidth(saSide)).getCondLength(), this.properties.get(this.formatColor(saSide)).getColorType());
        }
    }

    private void initDirections() {
        this.saLeft = new String[1];
        this.saRight = new String[1];
        this.saTop = new String[1];
        this.saBottom = new String[1];
        this.saTop[0] = this.properties.wmAbsToRel(2);
        this.saBottom[0] = this.properties.wmAbsToRel(3);
        this.saLeft[0] = this.properties.wmAbsToRel(0);
        this.saRight[0] = this.properties.wmAbsToRel(1);
    }
}

