/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.mif;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.fo.flow.TableCell;
import org.apache.fop.fo.flow.TableColumn;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageArea;
import org.apache.fop.image.SVGImage;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BodyAreaContainer;
import org.apache.fop.layout.DisplaySpace;
import org.apache.fop.layout.FontInfo;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.LineArea;
import org.apache.fop.layout.Page;
import org.apache.fop.layout.SpanArea;
import org.apache.fop.layout.inline.ForeignObjectArea;
import org.apache.fop.layout.inline.InlineArea;
import org.apache.fop.layout.inline.InlineSpace;
import org.apache.fop.layout.inline.LeaderArea;
import org.apache.fop.layout.inline.WordArea;
import org.apache.fop.mif.MIFDocument;
import org.apache.fop.render.AbstractRenderer;
import org.apache.fop.render.mif.FontSetup;
import org.apache.fop.svg.SVGArea;

public class MIFRenderer
extends AbstractRenderer {
    private String currentFontName;
    private String currentFontSize;
    private int pageHeight;
    private int pageWidth;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    private int currentAreaContainerXPosition = 0;
    protected MIFDocument mifDoc = new MIFDocument();
    private boolean inTable = false;
    protected Map options;

    protected void addFilledRect(int x, int y, int w, int h, ColorType col) {
    }

    protected void doFrame(Area area) {
        int rx = this.currentAreaContainerXPosition;
        int w = area.getContentWidth();
        if (area instanceof BlockArea) {
            rx += ((BlockArea)area).getStartIndent();
        }
        int h = area.getContentHeight();
        int ry = this.currentYPosition;
        w = w + area.getPaddingLeft() + area.getPaddingRight();
        h = h + area.getPaddingTop() + area.getPaddingBottom();
        this.doBackground(area, rx -= area.getPaddingLeft(), ry += area.getPaddingTop(), w, h);
        w = w + area.getBorderLeftWidth() + area.getBorderRightWidth();
        h = h + area.getBorderTopWidth() + area.getBorderBottomWidth();
        this.mifDoc.setTextRectProp(rx -= area.getBorderLeftWidth(), this.pageHeight - (ry += area.getBorderTopWidth()), w, h);
    }

    protected void drawImageClipped(int x, int y, int clipX, int clipY, int clipW, int clipH, FopImage image, FontState fs) {
    }

    protected void drawImageScaled(int x, int y, int w, int h, FopImage image, FontState fs) {
    }

    public void render(Page page, OutputStream outputStream) {
        this.renderPage(page);
    }

    public void renderAreaContainer(AreaContainer area) {
        if (area.foCreator != null && area.foCreator.getName() == "fo:table") {
            this.mifDoc.createTable();
            this.inTable = true;
        } else if (area.foCreator != null && area.foCreator.getName() == "fo:table-body") {
            this.mifDoc.setCurrent("fo:table-body");
        } else if (area.foCreator != null && area.foCreator.getName() == "fo:table-column") {
            int colWidth = ((TableColumn)area.foCreator).getColumnWidth();
            this.mifDoc.setColumnProp(colWidth);
        } else if (area.foCreator != null && area.foCreator.getName() == "fo:table-row") {
            this.mifDoc.startRow();
        } else if (area.foCreator != null && area.foCreator.getName() == "fo:table-cell") {
            int rowSpan = ((TableCell)area.foCreator).getNumRowsSpanned();
            int colSpan = ((TableCell)area.foCreator).getNumColumnsSpanned();
            this.mifDoc.startCell(rowSpan, colSpan);
        } else if (this.inTable) {
            this.inTable = false;
            this.mifDoc.endTable();
        }
        super.renderAreaContainer(area);
    }

    public void renderBlockArea(BlockArea area) {
        this.mifDoc.setBlockProp(area.getStartIndent(), area.getEndIndent());
        super.renderBlockArea(area);
    }

    public void renderDisplaySpace(DisplaySpace space) {
        int d = space.getSize();
        this.currentYPosition -= d;
    }

    public void renderForeignObjectArea(ForeignObjectArea area) {
    }

    public void renderImageArea(ImageArea area) {
        int x = this.currentAreaContainerXPosition + area.getXOffset();
        int y = this.currentYPosition;
        int w = area.getContentWidth();
        int h = area.getHeight();
        this.currentYPosition -= h;
        FopImage img = area.getImage();
        if (img instanceof SVGImage) {
            this.log.warn("SVG images not supported in this version");
        } else {
            String url = img.getURL();
            this.mifDoc.addImage(url, x, this.pageHeight - y, w, h);
        }
    }

    public void renderInlineArea(InlineArea area) {
    }

    public void renderInlineSpace(InlineSpace space) {
        String s = " ";
        this.mifDoc.addToStream(s);
        this.currentXPosition += space.getSize();
    }

    public void renderLeaderArea(LeaderArea area) {
    }

    public void renderLineArea(LineArea area) {
        this.mifDoc.startLine();
        super.renderLineArea(area);
    }

    public void renderPage(Page page) {
        BodyAreaContainer body = page.getBody();
        AreaContainer before = page.getBefore();
        AreaContainer after = page.getAfter();
        this.currentFontName = "";
        this.currentFontSize = "0";
        this.pageHeight = page.getHeight();
        this.pageWidth = page.getWidth();
        this.mifDoc.setDocumentHeightWidth(this.pageHeight, this.pageWidth);
        this.mifDoc.createPage();
        body.render(this);
        if (before != null) {
            this.mifDoc.createTextRect(1);
            before.render(this);
        }
        if (after != null) {
            this.mifDoc.createTextRect(1);
            after.render(this);
        }
    }

    public void renderSVGArea(SVGArea area) {
    }

    public void renderSpanArea(SpanArea area) {
        this.mifDoc.createTextRect(area.getColumnCount());
        super.renderSpanArea(area);
    }

    public void renderWordArea(WordArea area) {
        String s = area.getText();
        this.mifDoc.addToStream(s);
        this.currentXPosition += area.getContentWidth();
    }

    public void setOptions(Map options) {
        this.options = options;
    }

    public void setProducer(String producer) {
    }

    public void setupFontInfo(FontInfo fontInfo) {
        FontSetup.setup(fontInfo);
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        this.log.info("rendering areas to MIF");
    }

    public void stopRenderer(OutputStream outputStream) throws IOException {
        this.log.info("writing out MIF");
        this.mifDoc.output(outputStream);
        outputStream.flush();
    }
}

