/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting.modular;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.acting.modular.DatabaseAction;
import org.apache.cocoon.util.HashMap;
import org.apache.cocoon.util.JDBCTypeConversions;

public class DatabaseSelectAction
extends DatabaseAction {
    protected String selectMode(boolean isAutoIncrement, Map modes) {
        return (String)modes.get(DatabaseAction.MODE_OTHERS);
    }

    protected boolean honourAutoIncrement() {
        return false;
    }

    protected DatabaseAction.CacheHelper getQuery(Configuration table, Map modeTypes, Map defaultModeNames) throws ConfigurationException, ComponentException {
        DatabaseAction.LookUpKey lookUpKey = new DatabaseAction.LookUpKey(table, modeTypes);
        DatabaseAction.CacheHelper queryData = null;
        HashMap hashMap = this.cachedQueryData;
        synchronized (hashMap) {
            queryData = (DatabaseAction.CacheHelper)this.cachedQueryData.get(lookUpKey);
            if (queryData == null) {
                Configuration[] keys = table.getChild("keys").getChildren("key");
                Configuration[] values = table.getChild("values").getChildren("value");
                queryData = new DatabaseAction.CacheHelper(keys.length, keys.length + values.length);
                this.fillModes(keys, true, defaultModeNames, modeTypes, queryData);
                this.fillModes(values, false, defaultModeNames, modeTypes, queryData);
                StringBuffer queryBuffer = new StringBuffer("SELECT ");
                int count = 0;
                int i = 0;
                while (i < queryData.columns.length) {
                    if (!queryData.columns[i].isKey) {
                        if (count > 0) {
                            queryBuffer.append(", ");
                        }
                        queryBuffer.append(queryData.columns[i].columnConf.getAttribute("name"));
                        ++count;
                    }
                    ++i;
                }
                queryBuffer.append(" FROM ").append(table.getAttribute("name")).append(" WHERE ");
                count = 0;
                int i2 = 0;
                while (i2 < queryData.columns.length) {
                    if (queryData.columns[i2].isKey) {
                        if (count > 0) {
                            queryBuffer.append(" AND ");
                        }
                        queryBuffer.append(queryData.columns[i2].columnConf.getAttribute("name")).append("= ?");
                        ++count;
                    }
                    ++i2;
                }
                queryData.queryString = queryBuffer.toString();
                this.cachedQueryData.put(lookUpKey, queryData);
            }
        }
        return queryData;
    }

    protected Object[][] getColumnValues(Configuration tableConf, DatabaseAction.CacheHelper queryData, Map objectModel) throws ConfigurationException, ComponentException {
        Object[][] columnValues = new Object[queryData.columns.length][];
        int i = 0;
        while (i < queryData.columns.length) {
            if (queryData.columns[i].isKey) {
                columnValues[i] = this.getColumnValue(tableConf, queryData.columns[i], objectModel);
            }
            ++i;
        }
        return columnValues;
    }

    protected int processRow(Map objectModel, Connection conn, PreparedStatement statement, String outputMode, Configuration table, DatabaseAction.CacheHelper queryData, Object[][] columnValues, int rowIndex, Map results) throws SQLException, ConfigurationException, Exception {
        int currentIndex = 1;
        int i = 0;
        while (i < queryData.columns.length) {
            DatabaseAction.Column col = queryData.columns[i];
            if (col.isKey) {
                this.setColumn(objectModel, outputMode, results, table, col.columnConf, rowIndex, columnValues[i][col.isSet ? rowIndex : 0], statement, currentIndex);
                ++currentIndex;
            }
            ++i;
        }
        statement.execute();
        ResultSet resultset = statement.getResultSet();
        rowIndex = 0;
        while (resultset.next()) {
            int i2 = 0;
            while (i2 < queryData.columns.length) {
                if (!queryData.columns[i2].isKey) {
                    Object value = JDBCTypeConversions.getColumn(resultset, queryData.columns[i2].columnConf);
                    this.setOutput(objectModel, outputMode, results, table, queryData.columns[i2].columnConf, rowIndex, value);
                }
                ++i2;
            }
            ++rowIndex;
        }
        if (rowIndex == 0) {
            results = AbstractAction.EMPTY_MAP;
        }
        return rowIndex;
    }
}

