/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.notification;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import org.apache.cocoon.components.notification.Notifying;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Notifier {
    public static String notify(Notifying n, OutputStream outputStream) throws IOException {
        Notifier.notify(n, outputStream, "text/html");
        return "text/html";
    }

    public static void notify(Notifying n, OutputStream outputStream, String mimetype) throws IOException {
        Notifier.notifyHTML(n, outputStream);
    }

    private static void notifyHTML(Notifying n, OutputStream outputStream) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append("<html><head><title>").append(n.getTitle()).append("</title>");
        sb.append("<STYLE><!--H1{font-family : sans-serif,Arial,Tahoma;color : white;background-color : #0086b2;} ");
        sb.append("BODY{font-family : sans-serif,Arial,Tahoma;color : black;background-color : white;} ");
        sb.append("B{color : white;background-color : #0086b2;} ");
        sb.append("HR{color : #0086b2;} ");
        sb.append("--></STYLE> ");
        sb.append("</head><body>");
        sb.append("<h1>Cocoon 2 - ").append(n.getTitle()).append("</h1>");
        sb.append("<hr size=\"1\" noshade=\"noshade\"/>");
        sb.append("<p><b>type</b> ").append(n.getType()).append("</p>");
        sb.append("<p><b>message</b> <u>").append(n.getMessage()).append("</u></p>");
        sb.append("<p><b>description</b> <u>").append(n.getDescription()).append("</u></p>");
        sb.append("<p><b>sender</b> ").append(n.getSender()).append("</p>");
        sb.append("<p><b>source</b> ").append(n.getSource()).append("</p>");
        Map extraDescriptions = n.getExtraDescriptions();
        Iterator keyIter = extraDescriptions.keySet().iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            sb.append("<p><b>").append(key).append("</b><pre>").append(extraDescriptions.get(key)).append("</pre></p>");
        }
        sb.append("<hr size=\"1\" noshade=\"true\"/>");
        sb.append("</body></html>");
        if (outputStream != null) {
            outputStream.write(sb.toString().getBytes());
        }
    }

    public static void notify(Notifying n, ContentHandler ch) throws SAXException {
        Notifier.notify(n, ch, "text/xml");
    }

    public static void notify(Notifying n, ContentHandler ch, String mimetype) throws SAXException {
        String PREFIX = "error";
        String URI2 = "http://apache.org/cocoon/error/2.0";
        ch.startDocument();
        ch.startPrefixMapping("error", "http://apache.org/cocoon/error/2.0");
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("http://apache.org/cocoon/error/2.0", "type", "error:type", "CDATA", n.getType());
        atts.addAttribute("http://apache.org/cocoon/error/2.0", "sender", "error:sender", "CDATA", n.getSender());
        ch.startElement("http://apache.org/cocoon/error/2.0", "notify", "error:notify", atts);
        ch.startElement("http://apache.org/cocoon/error/2.0", "title", "error:title", new AttributesImpl());
        ch.characters(n.getTitle().toCharArray(), 0, n.getTitle().length());
        ch.endElement("http://apache.org/cocoon/error/2.0", "title", "error:title");
        ch.startElement("http://apache.org/cocoon/error/2.0", "source", "error:source", new AttributesImpl());
        ch.characters(n.getSource().toCharArray(), 0, n.getSource().length());
        ch.endElement("http://apache.org/cocoon/error/2.0", "source", "error:source");
        ch.startElement("http://apache.org/cocoon/error/2.0", "message", "error:message", new AttributesImpl());
        if (n.getMessage() != null) {
            ch.characters(n.getMessage().toCharArray(), 0, n.getMessage().length());
        }
        ch.endElement("http://apache.org/cocoon/error/2.0", "message", "error:message");
        ch.startElement("http://apache.org/cocoon/error/2.0", "description", "error:description", new AttributesImpl());
        ch.characters(n.getDescription().toCharArray(), 0, n.getDescription().length());
        ch.endElement("http://apache.org/cocoon/error/2.0", "description", "error:description");
        Map extraDescriptions = n.getExtraDescriptions();
        Iterator keyIter = extraDescriptions.keySet().iterator();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            String value = String.valueOf(extraDescriptions.get(key));
            atts = new AttributesImpl();
            atts.addAttribute("http://apache.org/cocoon/error/2.0", "description", "error:description", "CDATA", key);
            ch.startElement("http://apache.org/cocoon/error/2.0", "extra", "error:extra", atts);
            ch.characters(value.toCharArray(), 0, value.length());
            ch.endElement("http://apache.org/cocoon/error/2.0", "extra", "error:extra");
        }
        ch.endElement("http://apache.org/cocoon/error/2.0", "notify", "error:notify");
        ch.endPrefixMapping("error");
        ch.endDocument();
    }
}

