/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.ExtendedComponentSelector;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.components.treeprocessor.CategoryNode;
import org.apache.cocoon.components.treeprocessor.CategoryNodeBuilder;
import org.apache.cocoon.components.treeprocessor.DefaultTreeBuilder;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.sitemap.ComponentsSelector;
import org.apache.cocoon.sitemap.SitemapComponentSelector;
import org.apache.cocoon.util.StringUtils;

public class SitemapLanguage
extends DefaultTreeBuilder {
    private static final String ATTR_PREFIX = "org.apache.cocoon.components.treeprocessor.ViewNodeBuilder";
    private Map labelViews = new HashMap();
    private CategoryNode viewsNode;
    private boolean isBuildingView = false;
    public static final String FIRST_POS_LABEL = "!first!";
    public static final String LAST_POS_LABEL = "!last!";

    protected ComponentManager createComponentManager(Configuration tree) throws Exception {
        Configuration config2 = tree.getChild("components", false);
        if (config2 == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Sitemap has no components definition at " + tree.getLocation());
            }
            config2 = new DefaultConfiguration("", "");
        }
        CocoonComponentManager manager = new CocoonComponentManager(this.parentManager);
        LifecycleHelper.setupComponent((Object)manager, this.getLogger(), this.context, this.parentManager, this.roleManager, this.logKit, config2);
        if (this.parentManager != null) {
            int i = 0;
            while (i < ComponentsSelector.SELECTOR_ROLES.length) {
                String role = ComponentsSelector.SELECTOR_ROLES[i];
                ComponentSelector parentSelector = null;
                try {
                    parentSelector = (ComponentSelector)this.parentManager.lookup(role);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (parentSelector != null) {
                    ExtendedComponentSelector localSelector = null;
                    try {
                        localSelector = (ExtendedComponentSelector)manager.lookup(role);
                        if (localSelector != parentSelector) {
                            localSelector.setParentSelector(parentSelector);
                        }
                        manager.release((Component)localSelector);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.parentManager.release((Component)parentSelector);
                }
                ++i;
            }
        }
        return manager;
    }

    public void recycle() {
        super.recycle();
        this.labelViews.clear();
        this.viewsNode = null;
        this.isBuildingView = false;
    }

    public void setBuildingView(boolean building) {
        this.isBuildingView = building;
    }

    public boolean isBuildingView() {
        return this.isBuildingView;
    }

    public void addViewForLabel(String label, String view) {
        HashSet<String> views;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("views:addViewForLabel(" + label + ", " + view + ")");
        }
        if ((views = (HashSet<String>)this.labelViews.get(label)) == null) {
            views = new HashSet<String>();
            this.labelViews.put(label, views);
        }
        views.add(view);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection getViewsForStatement(String role, String hint, Configuration statement) throws Exception {
        String statementLabels = statement.getAttribute("label", null);
        if (this.isBuildingView) {
            if (statementLabels == null) return null;
            String msg = "Cannot put a 'label' attribute inside view definition at " + statement.getLocation();
            this.getLogger().error(msg);
            throw new ConfigurationException(msg);
        }
        HashSet<String> views = null;
        HashSet<String> labels = new HashSet<String>();
        if (role != null && role.length() > 0) {
            SitemapComponentSelector selector = null;
            try {
                Object var11_14;
                block15: {
                    try {
                        selector = (SitemapComponentSelector)this.manager.lookup(role + "Selector");
                        String[] compLabels = selector.getLabels(hint);
                        if (compLabels == null) break block15;
                        int i = 0;
                        while (i < compLabels.length) {
                            labels.add(compLabels[i]);
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().warn("No selector for role " + role);
                        var11_14 = null;
                        this.manager.release((Component)selector);
                    }
                }
                var11_14 = null;
                this.manager.release((Component)selector);
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                this.manager.release(selector);
                throw throwable;
            }
        }
        if (statementLabels != null) {
            labels.addAll(SitemapLanguage.splitLabels(statementLabels));
        }
        if ("org.apache.cocoon.generation.Generator".equals(role)) {
            labels.add(FIRST_POS_LABEL);
        } else if ("org.apache.cocoon.serialization.Serializer".equals(role)) {
            labels.add(LAST_POS_LABEL);
        }
        views = new HashSet<String>();
        Iterator labelIter = labels.iterator();
        while (labelIter.hasNext()) {
            Collection coll = (Collection)this.labelViews.get(labelIter.next());
            if (coll == null) continue;
            Iterator viewIter = coll.iterator();
            while (viewIter.hasNext()) {
                String viewName = (String)viewIter.next();
                views.add(viewName);
            }
        }
        if (views.size() == 0) {
            views = null;
            if (!this.getLogger().isDebugEnabled()) return views;
            this.getLogger().debug(statement.getName() + " has no views at " + statement.getLocation());
            return views;
        }
        if (!this.getLogger().isDebugEnabled()) return views;
        StringBuffer buf = new StringBuffer(statement.getName() + " will match views [");
        Iterator iter = views.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next()).append(" ");
        }
        buf.append("] at ").append(statement.getLocation());
        this.getLogger().debug(buf.toString());
        return views;
    }

    protected void linkNodes() throws Exception {
        this.viewsNode = CategoryNodeBuilder.getCategoryNode(this, "views");
        super.linkNodes();
    }

    public Map getViewNodes(Collection viewNames) throws Exception {
        if (viewNames == null || viewNames.size() == 0) {
            return null;
        }
        if (this.viewsNode == null) {
            return null;
        }
        HashMap<String, ProcessingNode> result = new HashMap<String, ProcessingNode>();
        Iterator iter = viewNames.iterator();
        while (iter.hasNext()) {
            String viewName = (String)iter.next();
            result.put(viewName, this.viewsNode.getNodeByName(viewName));
        }
        return result;
    }

    private static final Collection splitLabels(String labels) {
        if (labels == null) {
            return Collections.EMPTY_SET;
        }
        return Arrays.asList(StringUtils.split(labels, ", \t\n\r"));
    }
}

