/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xscript;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.url.URLFactory;
import org.apache.cocoon.components.xscript.XScriptManager;
import org.apache.cocoon.components.xscript.XScriptObject;

public class XScriptObjectFromURL
extends XScriptObject {
    String systemId;
    int contentLength;
    long lastModified;

    public XScriptObjectFromURL(XScriptManager manager, String systemId) {
        super(manager);
        this.systemId = systemId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream getInputStream() throws ProcessingException, IOException {
        InputStream inputStream;
        URLFactory urlFactory = null;
        try {
            try {
                urlFactory = (URLFactory)this.componentManager.lookup("org.apache.cocoon.components.url.URLFactory");
                URL url = urlFactory.getURL(this.systemId);
                URLConnection conn = url.openConnection();
                InputStream is = conn.getInputStream();
                this.contentLength = conn.getContentLength();
                inputStream = is;
                Object var7_7 = null;
            }
            catch (ComponentException ex) {
                throw new ProcessingException((Exception)((Object)ex));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.componentManager.release((Component)urlFactory);
            throw throwable;
        }
        this.componentManager.release((Component)urlFactory);
        return inputStream;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getSystemId() {
        return "xscript:url:" + this.systemId;
    }

    public void recycle() {
    }

    public String toString() {
        return "XScriptObjectFromURL(systemId = " + this.systemId + ")";
    }
}

