/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.rmi.server.UID;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.Cacheable;
import org.apache.cocoon.caching.NOPCacheValidity;
import org.apache.cocoon.environment.AbstractEnvironment;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.util.HashUtil;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class FragmentExtractorGenerator
extends AbstractGenerator
implements Cacheable {
    private static Map fragmentStore = new HashMap();
    boolean cleanupStore = true;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        AbstractEnvironment env = (AbstractEnvironment)resolver;
        String view = env.getView();
        if (view != null && view.equals("links")) {
            this.cleanupStore = false;
        }
    }

    public long generateKey() {
        return HashUtil.hash(this.source);
    }

    public CacheValidity generateValidity() {
        return NOPCacheValidity.CACHE_VALIDITY;
    }

    public void generate() throws SAXException {
        this.getLogger().debug("FragmentExtractorGenerator retrieving document " + this.source + ".");
        Document doc = null;
        Map map = fragmentStore;
        synchronized (map) {
            doc = (Document)fragmentStore.get(this.source);
            if (doc == null) {
                throw new SAXException("Could not find fragment " + this.source + ".");
            }
            if (this.cleanupStore) {
                fragmentStore.remove(this.source);
            }
        }
        DOMStreamer streamer = new DOMStreamer(this.contentHandler, this.lexicalHandler);
        streamer.stream(doc);
    }

    public static String store(Document doc) {
        String id = new UID().toString();
        id = id.replace(':', '-');
        Map map = fragmentStore;
        synchronized (map) {
            fragmentStore.put(id, doc);
        }
        return id;
    }
}

