/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.sitemap;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.classloader.RepositoryClassLoader;
import org.apache.cocoon.components.modules.input.InputModule;
import org.apache.cocoon.components.pipeline.EventPipeline;
import org.apache.cocoon.components.pipeline.StreamPipeline;
import org.apache.cocoon.components.url.URLFactory;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.sitemap.DefaultSitemapComponentSelector;
import org.apache.cocoon.sitemap.Handler;
import org.apache.cocoon.sitemap.Manager;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.cocoon.sitemap.Sitemap;
import org.apache.cocoon.sitemap.SitemapComponentSelector;
import org.apache.cocoon.util.ClassUtils;

public abstract class AbstractSitemap
extends AbstractLoggable
implements Sitemap,
Disposable,
ThreadSafe {
    private Context context;
    private static final int BYTE_ARRAY_SIZE = 1024;
    private static RoleManager roleManager;
    private static LogKitManager logKitManager;
    private static Configuration defaultConfig;
    private ComponentSelector inputModuleSelector = null;
    protected CocoonComponentManager manager;
    protected Manager sitemapManager;
    protected URLFactory urlFactory;
    protected long dateCreated = -1L;
    protected DefaultSitemapComponentSelector generators;
    protected DefaultSitemapComponentSelector transformers;
    protected DefaultSitemapComponentSelector serializers;
    protected DefaultSitemapComponentSelector readers;
    protected DefaultSitemapComponentSelector actions;
    protected DefaultSitemapComponentSelector matchers;
    protected DefaultSitemapComponentSelector selectors;
    protected DefaultSitemapComponentSelector sitemaps;
    static /* synthetic */ Class class$org$apache$avalon$framework$component$Component;

    public static void setRoleManager(RoleManager roles, Configuration config2) {
        roleManager = roles;
        defaultConfig = config2;
    }

    public static void setLogKitManager(LogKitManager logkit) {
        logKitManager = logkit;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = new CocoonComponentManager(manager);
        this.manager.setLogger(this.getLogger());
        this.manager.contextualize(this.context);
        this.manager.setRoleManager(roleManager);
        this.manager.setLogKitManager(logKitManager);
        try {
            if (defaultConfig != null) {
                this.manager.configure(defaultConfig);
            }
            this.urlFactory = (URLFactory)manager.lookup("org.apache.cocoon.components.url.URLFactory");
            this.generators = new DefaultSitemapComponentSelector();
            this.transformers = new DefaultSitemapComponentSelector();
            this.serializers = new DefaultSitemapComponentSelector();
            this.readers = new DefaultSitemapComponentSelector();
            this.actions = new DefaultSitemapComponentSelector();
            this.matchers = new DefaultSitemapComponentSelector();
            this.selectors = new DefaultSitemapComponentSelector();
            this.sitemaps = new DefaultSitemapComponentSelector();
            try {
                this.generators.setParentSelector((SitemapComponentSelector)this.manager.lookup("org.apache.cocoon.generation.GeneratorSelector"));
                this.transformers.setParentSelector((SitemapComponentSelector)this.manager.lookup("org.apache.cocoon.transformation.TransformerSelector"));
                this.serializers.setParentSelector((SitemapComponentSelector)this.manager.lookup("org.apache.cocoon.serialization.SerializerSelector"));
                this.readers.setParentSelector((SitemapComponentSelector)this.manager.lookup("org.apache.cocoon.reading.ReaderSelector"));
                this.actions.setParentSelector((SitemapComponentSelector)this.manager.lookup("org.apache.cocoon.acting.ActionSelector"));
                this.matchers.setParentSelector((SitemapComponentSelector)this.manager.lookup("org.apache.cocoon.matching.MatcherSelector"));
                this.selectors.setParentSelector((SitemapComponentSelector)this.manager.lookup("org.apache.cocoon.selection.SelectorSelector"));
            }
            catch (ComponentException ce) {
                // empty catch block
            }
            this.setupSelector(this.generators);
            this.setupSelector(this.transformers);
            this.setupSelector(this.serializers);
            this.setupSelector(this.readers);
            this.setupSelector(this.actions);
            this.setupSelector(this.matchers);
            this.setupSelector(this.selectors);
            this.setupSelector(this.sitemaps);
            this.manager.addComponentInstance("org.apache.cocoon.generation.GeneratorSelector", (Component)this.generators);
            this.manager.addComponentInstance("org.apache.cocoon.transformation.TransformerSelector", (Component)this.transformers);
            this.manager.addComponentInstance("org.apache.cocoon.serialization.SerializerSelector", (Component)this.serializers);
            this.manager.addComponentInstance("org.apache.cocoon.reading.ReaderSelector", (Component)this.readers);
            this.manager.addComponentInstance("org.apache.cocoon.acting.ActionSelector", (Component)this.actions);
            this.manager.addComponentInstance("org.apache.cocoon.matching.MatcherSelector", (Component)this.matchers);
            this.manager.addComponentInstance("org.apache.cocoon.selection.SelectorSelector", (Component)this.selectors);
            this.manager.addComponentInstance("org.apache.cocoon.ProcessorSelector", (Component)this.sitemaps);
            this.inputModuleSelector = (ComponentSelector)this.manager.lookup(InputModule.ROLE + "Selector");
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Cannot obtain the URLFactory (" + e + ")");
            }
            throw new ComponentException("Cannot obtain the URLFactory", (Throwable)e);
        }
    }

    private void setupSelector(DefaultSitemapComponentSelector selector) throws Exception {
        selector.setLogger(this.getLogger());
        selector.contextualize(this.context);
        selector.setRoleManager(roleManager);
        selector.setLogKitManager(logKitManager);
        selector.compose((ComponentManager)this.manager);
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public ComponentManager getComponentManager() {
        return this.manager;
    }

    public final boolean modifiedSince(long date) {
        return this.dateCreated < date;
    }

    public void load_component(int type, Object hint, String classURL, Configuration configuration, String mime_type) throws Exception {
        Class clazz = null;
        if (classURL.indexOf(58) > 1) {
            URL url = this.urlFactory.getURL(classURL);
            byte[] b = this.getByteArrayFromStream(url.openStream());
            clazz = ((RepositoryClassLoader)ClassUtils.getClassLoader()).defineClass(b);
        } else {
            clazz = ClassUtils.loadClass(classURL);
        }
        if (!(class$org$apache$avalon$framework$component$Component == null ? (class$org$apache$avalon$framework$component$Component = AbstractSitemap.class$("org.apache.avalon.framework.component.Component")) : class$org$apache$avalon$framework$component$Component).isAssignableFrom(clazz)) {
            throw new IllegalAccessException("Object " + classURL + " is not a Component");
        }
        switch (type) {
            case 1: {
                this.generators.addComponent(hint, clazz, configuration);
                break;
            }
            case 2: {
                this.transformers.addComponent(hint, clazz, configuration);
                break;
            }
            case 4: {
                this.serializers.addSitemapComponent(hint, clazz, configuration, mime_type);
                break;
            }
            case 8: {
                this.readers.addSitemapComponent(hint, clazz, configuration, mime_type);
                break;
            }
            case 16: {
                this.actions.addComponent(hint, clazz, configuration);
                break;
            }
            case 32: {
                this.matchers.addComponent(hint, clazz, configuration);
                break;
            }
            case 64: {
                this.selectors.addComponent(hint, clazz, configuration);
            }
        }
    }

    protected boolean invoke(Environment environment, String prefix, String source, boolean checkReload, boolean reloadAsync, long checkDelay) throws Exception {
        Handler handler = null;
        try {
            handler = (Handler)this.sitemaps.select(source);
        }
        catch (ComponentException e) {
            handler = this.sitemapManager.createHandler((ComponentManager)this.manager, source, checkReload, reloadAsync, checkDelay);
            this.sitemaps.addComponentInstance(source, handler);
        }
        return this.sitemapManager.invoke(handler, environment, prefix, source);
    }

    protected boolean invoke(Environment environment, String prefix, String source, boolean checkReload, boolean reloadAsync, long checkDelay, StreamPipeline pipeline, EventPipeline eventPipeline) throws Exception {
        Handler handler = null;
        try {
            handler = (Handler)this.sitemaps.select(source);
        }
        catch (ComponentException e) {
            handler = this.sitemapManager.createHandler((ComponentManager)this.manager, source, checkReload, reloadAsync, checkDelay);
            this.sitemaps.addComponentInstance(source, handler);
        }
        return this.sitemapManager.invoke(handler, environment, prefix, source, pipeline, eventPipeline);
    }

    private byte[] getByteArrayFromStream(InputStream stream) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        byte[] b = new byte[1024];
        int last = 0;
        try {
            while ((last = stream.read(b)) == 1024) {
                list.add(b);
                b = new byte[1024];
            }
        }
        catch (IOException ioe) {
            this.getLogger().error("cannot read class byte stream", (Throwable)ioe);
        }
        list.add(b);
        int listSize = list.size();
        b = new byte[(listSize - 1) * 1024 + last];
        int i = 0;
        while (i < listSize - 1) {
            System.arraycopy(list.get(i), 0, b, i * 1024, 1024);
            ++i;
        }
        System.arraycopy(list.get(i), 0, b, i * 1024, last);
        return b;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String substitute(List list, String expr, Environment environment) throws PatternException, NumberFormatException {
        if (expr == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        String s = null;
        int j = 0;
        int k = 0;
        int l = 0;
        int m = 0;
        int ii = 0;
        int i = -1;
        int n = -1;
        try {
            while (true) {
                Object value;
                block19: {
                    Object var19_19;
                    if (ii > expr.length() || (i = expr.indexOf(123, ii)) == -1) {
                        if (ii < expr.length()) {
                            result.append(expr.substring(ii));
                        }
                        return result.toString();
                    }
                    result.append(expr.substring(ii, i));
                    j = expr.indexOf(125, i);
                    if (j < i) {
                        throw new PatternException("invalid expression in \"" + expr + "\"");
                    }
                    ii = j + 1;
                    s = expr.substring(i + 1, j);
                    n = s.indexOf(58);
                    value = null;
                    if (n == -1) {
                        k = list.size() - 1;
                        l = -3;
                        m = -1;
                        while (true) {
                            if ((l = s.indexOf("../", l + 3)) == -1) {
                                if (m != -1) {
                                    s = s.substring(m + 3);
                                }
                                value = ((Map)list.get(k)).get(s);
                                break block19;
                            }
                            --k;
                            m = l;
                        }
                    }
                    String inputName = s.substring(0, n);
                    String inputAttribute = s.substring(n + 1);
                    InputModule input = null;
                    try {
                        try {
                            input = (InputModule)this.inputModuleSelector.select((Object)inputName);
                            value = input.getAttribute(inputAttribute, null, environment.getObjectModel());
                        }
                        catch (Exception e) {
                            if (this.getLogger().isWarnEnabled()) {
                                this.getLogger().warn("Problem obtaining attribute " + inputAttribute + " from " + inputName + " : " + e.getMessage());
                            }
                            var19_19 = null;
                            if (input != null) {
                                this.inputModuleSelector.release((Component)input);
                            }
                            break block19;
                        }
                        var19_19 = null;
                        if (input == null) break block19;
                    }
                    catch (Throwable throwable) {
                        var19_19 = null;
                        if (input != null) {
                            this.inputModuleSelector.release((Component)input);
                        }
                        throw throwable;
                    }
                    this.inputModuleSelector.release((Component)input);
                }
                if (value != null) {
                    result.append(value.toString());
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("Substitute evaluated value for " + s + " as " + value);
                    continue;
                }
                this.getLogger().warn("Substitute: value not found for " + s + " while evaluating " + expr);
            }
        }
        catch (Exception e) {
            this.getLogger().error("AbstractSitemap:substitute()", (Throwable)e);
            throw new PatternException("error occurred during evaluation of expression \"" + expr + "\" at position " + (i + 1) + "\n" + e.getMessage());
        }
    }

    protected void dumpParameters(List list) {
        if (this.getLogger().isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            if (!list.isEmpty()) {
                sb.append("\nCurrent Sitemap Parameters:\n");
                String path = "";
                int i = list.size() - 1;
                while (i >= 0) {
                    Map map = (Map)list.get(i);
                    Iterator keys = map.keySet().iterator();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        sb.append("PARAM: '").append(path).append(key).append("' VALUE: '").append(map.get(key)).append("'\n");
                    }
                    path = "../" + path;
                    --i;
                }
            }
            this.getLogger().debug(sb.toString());
        }
    }

    public abstract boolean process(Environment var1) throws Exception;

    public abstract boolean process(Environment var1, StreamPipeline var2, EventPipeline var3) throws Exception;

    protected boolean invokeMethod(String methodName, Class[] argTypes, Object[] argValues) throws Exception {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Dynamically invoking " + methodName);
            }
            Method method = this.getClass().getDeclaredMethod(methodName, argTypes);
            return (Boolean)method.invoke((Object)this, argValues);
        }
        catch (NoSuchMethodException e) {
            this.getLogger().error("AbstractSitemap:invokeMethod()", (Throwable)e);
            int prefix = methodName.indexOf("_");
            throw new ProcessingException("Sitemap: " + methodName.substring(0, prefix) + " '" + methodName.substring(prefix + 1) + "' not found", e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t == null) {
                throw e;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            this.getLogger().error("Unknown target exception type: " + t.getClass().getName());
            throw e;
        }
        catch (Exception e) {
            this.getLogger().error("AbstractSitemap:invokeMethod()", (Throwable)e);
            throw e;
        }
    }

    public void dispose() {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Disposing");
        }
        if (this.inputModuleSelector != null) {
            this.manager.release((Component)this.inputModuleSelector);
        }
        this.inputModuleSelector = null;
        this.manager.release(this.urlFactory);
        this.urlFactory = null;
        this.manager.release((Component)this.generators);
        this.generators = null;
        this.manager.release((Component)this.transformers);
        this.transformers = null;
        this.manager.release((Component)this.serializers);
        this.serializers = null;
        this.manager.release((Component)this.readers);
        this.readers = null;
        this.manager.release((Component)this.actions);
        this.actions = null;
        this.manager.release((Component)this.matchers);
        this.matchers = null;
        this.manager.release((Component)this.selectors);
        this.selectors = null;
        this.manager.release((Component)this.sitemaps);
        this.sitemaps = null;
        this.manager.dispose();
        this.manager = null;
    }

    protected boolean tryResetResponse(Map objectModel) {
        this.getLogger().warn("tryResetResponse in AbstractSitemap is deprecated!");
        return false;
    }

    public abstract void configure(Configuration var1) throws ConfigurationException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

