/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import java.io.UnsupportedEncodingException;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;

public class AreaPtg
extends Ptg {
    public static final short sid = 37;
    private static final int SIZE = 9;
    private short field_1_first_row;
    private short field_2_last_row;
    private short field_3_first_column;
    private short field_4_last_column;

    public AreaPtg() {
    }

    public AreaPtg(byte[] data, int offset) {
        this.field_1_first_row = LittleEndian.getShort(data, 0 + ++offset);
        this.field_2_last_row = LittleEndian.getShort(data, 2 + offset);
        this.field_3_first_column = LittleEndian.getShort(data, 4 + offset);
        this.field_4_last_column = LittleEndian.getShort(data, 6 + offset);
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AreaPtg\n");
        buffer.append("firstRow = " + this.getFirstRow()).append("\n");
        buffer.append("lastRow  = " + this.getLastRow()).append("\n");
        buffer.append("firstCol = " + this.getFirstColumn()).append("\n");
        buffer.append("lastCol  = " + this.getLastColumn()).append("\n");
        buffer.append("firstColRowRel= " + this.isFirstColRowRelative()).append("\n");
        buffer.append("lastColRowRel = " + this.isLastColRowRelative()).append("\n");
        buffer.append("firstColRel   = " + this.isFirstColRelative()).append("\n");
        buffer.append("lastColRel    = " + this.isLastColRelative()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
    }

    public int getSize() {
        return 9;
    }

    public short getFirstRow() {
        return this.field_1_first_row;
    }

    public void setFirstRow(short row) {
        this.field_1_first_row = row;
    }

    public short getLastRow() {
        return this.field_2_last_row;
    }

    public void setLastRow(short row) {
        this.field_2_last_row = row;
    }

    public short getFirstColumn() {
        return (short)(this.field_3_first_column & 0x3FFF);
    }

    public short getFirstColumnRaw() {
        return this.field_3_first_column;
    }

    public boolean isFirstColRowRelative() {
        return (this.getFirstColumnRaw() & 0x8000) == 32768;
    }

    public boolean isFirstColRelative() {
        return (this.getFirstColumnRaw() & 0x4000) == 16384;
    }

    public void setFirstColumn(short column) {
        this.field_3_first_column = column;
    }

    public void setFirstColumnRaw(short column) {
        this.field_3_first_column = column;
    }

    public short getLastColumn() {
        return (short)(this.field_4_last_column & 0x3FFF);
    }

    public short getLastColumnRaw() {
        return this.field_4_last_column;
    }

    public boolean isLastColRowRelative() {
        return (this.getLastColumnRaw() & 0x8000) == 1;
    }

    public boolean isLastColRelative() {
        return (this.getFirstColumnRaw() & 0x4000) == 1;
    }

    public void setLastColumn(short column) {
        this.field_4_last_column = column;
    }

    public void setLastColumnRaw(short column) {
        this.field_4_last_column = column;
    }

    public String toFormulaString() {
        String firstrow = "" + (this.getFirstRow() + 1);
        String lastrow = null;
        lastrow = this.isLastColRowRelative() ? "" + (this.getFirstRow() + this.getLastRow()) : "" + (this.getLastRow() + 1);
        return this.colNumToLetter(this.getFirstColumn()) + firstrow + ":" + this.colNumToLetter(this.getLastColumn()) + lastrow;
    }

    public String colNumToLetter(int col) {
        byte[] b = new byte[]{65};
        b[0] = (byte)(b[0] + (byte)col);
        String retval = null;
        try {
            retval = new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("NON JDK 1.3 COMPLIANT JVM -- YOUR JVM MUST SUPPORT UTF-8 encoding as per docs!");
        }
        return retval;
    }

    static {
        sid = (short)37;
        SIZE = 9;
    }
}

