/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.parser;

import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.RDQL_InternalErrorException;
import com.hp.hpl.jena.rdf.query.Slot;
import com.hp.hpl.jena.rdf.query.TriplePattern;
import com.hp.hpl.jena.rdf.query.Value;
import com.hp.hpl.jena.rdf.query.Var;
import com.hp.hpl.jena.rdf.query.parser.ConstraintExpr;
import com.hp.hpl.jena.rdf.query.parser.Expr;
import com.hp.hpl.jena.rdf.query.parser.Node;
import com.hp.hpl.jena.rdf.query.parser.Q_ConstraintClause;
import com.hp.hpl.jena.rdf.query.parser.Q_Identifier;
import com.hp.hpl.jena.rdf.query.parser.Q_PrefixDecl;
import com.hp.hpl.jena.rdf.query.parser.Q_PrefixesClause;
import com.hp.hpl.jena.rdf.query.parser.Q_SelectClause;
import com.hp.hpl.jena.rdf.query.parser.Q_SourceClause;
import com.hp.hpl.jena.rdf.query.parser.Q_TriplePattern;
import com.hp.hpl.jena.rdf.query.parser.Q_TriplePatternClause;
import com.hp.hpl.jena.rdf.query.parser.Q_URI;
import com.hp.hpl.jena.rdf.query.parser.Q_URL;
import com.hp.hpl.jena.rdf.query.parser.Q_Var;
import com.hp.hpl.jena.rdf.query.parser.RDQLParser;
import com.hp.hpl.jena.rdf.query.parser.SimpleNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Q_Query
extends SimpleNode {
    private Query query = null;
    Map prefixMap = null;
    boolean selectAllVars = false;

    public Q_Query(int n) {
        super(n);
    }

    public Q_Query(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public void phase2(Query query) {
        this.query = query;
        try {
            int n = 0;
            int n2 = this.jjtGetNumChildren();
            if (!(this.jjtGetChild(n) instanceof Q_SelectClause)) {
                throw new RDQL_InternalErrorException("Parser didn't catch absense of select clause");
            }
            this.extractVarList(query, this.jjtGetChild(n));
            if (this.jjtGetChild(++n) instanceof Q_SourceClause) {
                Node node = this.jjtGetChild(n).jjtGetChild(0).jjtGetChild(0);
                String string = ((Q_URL)node).urlString;
                query.setSourceURL(string);
                ++n;
            }
            if (!(this.jjtGetChild(n) instanceof Q_TriplePatternClause)) {
                throw new RDQL_InternalErrorException("Parser didn't catch absense of triple patterns");
            }
            this.extractTriplePatterns(query, this.jjtGetChild(n));
            if (++n >= n2) {
                return;
            }
            if (this.jjtGetChild(n) instanceof Q_ConstraintClause) {
                this.extractConstraints(query, this.jjtGetChild(n));
                ++n;
            }
            if (n >= n2) {
                return;
            }
            if (this.jjtGetChild(n) instanceof Q_PrefixesClause) {
                this.extractPrefixes(query, this.jjtGetChild(n));
                ++n;
            }
            this.fixup(this);
        }
        catch (ClassCastException classCastException) {
            throw new RDQL_InternalErrorException("Parser generated illegal parse tree: " + classCastException);
        }
        catch (RDQL_InternalErrorException rDQL_InternalErrorException) {
            throw rDQL_InternalErrorException;
        }
        catch (Exception exception) {
            throw new RDQL_InternalErrorException("Unknown exception: " + exception);
        }
    }

    public String toString() {
        return "Sorry - not Implemented";
    }

    private void extractVarList(Query query, Node node) {
        int n = node.jjtGetNumChildren();
        this.selectAllVars = n == 0;
        int n2 = 0;
        while (n2 < n) {
            Node node2 = node.jjtGetChild(n2);
            if (!(node2 instanceof Q_Var)) {
                throw new RDQL_InternalErrorException("Internal error: parser created '" + node2.getClass().getName() + "' when Q_Var expected");
            }
            Q_Var q_Var = (Q_Var)node2;
            query.addResultVar(q_Var.varName);
            ++n2;
        }
    }

    private void extractTriplePatterns(Query query, Node node) {
        Object object;
        Object object2;
        Q_TriplePatternClause q_TriplePatternClause = (Q_TriplePatternClause)node;
        ArrayList arrayList = new ArrayList();
        int n = q_TriplePatternClause.jjtGetNumChildren();
        int n2 = 0;
        while (n2 < n) {
            object2 = (Q_TriplePattern)q_TriplePatternClause.jjtGetChild(n2);
            if (((SimpleNode)object2).jjtGetNumChildren() != 3) {
                throw new RDQL_InternalErrorException("Triple pattern has " + ((SimpleNode)object2).jjtGetNumChildren() + " children");
            }
            object = new Slot();
            Slot slot = new Slot();
            Slot slot2 = new Slot();
            this.doSlot((Slot)object, arrayList, ((SimpleNode)object2).jjtGetChild(0));
            this.doSlot(slot, arrayList, ((SimpleNode)object2).jjtGetChild(1));
            this.doSlot(slot2, arrayList, ((SimpleNode)object2).jjtGetChild(2));
            TriplePattern triplePattern = new TriplePattern((Slot)object, slot, slot2);
            query.addTriplePattern(triplePattern);
            ++n2;
        }
        if (this.selectAllVars) {
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                query.addResultVar((String)object);
            }
        }
    }

    private void doSlot(Slot slot, List list, Node node) {
        if (node instanceof Var) {
            Var var = (Var)((Object)node);
            if (!list.contains(var.getVarName())) {
                list.add(var.getVarName());
            }
            slot.set((Var)((Object)node));
        } else {
            slot.set((Value)((Object)node));
        }
    }

    private void extractConstraints(Query query, Node node) {
        Q_ConstraintClause q_ConstraintClause = (Q_ConstraintClause)node;
        int n = q_ConstraintClause.jjtGetNumChildren();
        int n2 = 0;
        while (n2 < n) {
            Expr expr = (Expr)((Object)q_ConstraintClause.jjtGetChild(n2));
            query.addConstraint(new ConstraintExpr(expr));
            ++n2;
        }
    }

    private void extractPrefixes(Query query, Node node) {
        this.prefixMap = new HashMap();
        Q_PrefixesClause q_PrefixesClause = (Q_PrefixesClause)node;
        int n = q_PrefixesClause.jjtGetNumChildren();
        int n2 = 0;
        while (n2 < n) {
            Q_PrefixDecl q_PrefixDecl = (Q_PrefixDecl)q_PrefixesClause.jjtGetChild(n2);
            int n3 = 0;
            while (n3 < q_PrefixDecl.jjtGetNumChildren()) {
                Q_Identifier q_Identifier = (Q_Identifier)q_PrefixDecl.jjtGetChild(n3);
                Q_URI q_URI = (Q_URI)q_PrefixDecl.jjtGetChild(n3 + 1);
                this.prefixMap.put(q_Identifier.toString(), q_URI.toString());
                n3 += 2;
            }
            ++n2;
        }
    }
}

