/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.parser;

import com.hp.hpl.jena.rdf.query.parser.Literal;
import com.hp.hpl.jena.rdf.query.parser.Q_Query;
import com.hp.hpl.jena.rdf.query.parser.RDQLParser;

class Q_URI
extends Literal {
    String seen = "";
    boolean isAbsolute = false;
    static final String prefixOperator = ":";

    Q_URI(int n) {
        super(n);
    }

    Q_URI(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    void accumulate(String string) {
        this.seen = this.seen + string;
    }

    public void jjtClose() {
        super.setURI(this.seen);
    }

    public static String processEscapes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (true) {
            int n3;
            if ((n3 = string.indexOf("%", n2)) < 0 || n3 + 2 >= n) {
                stringBuffer.append(string.substring(n2));
                return stringBuffer.toString();
            }
            stringBuffer.append(string.substring(n2, n3));
            int n4 = Character.digit(string.charAt(n3 + 1), 16);
            int n5 = Character.digit(string.charAt(n3 + 2), 16);
            stringBuffer.append((char)(n4 * 16 + n5));
            n2 = n3 + 3;
        }
    }

    public void fixup(Q_Query q_Query) {
        if (!this.isAbsolute) {
            this.absolute(q_Query);
        }
    }

    private void absolute(Q_Query q_Query) {
        int n = this.seen.indexOf(prefixOperator);
        if (n < 0) {
            this.isAbsolute = true;
            return;
        }
        String string = this.seen.substring(0, n);
        String string2 = (String)q_Query.prefixMap.get(string);
        if (string2 == null) {
            this.isAbsolute = true;
            return;
        }
        String string3 = this.seen.substring(n + prefixOperator.length());
        super.setURI(string2 + string3);
        this.isAbsolute = true;
    }
}

