/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.ContainerI;
import com.hp.hpl.mesa.rdf.jena.model.ClosableIterator;
import com.hp.hpl.mesa.rdf.jena.model.NodeIterator;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Seq;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SeqNodeIteratorImpl
implements NodeIterator {
    Iterator iterator;
    Object object;
    Statement stmt = null;
    Seq seq;
    int size;
    int index = 0;
    int numDeleted = 0;

    public SeqNodeIteratorImpl(Iterator iterator, Object object, Seq seq) throws RDFException {
        this.iterator = iterator;
        this.object = object;
        this.seq = seq;
        this.size = seq.size();
    }

    public boolean hasNext() throws RDFException {
        return this.iterator.hasNext();
    }

    public RDFNode next() throws NoSuchElementException, RDFException {
        if (this.iterator != null) {
            this.stmt = (Statement)this.iterator.next();
            ++this.index;
            return this.stmt.getObject();
        }
        throw new RDFException(8);
    }

    public void remove() throws NoSuchElementException, RDFException {
        if (this.stmt == null) {
            throw new NoSuchElementException();
        }
        ((ContainerI)((Object)this.seq)).remove(this.index - this.numDeleted, this.stmt.getObject());
        this.stmt = null;
        ++this.numDeleted;
    }

    public void close() throws RDFException {
        if (this.iterator instanceof ClosableIterator) {
            ((ClosableIterator)this.iterator).close();
        }
        this.iterator = null;
        this.object = null;
    }
}

