/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.rdb.DriverGenericGeneric;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetStringIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.SQLCache;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;

public class DriverGenericMMGeneric
extends DriverGenericGeneric
implements IRDBDriver {
    protected static Properties m_defaultMMSQL = null;
    protected static final String MMSQL_DEFAULT_FILE = "etc/generic_mmgeneric.sql";

    public DriverGenericMMGeneric() {
        this.LAYOUT_TYPE = "MMGeneric";
        this.DATABASE_TYPE = "Generic";
        this.SQL_FILE = MMSQL_DEFAULT_FILE;
    }

    protected Properties getDefaultSQL() throws IOException {
        if (m_defaultMMSQL == null) {
            m_defaultMMSQL = SQLCache.loadSQLFile(MMSQL_DEFAULT_FILE, null, this.ID_SQL_TYPE);
        }
        return m_defaultMMSQL;
    }

    public boolean supportsMultipleModels() {
        return true;
    }

    public IDBID allocateModelID(String string) throws RDFRDBException {
        try {
            IDBID iDBID = null;
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("getModelID", new Object[]{string});
            if (resultSetIterator != null && resultSetIterator.hasNext()) {
                iDBID = this.wrapDBID(resultSetIterator.getSingleton());
            } else if (!this.SKIP_ALLOCATE_ID) {
                resultSetIterator = this.m_sql.runSQLQuery("allocateModelID", null);
                iDBID = this.wrapDBID(resultSetIterator.getSingleton());
                this.m_sql.runSQLQuery("insertModelID", new Object[]{string, iDBID.getID()});
            } else {
                this.m_sql.runSQLQuery("insertModelID", new Object[]{string});
                iDBID = this.getModelID(string);
            }
            return iDBID;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to allocate new model id", (Exception)sQLException);
        }
    }

    public IDBID getModelID(String string) throws RDFRDBException {
        try {
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery("getModelID", new Object[]{string});
            return this.wrapDBID(resultSetIterator.getSingleton());
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("No such model called: " + string + " found in database", (Exception)sQLException);
        }
    }

    public Iterator listModels() throws RDFRDBException {
        try {
            return this.m_sql.runSQLQuery("listModels", null, new ResultSetStringIterator());
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Problem listing models", (Exception)sQLException);
        }
    }
}

