/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.document;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.utils.Date;
import fr.gouv.culture.sdx.utils.Utilities;

/**An OAI document in a SDX documents collection has a date of harvest and an OAI identifier.
 *Those informations will be use for update and/or deletion.
 * @author Malo Pichot
 */
public class OAIDocument extends XMLDocument {

  private String dateString = null;
  private String identifier = null;
  public static final String INTERNAL_FIELD_NAME_SDXOAIDATE = "sdxoaidate";
  public static final String INTERNAL_FIELD_NAME_SDXOAIID = "sdxoaiid";


    public OAIDocument() {
    	//Nothing here
    }

    /**A method to add system fields: date of the harvest, OAI identifier of the document.*/
    public void addAdditionalSystemFields(Document doc) {
    	
        if(Utilities.checkString(dateString)) {
            long oaidate = Date.parseUtcISO8601Date(dateString).getTime();
            Field dateField = Field.Keyword(OAIDocument.INTERNAL_FIELD_NAME_SDXOAIDATE, DateField.timeToString(oaidate));
            if(dateField != null)
                doc.add(dateField);
        }
        
        if(Utilities.checkString(identifier)) {
            Field idField = Field.Keyword(INTERNAL_FIELD_NAME_SDXOAIID, identifier);
            if(idField != null)
                doc.add(idField);
        }
    }

    public String getDateString() {
        return dateString;
    }

    public void setDateString(String dateString) {
        this.dateString = dateString;
    }

    public String getIdentifier() {
        return identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

}
