/*
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
*/
package fr.gouv.culture.sdx.oai;

import fr.gouv.culture.sdx.framework.Framework;
import fr.gouv.culture.sdx.utils.Utilities;
//import fr.gouv.culture.sdx.utils.constants.Node;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/**
 * Created by IntelliJ IDEA.
 * User: rpandey
 * Date: May 6, 2003
 * Time: 3:33:51 PM
 * To change this template use Options | File Templates.
 */
public class SDXOAIMetadataFormat extends BasicOAIMetadataFormat {

    /**Sub path of sdx web documentation*/
    public static final String VERSION_PATH = "doc-sdx2";
    /**Path to the schema defining this metadata format*/
    public static final String DEFAULT_SCHEMA_URL = "http://www.nongnu.org/sdx/docs/html/" + VERSION_PATH + "/schemas/sdx-oai-metadata-format.xsd";

    /**Builds the object
     * and sets default values
     */
    public SDXOAIMetadataFormat() {
        super();
        super.formatName = "SDX Fields";
        super.prefix = Framework.SDXNamespacePrefix;
        super.namespace = Framework.SDXNamespaceURI;
        super.schemaUrl = DEFAULT_SCHEMA_URL;
        super.rootElement = super.prefix;
    }


    /**Configures this object
     *(no pipeline configuration accepted)
     * @param configuration
     * @throws ConfigurationException
     */
    public void configure(Configuration configuration) throws ConfigurationException {
        if (configuration != null) {
            //providing static defaults, but will allow user configuration attributes to override
            this.formatName = configuration.getAttribute(ATTRIBUTE_NAME_NAME, this.formatName);
            this.prefix = configuration.getAttribute(ATTRIBUTE_NAME_METADATA_PREFIX, this.prefix);
            this.namespace = configuration.getAttribute(ATTRIBUTE_NAME_NAMESPACE, this.namespace);
            this.schemaUrl = configuration.getAttribute(ATTRIBUTE_NAME_SCHEMA_URL, this.schemaUrl);
            this.rootElement = configuration.getAttribute(ATTRIBUTE_NAME_ROOT_ELEMENT, this.rootElement);
            //configuring the metadata field mappings
            configureFields(configuration);
            //configuring the pipeline if any
            configurePipeline(configuration);
        }

    }

    /**Configures the field mappings
     *
     * @param configuration
     * @throws ConfigurationException
     */
    protected void configureFields(Configuration configuration) throws ConfigurationException {
        if (configuration != null) {
            Configuration[] oaiFieldsConf = configuration.getChild(ELEMENT_NAME_OAI_FIELDS, true).getChildren(ELEMENT_NAME_OAI_FIELD);
            if (oaiFieldsConf.length > 0) {
                for (int i = 0; i < oaiFieldsConf.length; i++) {
                    Configuration oaiFieldConf = oaiFieldsConf[i];
                    String sdxFieldName = oaiFieldConf.getAttribute(ATTRIBUTE_NAME_SDXFIELD);
                    String repeated = oaiFieldConf.getAttribute(ATTRIBUTE_NAME_REPEATED, ATTRIBUTE_NAME_REPEATED);
                    if (ATTRIBUTE_VALUE_CONCATENATE.equals(repeated)) {
                        if (concatenateFields == null) concatenateFields = new Parameters();
                        String separator = oaiFieldConf.getAttribute(ATTRIBUTE_NAME_SEPARATOR, DEFAULT_CONCATENATED_FIELD_SEPARATOR);
                        concatenateFields.setParameter(sdxFieldName, separator);
                    }
                }
            }
        }
    }

    /**Sends and element to the objects consumer
     * respecting the sdx oai metadata format
     *
     * @param origName
     * @param value
     * @throws SAXException
     */
    protected void prepareAndSendElement(String origName, String value) throws SAXException {
        if (Utilities.checkString(this.namespace) && Utilities.checkString(prefix)
                && Utilities.checkString(origName) && Utilities.checkString(value)) {
            String uri = this.namespace;
            String locName = "field";
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("",
                    fr.gouv.culture.sdx.utils.constants.Node.Name.NAME,
                    fr.gouv.culture.sdx.utils.constants.Node.Name.NAME, Node.Type.CDATA, origName);


            super.sendElement(uri, locName, locName, atts, value);
        }
    }


}
