/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.oai;

import fr.gouv.culture.oai.OAIError;
import fr.gouv.culture.oai.OAIObjectImpl;
import fr.gouv.culture.oai.OAIRepository;
import fr.gouv.culture.oai.OAIRequest;
import fr.gouv.culture.oai.OAIRequestImpl;
import fr.gouv.culture.oai.util.OAIUtilities;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.FileSource;
import org.apache.cocoon.environment.Request;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractOAIRepository
extends OAIObjectImpl
implements OAIRepository {
    protected String[] adminEmails = null;
    protected String protocolVersion = "";
    protected String repositoryName = "";
    protected String baseURL = "";
    protected String granularity = "";
    protected String deletedRecord = "";
    protected String earliestDatestamp = "";
    protected String compression = "";
    protected FileSource description = null;
    protected Hashtable metadataFormats = null;

    public void identify(OAIRequest request) throws SAXException {
        this.startVerbEvent(request);
        String oai20xmlns = "http://www.openarchives.org/OAI/2.0/";
        String locQualName = "";
        if (OAIUtilities.checkString(this.repositoryName)) {
            locQualName = "repositoryName";
            this.sendElement(oai20xmlns, locQualName, locQualName, null, this.repositoryName);
        }
        if (OAIUtilities.checkString(this.baseURL)) {
            locQualName = "baseURL";
            this.sendElement(oai20xmlns, locQualName, locQualName, null, this.baseURL);
        }
        if (OAIUtilities.checkString(this.protocolVersion)) {
            locQualName = "protocolVersion";
            this.sendElement(oai20xmlns, locQualName, locQualName, null, this.protocolVersion);
        }
        for (int i = 0; i < this.adminEmails.length; ++i) {
            String s = this.adminEmails[i];
            if (!OAIUtilities.checkString(s)) continue;
            locQualName = "adminEmail";
            this.sendElement(oai20xmlns, locQualName, locQualName, null, s);
        }
        String eds = this.getEarliestDatestamp();
        if (OAIUtilities.checkString(eds)) {
            locQualName = "earliestDatestamp";
            this.sendElement(oai20xmlns, locQualName, locQualName, null, eds);
        }
        if (OAIUtilities.checkString(this.deletedRecord)) {
            locQualName = "deletedRecord";
            this.sendElement(oai20xmlns, locQualName, locQualName, null, this.deletedRecord);
        }
        if (OAIUtilities.checkString(this.granularity)) {
            locQualName = "granularity";
            this.sendElement(oai20xmlns, locQualName, locQualName, null, this.granularity);
        }
        if (OAIUtilities.checkString(this.compression)) {
            locQualName = "compression";
            this.sendElement(oai20xmlns, locQualName, locQualName, null, this.compression);
        }
        if (this.description != null) {
            locQualName = "description";
            this.startElement(oai20xmlns, locQualName, locQualName, new AttributesImpl());
            try {
                this.description.toSAX((ContentHandler)this.xmlConsumer);
            }
            catch (ProcessingException e) {
                throw new SAXException(e.getMessage(), (Exception)((Object)e));
            }
            this.endElement(oai20xmlns, locQualName, locQualName);
        }
        this.endVerbEvent(request);
    }

    public String getDeletedRecord() {
        return this.deletedRecord;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getEarliestDatestamp() {
        return this.earliestDatestamp;
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String[] getAdminEmails() {
        return this.adminEmails;
    }

    public String getCompression() {
        return this.compression;
    }

    public void getDescription(ContentHandler handler) throws SAXException {
        try {
            if (this.description != null && handler != null) {
                this.description.toSAX(handler);
            }
        }
        catch (ProcessingException e) {
            throw new SAXException(e.getMessage(), (Exception)((Object)e));
        }
    }

    public boolean verifyParameters(OAIRequest request) throws SAXException {
        boolean ret = true;
        if (request == null) {
            return false;
        }
        Request httpRequest = request.getRequest();
        if (httpRequest == null) {
            return false;
        }
        int verb = request.getVerb();
        HashSet<String> requiredParamNames = new HashSet<String>();
        requiredParamNames.add("verb");
        HashSet<String> optionalParamNames = new HashSet<String>();
        switch (verb) {
            case 0: {
                break;
            }
            case 1: {
                optionalParamNames.add("resumptionToken");
                break;
            }
            case 2: {
                optionalParamNames.add("identifier");
                break;
            }
            case 3: {
                if (OAIUtilities.checkString(request.getResumptionToken())) {
                    requiredParamNames.add("resumptionToken");
                    break;
                }
                requiredParamNames.add("metadataPrefix");
                optionalParamNames.add("set");
                optionalParamNames.add("from");
                optionalParamNames.add("until");
                break;
            }
            case 4: {
                if (OAIUtilities.checkString(request.getResumptionToken())) {
                    requiredParamNames.add("resumptionToken");
                    break;
                }
                requiredParamNames.add("metadataPrefix");
                optionalParamNames.add("set");
                optionalParamNames.add("from");
                optionalParamNames.add("until");
                break;
            }
            case 5: {
                requiredParamNames.add("identifier");
                requiredParamNames.add("metadataPrefix");
                break;
            }
        }
        Enumeration paramsNamesEnum = httpRequest.getParameterNames();
        ArrayList<String> paramNames = null;
        if (paramsNamesEnum != null) {
            if (paramNames == null) {
                paramNames = new ArrayList<String>();
            }
            while (paramsNamesEnum.hasMoreElements()) {
                String paramName = (String)paramsNamesEnum.nextElement();
                paramName = OAIUtilities.normalizeHttpRequestParameterName(paramName);
                paramNames.add(paramName);
            }
        }
        Iterator iter = requiredParamNames.iterator();
        while (iter.hasNext()) {
            String requiredParamName = (String)iter.next();
            if (paramNames.contains(requiredParamName)) continue;
            new OAIError(0, "The request is missing the required argument, " + requiredParamName + ".").toSAX((ContentHandler)((Object)this));
        }
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramVal;
            String paramName = (String)paramNames.get(i);
            if (!OAIUtilities.checkString(paramName)) continue;
            if (!requiredParamNames.contains(paramName) & !optionalParamNames.contains(paramName)) {
                new OAIError(0, "The request includes the illegal argument, " + paramName + ".").toSAX((ContentHandler)((Object)this));
                ret = false;
                continue;
            }
            String[] paramValues = httpRequest.getParameterValues(paramName);
            if (paramValues == null || paramValues.length <= 0) continue;
            if (paramValues.length > 1) {
                new OAIError(0, "The request includes the duplicate argument, " + paramName + ", only the first value provided, " + paramValues[i] + ", was used in processing this request.").toSAX((ContentHandler)((Object)this));
                ret = false;
            }
            if (!OAIUtilities.checkString(paramVal = paramValues[0])) {
                new OAIError(0, "The value of the parameter with the name, " + paramName + ", wall null or an empty String").toSAX((ContentHandler)((Object)this));
                ret = false;
                continue;
            }
            if ("metadataPrefix".equals(paramName)) {
                String mdPrefix = paramVal;
                if (this.metadataFormats.containsKey(mdPrefix) || OAIUtilities.checkString(request.getResumptionToken())) continue;
                new OAIError(3, "The metadata format identified by the value given for the metadataPrefix argument, " + mdPrefix + ", is not supported by the repository.").toSAX((ContentHandler)((Object)this));
                ret = false;
                continue;
            }
            if (!"from".equals(paramName) && !"until".equals(paramName)) continue;
            if (!this.verifyGranularity(paramVal)) {
                new OAIError(0, "The value of the \"" + paramName + "\" argument, " + paramVal + ", is invalid. ").toSAX((ContentHandler)((Object)this));
            }
            ret = false;
        }
        return ret;
    }

    public abstract boolean verifyGranularity(String var1);

    protected void sendNoSetHierarchyError() throws SAXException {
        new OAIError(7, "This repository does not support set hierarchies").toSAX((ContentHandler)((Object)this));
    }

    protected void sendResumptionTokensNotSupportedError() throws SAXException {
        new OAIError(1, "This repository does not support resumptionTokens").toSAX((ContentHandler)((Object)this));
    }

    protected void startVerbEvent(OAIRequest request) throws SAXException {
        String verb = request.getVerbString();
        if (OAIUtilities.checkString(verb)) {
            super.startElement("http://www.openarchives.org/OAI/2.0/", verb, verb, null);
        }
    }

    protected void endVerbEvent(OAIRequest request) throws SAXException {
        String verb = request.getVerbString();
        if (OAIUtilities.checkString(verb)) {
            super.endElement("http://www.openarchives.org/OAI/2.0/", verb, verb);
        }
    }

    public void toSAX(ContentHandler contentHandler) throws SAXException {
        ContentHandler currentHandler = this.contentHandler;
        this.setContentHandler(contentHandler);
        OAIRequestImpl request = new OAIRequestImpl();
        request.setVerb(0);
        this.identify(request);
        this.setContentHandler(currentHandler);
    }

    public void sendResumptionToken(String resumptionToken) throws SAXException {
        this.sendResumptionToken(resumptionToken, null, null);
    }

    public void sendResumptionToken(String resumptionToken, String cursor) throws SAXException {
        this.sendResumptionToken(resumptionToken, cursor, null);
    }

    public void sendResumptionToken(String resumptionToken, String cursor, String completeListSize) throws SAXException {
        if (OAIUtilities.checkString(resumptionToken) | OAIUtilities.checkString(cursor) | OAIUtilities.checkString(completeListSize)) {
            AttributesImpl atts = new AttributesImpl();
            if (OAIUtilities.checkString(cursor)) {
                atts.addAttribute("", "cursor", "cursor", "CDATA", cursor);
            }
            if (OAIUtilities.checkString(completeListSize)) {
                atts.addAttribute("", "completeListSize", "completeListSize", "CDATA", completeListSize);
            }
            super.sendElement("http://www.openarchives.org/OAI/2.0/", "resumptionToken", "resumptionToken", atts, resumptionToken);
        }
    }
}

