/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.documentbase;

import fr.gouv.culture.oai.OAIHarvester;
import fr.gouv.culture.oai.OAIRepository;
import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.IndexableDocument;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.documentbase.DocumentBase;
import fr.gouv.culture.sdx.documentbase.IDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.pipeline.GenericPipeline;
import fr.gouv.culture.sdx.pipeline.Pipeline;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.DatabaseBacked;
import fr.gouv.culture.sdx.utils.database.DatabaseEntity;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractDocumentBase
extends DatabaseBacked
implements DocumentBase {
    protected DefaultContext context = null;
    protected boolean isDefault = false;
    protected Pipeline indexationPipeline = null;
    protected Hashtable repositories = null;
    protected Repository defaultRepository = null;
    protected OAIRepository oaiRepo = null;
    protected OAIHarvester oaiHarv = null;
    protected Locale locale = null;
    protected Hashtable repoConnectionPool = null;
    IDGenerator idGen = null;
    protected final String PROPERTY_NAME_ATTACHED = "attached";
    protected final String PROPERTY_NAME_ORIGINAL = "original";
    protected final String PROPERTY_NAME_SUB = "sub";
    protected final String PROPERTY_NAME_PARENT = "parent";
    protected final String DBELEM_ATTRIBUTE_DEFAULT = "default";
    protected final String DBELEM_ATTRIBUTE_KEEP_ORIGINAL = "keepOriginalDocuments";
    protected final String ELEMENT_NAME_INDEX = "index";
    protected final String ELEMENT_NAME_PIPELINE = "pipeline";
    public static final String ELEMENT_NAME_OAI_REPOSITORY = "oai-repository";
    public static final String ELEMENT_NAME_OAI_HARVESTER = "oai-harvester";
    protected static final String PROPERTY_NAME_REPO = "repo";
    protected static final String PROPERTY_NAME_MIMETYPE = "mimetype";
    protected static final String PROPERTY_NAME_CONTENT_LENGTH = "content-length";
    protected final String PROPERTY_NAME_DOCTYPE = "sdxDocType";
    public static final String INTERNAL_FIELD_NAME_SDXDOCID = "sdxdocid";
    public static final String INTERNAL_FIELD_NAME_SDXALL = "sdxall";
    public static final String INTERNAL_SDXALL_FIELD_VALUE = "1";
    public static final String INTERNAL_FIELD_NAME_SDXAPPID = "sdxappid";
    public static final String INTERNAL_FIELD_NAME_SDXDBID = "sdxdbid";
    public static final String INTERNAL_FIELD_NAME_SDXREPOID = "sdxrepoid";
    public static final String INTERNAL_FIELD_NAME_SDXDOCTYPE = "sdxdoctype";
    public static final String INTERNAL_FIELD_NAME_SDXMODDATE = "sdxmoddate";
    public static final String INTERNAL_FIELD_NAME_SDXCONTENTLENGTH = "sdxcontentlength";
    public static final String INTERNAL_FIELD_NAME_SDX_OAI_DELETED_RECORD = "sdxOaiDeletedRecord";

    public void contextualize(Context context) throws ContextException {
        if (context == null) {
            throw new ContextException("Context provided was null", null);
        }
        this.context = (DefaultContext)context;
    }

    public void setId(String id) throws SDXException {
        if (!Utilities.checkString(id)) {
            String[] args = new String[]{this.toString()};
            throw new SDXException(this.logger, 212, args, null);
        }
        super.setId(id);
    }

    public String getId() {
        return super.getId();
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public Pipeline getIndexationPipeline() {
        try {
            return this.indexationPipeline.newInstance();
        }
        catch (SDXException e) {
            Utilities.logException(this.logger, e);
            return null;
        }
    }

    public String getMimeType(Document doc) throws SDXException {
        DatabaseEntity ent = null;
        Utilities.checkDocument(this.logger, doc);
        try {
            ent = this.database.getEntity(doc.getId());
        }
        catch (SDXException e) {
            return "application/octet-stream";
        }
        if (ent == null) {
            return "application/octet-stream";
        }
        ent.enableLogging(this.logger);
        String mimeType = ent.getProperty(PROPERTY_NAME_MIMETYPE);
        if (!Utilities.checkString(mimeType)) {
            return "application/octet-stream";
        }
        return mimeType;
    }

    protected void configurePipeline(Configuration configuration) throws ConfigurationException {
        Configuration pipeConf = configuration.getChild("index", true).getChild("pipeline", false);
        if (pipeConf == null) {
            String[] args = new String[]{configuration.getLocation()};
            SDXException sdxE = new SDXException(null, 16, args, null);
            Utilities.logWarn(this.logger, sdxE.getMessage(), sdxE);
        }
        this.indexationPipeline = new GenericPipeline();
        this.indexationPipeline.enableLogging(this.logger);
        try {
            this.indexationPipeline.compose(this._manager);
            this.indexationPipeline.setProperties(this.props);
            this.indexationPipeline.configure(pipeConf);
        }
        catch (ComponentException e) {
            throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
        }
    }

    public void getDocument(ParsableDocument doc, XMLConsumer consumer) throws SDXException {
        Utilities.checkDocument(this.logger, doc);
        Utilities.checkXmlConsumer(this.logger, consumer);
    }

    public void getDocument(Document doc, OutputStream os) throws SDXException {
        Utilities.checkDocument(this.logger, doc);
        Utilities.checkOutputStream(this.logger, os);
    }

    public InputStream getDocument(Document doc) throws SDXException {
        Utilities.checkDocument(this.logger, doc);
        return null;
    }

    public Repository getDefaultRepository() {
        return this.defaultRepository;
    }

    public Repository getRepository(String id) throws SDXException {
        if (id == null) {
            return this.defaultRepository;
        }
        Repository repo = (Repository)this.repositories.get(id);
        if (repo == null) {
            String[] args = new String[]{id, this.id};
            throw new SDXException(this.logger, 1002, args, null);
        }
        return repo;
    }

    public OAIRepository getOAIRepository() {
        return this.oaiRepo;
    }

    public OAIHarvester getOAIHarvester() {
        return this.oaiHarv;
    }

    public void toSAX(ContentHandler hdl) throws SAXException, ProcessingException {
    }

    protected void addOaiDeletedRecord(IndexableDocument doc) throws SDXException {
        if (this.oaiRepo != null) {
            this.oaiRepo.addDeletedRecord(doc.getId());
        }
    }

    protected void removeOaiDeletedRecord(IndexableDocument doc) throws SDXException {
        if (this.oaiRepo != null) {
            this.oaiRepo.removeDeletedRecord(doc.getId());
        }
    }

    protected synchronized void optimizeDatabase() throws SDXException {
        if (this.database != null) {
            this.database.optimize();
        }
    }

    protected synchronized void optimizeRepositories() throws SDXException {
        Enumeration repos;
        if (this.repoConnectionPool != null && !this.repoConnectionPool.isEmpty() && (repos = this.repositories.elements()) != null) {
            while (repos.hasMoreElements()) {
                Repository repo = (Repository)repos.nextElement();
                if (repo == null) continue;
                repo.optimize();
            }
        }
    }

    protected synchronized void releasePooledRepositoryConnections() throws SDXException {
        Enumeration openConnections = null;
        if (this.repoConnectionPool != null) {
            openConnections = this.repoConnectionPool.keys();
        }
        if (openConnections != null) {
            while (openConnections.hasMoreElements()) {
                String repoId = (String)openConnections.nextElement();
                RepositoryConnection conn = (RepositoryConnection)this.repoConnectionPool.get(repoId);
                Repository repo = this.getRepository(repoId);
                if (repo != null && conn != null) {
                    conn.commit();
                    repo.releaseConnection(conn);
                }
                this.repoConnectionPool.remove(repoId);
            }
        }
    }

    protected synchronized RepositoryConnection getPooledRepositoryConnection(String repoId) throws SDXException {
        if (this.repoConnectionPool == null) {
            this.repoConnectionPool = new Hashtable();
        }
        RepositoryConnection conn = null;
        if (Utilities.checkString(repoId)) {
            if (this.repoConnectionPool.containsKey(repoId)) {
                conn = (RepositoryConnection)this.repoConnectionPool.get(repoId);
            } else {
                Repository repo = (Repository)this.repositories.get(repoId);
                if (repo != null && (conn = repo.getConnection()) != null) {
                    this.repoConnectionPool.put(repoId, conn);
                }
            }
        }
        return conn;
    }

    protected DatabaseEntity createEntityForDocMetaData(Document doc, Repository repository, String[] parentDocId) throws SDXException {
        String length;
        DatabaseEntity docLookupEntry = new DatabaseEntity(doc.getId());
        docLookupEntry.enableLogging(this.logger);
        if (repository != null) {
            docLookupEntry.addProperty(PROPERTY_NAME_REPO, repository.getId());
        }
        docLookupEntry.addProperty("sdxDocType", doc.getDocType());
        if (Utilities.checkString(doc.getMimeType())) {
            docLookupEntry.addProperty(PROPERTY_NAME_MIMETYPE, doc.getMimeType());
        }
        if (Utilities.checkString(length = Integer.toString(doc.getLength()))) {
            docLookupEntry.addProperty(PROPERTY_NAME_CONTENT_LENGTH, length);
        }
        docLookupEntry.addProperties("parent", parentDocId);
        return docLookupEntry;
    }

    public synchronized void delete(Document doc, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        Utilities.checkDocument(this.logger, doc);
        Document[] docs = new Document[]{doc};
        this.delete(docs, handler);
    }

    protected void deletePhysicalDocument(Document doc, Repository repo, ContentHandler handler) throws SDXException, SAXException, ProcessingException {
        Utilities.checkDocument(this.logger, doc);
        RepositoryConnection conn = null;
        DatabaseEntity ent = null;
        if (repo != null) {
            conn = this.getPooledRepositoryConnection(repo.getId());
            ent = this.database.getEntity(doc.getId());
            if (ent != null) {
                this.database.delete(ent);
            }
            if (conn != null) {
                repo.delete(doc, conn);
            }
        }
        if (handler != null) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "id", "id", "CDATA", doc.getId());
            if (repo != null) {
                atts.addAttribute("", PROPERTY_NAME_REPO, PROPERTY_NAME_REPO, "CDATA", repo.getId());
            }
            atts.addAttribute("", "base", "base", "CDATA", this.getId());
            String appId = Utilities.getStringFromHashtable("appId", this.props);
            if (Utilities.checkString(appId)) {
                atts.addAttribute("", "app", "app", "CDATA", appId);
            }
            if (ent != null) {
                String length;
                String mimeType = ent.getProperty(PROPERTY_NAME_MIMETYPE);
                if (Utilities.checkString(mimeType)) {
                    atts.addAttribute("", PROPERTY_NAME_MIMETYPE, PROPERTY_NAME_MIMETYPE, "CDATA", mimeType);
                }
                if (Utilities.checkString(length = ent.getProperty(PROPERTY_NAME_CONTENT_LENGTH))) {
                    atts.addAttribute("", "byte-length", "byte-length", "CDATA", length);
                }
            }
            handler.startElement("http://www.culture.gouv.fr/ns/sdx/sdx", "document", "sdx:document", atts);
            handler.endElement("http://www.culture.gouv.fr/ns/sdx/sdx", "document", "sdx:document");
        }
    }
}

