/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.exception;

import fr.gouv.culture.sdx.exception.SDXExceptionCode;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.xml.XMLizable;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SDXException
extends Exception
implements XMLizable,
SDXExceptionCode {
    protected Locale locale = Locale.getDefault();
    private static final String propertiesBaseName = "fr.gouv.culture.sdx.exception.errors";
    private int errorCode = -1;
    private String errorKey;
    private String[] arguments;
    private Logger logger = null;
    private Throwable originalError = null;
    private Locale defaultLocale = Locale.ENGLISH;

    public SDXException(Logger l, int code, String[] args, Throwable e) {
        this.logger = l;
        this.errorCode = code;
        this.errorKey = "error." + this.errorCode;
        this.originalError = e;
        this.arguments = args != null ? args : new String[0];
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] != null) continue;
            this.arguments[i] = "missing exception detail";
        }
        this.log();
    }

    private void log() {
        if (this.logger != null) {
            String message = this.getMessage();
            if (!Utilities.checkString(message)) {
                message = "noMessageProvided";
            }
            if (this.originalError != null && this.originalError.fillInStackTrace() != null) {
                this.logger.error(message, this.originalError.fillInStackTrace());
            } else {
                this.logger.error(message, (Throwable)this);
            }
        }
    }

    public void toSAX(ContentHandler hdl) throws SAXException, ProcessingException {
        this.toSAX(hdl, this.locale);
    }

    private void toSAX(ContentHandler hdl, Locale locale) throws SAXException {
        String sdxNsUri = "http://www.culture.gouv.fr/ns/sdx/sdx";
        String sdxNsPrefix = "sdx";
        String localName = "exception";
        String qName = sdxNsPrefix + ":" + localName;
        AttributesImpl atts = new AttributesImpl();
        String lang = locale.getLanguage();
        if (!"".equals(lang) && !"".equals(locale.getCountry())) {
            lang = lang + "-" + locale.getCountry();
        }
        atts.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", lang);
        atts.addAttribute("", "code", "code", "CDATA", Integer.toString(this.errorCode));
        hdl.startElement(sdxNsUri, localName, qName, atts);
        String childTwoLocalName = "message";
        String childTwoQName = sdxNsPrefix + ":" + childTwoLocalName;
        AttributesImpl childTwoAtts = new AttributesImpl();
        hdl.startElement(sdxNsUri, childTwoLocalName, childTwoQName, childTwoAtts);
        char[] messArr = this.getMessage(locale).toCharArray();
        hdl.characters(messArr, 0, messArr.length);
        hdl.endElement(sdxNsUri, childTwoLocalName, childTwoQName);
        if (this.originalError != null) {
            String childThreeLocalName = "originalException";
            String childThreeQName = sdxNsPrefix + ":" + childThreeLocalName;
            AttributesImpl childThreeAtts = new AttributesImpl();
            hdl.startElement(sdxNsUri, childThreeLocalName, childThreeQName, childThreeAtts);
            try {
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream(byteOut);
                this.originalError.printStackTrace(ps);
                byteOut.flush();
                char[] origExceptArr = byteOut.toString().toCharArray();
                byteOut.close();
                hdl.characters(origExceptArr, 0, origExceptArr.length);
            }
            catch (IOException e) {
                throw new SAXException(e.getMessage(), e);
            }
            finally {
                hdl.endElement(sdxNsUri, childThreeLocalName, childThreeQName);
            }
        }
        hdl.endElement(sdxNsUri, localName, qName);
    }

    public String getMessage() {
        return this.getMessage(this.locale);
    }

    public String getMessage(Locale l) {
        if (l != null) {
            this.locale = l;
        }
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle(propertiesBaseName, this.locale);
        }
        catch (MissingResourceException e) {
            rb = ResourceBundle.getBundle(propertiesBaseName, this.defaultLocale);
        }
        return MessageFormat.format(rb.getString(this.errorKey), this.arguments);
    }
}

