/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.pipeline;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.pipeline.Pipeline;
import fr.gouv.culture.sdx.pipeline.Transformation;
import fr.gouv.culture.sdx.utils.Utilities;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.serialization.XMLSerializer;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLMulticaster;

public abstract class AbstractPipeline
extends AbstractXMLPipe
implements Pipeline {
    protected Configuration configuration = null;
    private Parameters params;
    protected String id = "";
    protected LinkedList transformations = new LinkedList();
    protected Logger logger;
    protected Vector transformsList = new Vector();
    protected ComponentManager manager;
    protected String keepStep = null;
    private ByteArrayOutputStream transformedBytes = null;
    private File transformedFile = null;
    FileOutputStream fOs = null;
    private XMLSerializer xsFile = null;
    private XMLSerializer xsBytes = null;
    private String TEMPFILE_PREFIX = "tempTransDoc";
    private String TEMPFILE_SUFFIX = ".sdx";
    protected Hashtable props;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.loadBaseConfiguration(configuration);
        try {
            this.configureTransformations(configuration);
        }
        catch (SDXException sdxE) {
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
        }
        if (configuration != null) {
            this.params = Parameters.fromConfiguration((Configuration)configuration);
            this.verifyConfigurationParameters(this.params);
        }
    }

    protected void verifyConfigurationParameters(Parameters params) {
        if (params != null) {
            String[] paramNames = params.getNames();
            for (int i = 0; i < paramNames.length; ++i) {
                String paramValue;
                String paramName = paramNames[i];
                if (!Utilities.checkString(paramName) || Utilities.checkString(paramValue = params.getParameter(paramName, null)) && !paramValue.equals("null")) continue;
                params.removeParameter(paramName);
            }
        }
    }

    private void loadBaseConfiguration(Configuration configuration) {
        if (!Utilities.checkString(this.getId()) && configuration != null) {
            this.id = configuration.getAttribute("id", "");
        }
    }

    private void configureTransformations(Configuration configuration) throws ConfigurationException, SDXException {
        Configuration[] transforms = null;
        if (configuration != null) {
            transforms = configuration.getChildren("transformation");
        }
        if (transforms != null) {
            for (int i = 0; i < transforms.length; ++i) {
                String[] args;
                String[] args2;
                Transformation trans = null;
                String transType = transforms[i].getAttribute("type");
                Utilities.checkConfAttributeValue("type", transType, transforms[i].getLocation());
                String transClassName = transType;
                Class<?> transClass = null;
                try {
                    transClass = Class.forName(transClassName);
                }
                catch (ClassNotFoundException e) {
                    args2 = new String[]{transforms[i].getAttribute("id", ""), e.getMessage()};
                    SDXException sdxE = new SDXException(null, 40, args2, e);
                    Utilities.logWarn(this.logger, sdxE.getMessage(), null);
                    transClassName = "fr.gouv.culture.sdx.pipeline." + transType.substring(0, 1).toUpperCase() + transType.substring(1, transType.length()) + "Transformation";
                    try {
                        transClass = Class.forName(transClassName);
                    }
                    catch (ClassNotFoundException e1) {
                        String[] args22 = new String[]{transforms[i].getAttribute("id", ""), e1.getMessage()};
                        SDXException sdxE2 = new SDXException(this.logger, 40, args22, e1);
                        throw new ConfigurationException(sdxE2.getMessage(), (Throwable)sdxE2);
                    }
                }
                Object obj = null;
                try {
                    obj = transClass.newInstance();
                }
                catch (InstantiationException e) {
                    args = new String[]{transforms[i].getAttribute("id", ""), e.getMessage()};
                    throw new SDXException(null, 40, args, e);
                }
                catch (IllegalAccessException e) {
                    args = new String[]{transforms[i].getAttribute("id", ""), e.getMessage()};
                    throw new SDXException(null, 40, args, e);
                }
                if (obj == null) {
                    args2 = new String[]{transClassName};
                    throw new SDXException(this.logger, 220, args2, null);
                }
                if (!(obj instanceof Transformation)) {
                    args2 = new String[]{"Transformation", transClass.getName(), transType};
                    throw new SDXException(this.logger, 10, args2, null);
                }
                trans = obj;
                trans.enableLogging(this.logger);
                try {
                    trans.compose(this.manager);
                }
                catch (ComponentException e) {
                    throw new SDXException(null, 222, null, e);
                }
                trans.setProperties(this.props);
                trans.configure(transforms[i]);
                String transId = trans.getId();
                if (!Utilities.checkString(transId)) continue;
                if (trans.shouldKeepResult()) {
                    this.keepStep = transId;
                }
                this.transformsList.add(trans);
            }
            for (int k = 0; k < this.transformsList.size(); ++k) {
                Transformation t = (Transformation)this.transformsList.get(k);
                if (t == null) continue;
                this.addTransformation(t);
            }
        }
    }

    public void addTransformation(Transformation t) throws SDXException {
        if (this.transformations.size() > 0) {
            Transformation lastTrans = (Transformation)this.transformations.getLast();
            Transformation consumer = null;
            consumer = lastTrans != null && lastTrans.getId() != null && lastTrans.getId().equals(this.keepStep) ? this.multiCastEvents((XMLConsumer)t) : t;
            lastTrans.recycle();
            lastTrans.setConsumer((XMLConsumer)consumer);
        } else {
            super.recycle();
            this.xmlConsumer = t;
            this.contentHandler = t;
            this.lexicalHandler = t;
        }
        this.transformations.add(t);
    }

    public void setConsumer(XMLConsumer xmlConsumer) {
        try {
            Utilities.checkXmlConsumer(this.logger, xmlConsumer);
        }
        catch (SDXException e) {
            // empty catch block
        }
        if (this.transformations.size() > 0) {
            Transformation lastTrans = (Transformation)this.transformations.getLast();
            lastTrans.recycle();
            if (Utilities.checkString(this.keepStep)) {
                if (lastTrans != null && lastTrans.getId() != null && lastTrans.getId().equals(this.keepStep)) {
                    xmlConsumer = this.multiCastEvents(xmlConsumer);
                }
                try {
                    this.resetTransformedDocumentFields();
                }
                catch (SDXException sDXException) {
                    // empty catch block
                }
            }
            lastTrans.setConsumer(xmlConsumer);
        } else {
            super.setConsumer(xmlConsumer);
        }
    }

    private void resetTransformedDocumentFields() throws SDXException {
        this.createTempFileResources();
        this.createTempByteResources();
    }

    private XMLConsumer multiCastEvents(XMLConsumer xmlConsumer) {
        XMLMulticaster connector = null;
        if (this.canBuildTempFile() && this.xsFile == null) {
            this.xsFile = new XMLSerializer();
        }
        if (this.xsBytes == null) {
            this.xsBytes = new XMLSerializer();
        }
        if (this.xsFile != null) {
            XMLMulticaster serializedOutput = new XMLMulticaster((XMLConsumer)this.xsBytes, (XMLConsumer)this.xsFile);
            connector = new XMLMulticaster((XMLConsumer)serializedOutput, xmlConsumer);
        } else {
            connector = new XMLMulticaster((XMLConsumer)this.xsBytes, xmlConsumer);
        }
        return connector;
    }

    public void setParameters(Parameters params) {
        this.params = params;
        this.setParametersToTransformations(this.params);
    }

    protected void setParametersToTransformations(Parameters parameters) {
        if (this.transformations != null && !this.transformations.isEmpty()) {
            Object[] transforms = this.transformations.toArray();
            for (int i = 0; i < transforms.length; ++i) {
                Transformation t = (Transformation)transforms[i];
                t.setParameters(parameters);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public Pipeline newInstance() throws SDXException {
        try {
            Pipeline pipe = (Pipeline)this.getClass().newInstance();
            pipe.enableLogging(this.logger);
            pipe.compose(this.manager);
            pipe.setProperties(this.props);
            pipe.configure(this.configuration);
            return pipe;
        }
        catch (ComponentException e) {
            String[] args = new String[]{this.id, e.getMessage()};
            throw new SDXException(this.logger, 7001, args, null);
        }
        catch (ConfigurationException e) {
            String[] args = new String[]{this.id, e.getMessage()};
            throw new SDXException(this.logger, 7001, args, null);
        }
        catch (InstantiationException e) {
            String[] args = new String[]{this.id, e.getMessage()};
            throw new SDXException(this.logger, 7001, args, null);
        }
        catch (IllegalAccessException e) {
            String[] args = new String[]{this.id, e.getMessage()};
            throw new SDXException(this.logger, 7001, args, null);
        }
    }

    public Parameters getParameters() {
        return this.params;
    }

    public byte[] getTransformedBytes() {
        if (this.transformedBytes != null && this.transformedBytes.size() > 0) {
            return this.transformedBytes.toByteArray();
        }
        return null;
    }

    public File getTransformedFile() throws SDXException {
        if (this.fOs != null && this.transformedFile != null && this.transformedFile.exists() && this.transformedFile.length() > 0L) {
            try {
                this.fOs.flush();
            }
            catch (IOException e) {
                throw new SDXException(this.logger, 7003, null, e);
            }
            return this.transformedFile;
        }
        return null;
    }

    public void setProperties(Hashtable props) {
        this.props = props;
    }

    private void createTempFileResources() throws SDXException {
        try {
            if (this.canBuildTempFile() && this.xsFile != null) {
                File tempDir;
                if (this.fOs != null) {
                    this.fOs.close();
                }
                if (this.transformedFile != null && this.transformedFile.exists() && !this.transformedFile.delete()) {
                    this.transformedFile.deleteOnExit();
                }
                tempDir = (tempDir = (File)this.props.get("upload-directory")).canWrite() ? new File(tempDir, File.separator + "tempTransformedDocs" + File.separator + this.getId() + File.separator) : Utilities.getSystemTempDir();
                tempDir.mkdirs();
                this.transformedFile = File.createTempFile(this.TEMPFILE_PREFIX, this.TEMPFILE_SUFFIX, tempDir);
                if (this.transformedFile != null && this.transformedFile.exists()) {
                    this.fOs = new FileOutputStream(this.transformedFile);
                }
                if (this.fOs != null) {
                    this.xsFile.recycle();
                    this.xsFile.setOutputStream((OutputStream)this.fOs);
                }
            }
        }
        catch (IOException e) {
            throw new SDXException(this.logger, 7002, null, e);
        }
    }

    private void createTempByteResources() {
        if (this.transformedBytes == null) {
            this.transformedBytes = new ByteArrayOutputStream();
        }
        if (this.transformedBytes != null) {
            this.transformedBytes.reset();
            if (this.xsBytes != null) {
                this.xsBytes.recycle();
                this.xsBytes.setOutputStream((OutputStream)this.transformedBytes);
            }
        }
    }

    private boolean canBuildTempFile() {
        try {
            File.createTempFile(this.TEMPFILE_PREFIX, this.TEMPFILE_SUFFIX);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

