/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.repository;

import fr.gouv.culture.sdx.document.Document;
import fr.gouv.culture.sdx.document.ParsableDocument;
import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.repository.JDBCRepositoryConnection;
import fr.gouv.culture.sdx.repository.Repository;
import fr.gouv.culture.sdx.repository.RepositoryConnection;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.rdbms.DataSourceComponentBacked;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.cocoon.xml.XMLConsumer;

public abstract class AbstractDataSourceComponentBackedRepository
extends DataSourceComponentBacked
implements Repository {
    protected Hashtable props;
    protected boolean isDefault;
    private final String DEFAULT_ENCODING = "UTF-8";
    protected static final String FIELD_ID = "id";
    protected final int PARAM_INDEX_FIELD_ID = 1;

    public String getId() {
        return this.id;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        Utilities.checkConfAttributeValue("dsi", this.dsi, configuration.getLocation());
    }

    protected void loadBaseConfiguration(Configuration configuration) throws ConfigurationException {
        Utilities.checkConfiguration(configuration);
        this.id = configuration.getAttribute(FIELD_ID);
        if (!Utilities.checkString(this.id)) {
            String[] args = new String[]{configuration.getLocation()};
            SDXException sdxE = new SDXException(this.logger, 18, args, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
        }
        this.isDefault = configuration.getAttributeAsBoolean("default", false);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setProperties(Hashtable props) {
        this.props = props;
    }

    public void delete(Document doc, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(this.logger, doc);
        this.checkConnection(c);
    }

    public void add(Document doc, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(this.logger, doc);
        this.checkConnection(c);
    }

    public InputStream openStream(Document doc, String encoding, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(this.logger, doc);
        encoding = this.checkEncoding(encoding);
        this.checkConnection(c);
        return null;
    }

    public void get(Document doc, OutputStream os, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(this.logger, doc);
        Utilities.checkOutputStream(this.logger, os);
        this.checkConnection(c);
    }

    public void toSAX(ParsableDocument doc, XMLConsumer consumer, RepositoryConnection c) throws SDXException {
        Utilities.checkDocument(this.logger, doc);
        Utilities.checkXmlConsumer(this.logger, consumer);
        this.checkConnection(c);
    }

    public void setIsDefault(boolean b) {
        this.isDefault = b;
    }

    protected String checkEncoding(String encoding) throws SDXException {
        String defaultEncoding = "UTF-8";
        if (Utilities.checkString(encoding)) {
            try {
                defaultEncoding.getBytes(encoding);
                return encoding;
            }
            catch (UnsupportedEncodingException e) {
                Utilities.logException(this.logger, e);
                try {
                    defaultEncoding.getBytes(defaultEncoding);
                    Utilities.logInfo(this.logger, "using the default encoding: " + defaultEncoding);
                    return defaultEncoding;
                }
                catch (UnsupportedEncodingException e1) {
                    String[] args = new String[]{defaultEncoding, e1.getMessage()};
                    throw new SDXException(this.logger, 217, args, null);
                }
            }
        }
        return defaultEncoding;
    }

    public void checkConnection(RepositoryConnection c) throws SDXException {
        if (c == null) {
            String[] args = new String[]{this.getId()};
            throw new SDXException(this.logger, 3005, args, null);
        }
    }

    public void optimize() throws SDXException {
    }

    protected String getDocumentGetQuery() {
        return "SELECT * FROM " + this.getTableName() + " WHERE " + FIELD_ID + " = ?";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public boolean exists(String id, RepositoryConnection conn) {
        String[] args2;
        SQLException e2222;
        ResultSet rs;
        Statement ps;
        boolean exists;
        block22: {
            String[] args2;
            SQLException e2222;
            block23: {
                exists = false;
                if (!Utilities.checkString(id)) {
                    return exists;
                }
                Connection sqlConn = null;
                ps = null;
                rs = null;
                sqlConn = ((JDBCRepositoryConnection)conn).getConnection();
                String queryString = this.getDocumentGetQuery();
                ps = sqlConn.prepareStatement(queryString);
                ps.setString(1, id);
                rs = ps.executeQuery();
                if (!rs.next()) break block22;
                boolean bl = true;
                Object var10_11 = null;
                if (ps == null) break block23;
                try {
                    ps.close();
                }
                catch (SQLException e2222) {
                    args2 = new String[]{this.getId(), e2222.getMessage()};
                    new SDXException(this.logger, 3203, args2, e2222);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2222) {
                    args2 = new String[]{this.getId(), e2222.getMessage()};
                    new SDXException(this.logger, 3200, args2, e2222);
                }
            }
            return exists;
        }
        Object var10_12 = null;
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e2222) {
                args2 = new String[]{this.getId(), e2222.getMessage()};
                new SDXException(this.logger, 3203, args2, e2222);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e2222) {
                args2 = new String[]{this.getId(), e2222.getMessage()};
                new SDXException(this.logger, 3200, args2, e2222);
            }
        }
        return exists;
        {
            catch (SQLException e3) {
                String[] args2;
                SQLException e2222;
                String[] args3 = new String[]{id, this.getId(), e3.getMessage()};
                new SDXException(this.logger, 3001, args3, e3);
                Object var10_13 = null;
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e2222) {
                        args2 = new String[]{this.getId(), e2222.getMessage()};
                        new SDXException(this.logger, 3203, args2, e2222);
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e2222) {
                        args2 = new String[]{this.getId(), e2222.getMessage()};
                        new SDXException(this.logger, 3200, args2, e2222);
                    }
                }
                return exists;
            }
        }
        catch (Throwable throwable) {
            String[] args2;
            SQLException e2222;
            Object var10_14 = null;
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e2222) {
                    args2 = new String[]{this.getId(), e2222.getMessage()};
                    new SDXException(this.logger, 3203, args2, e2222);
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2222) {
                    args2 = new String[]{this.getId(), e2222.getMessage()};
                    new SDXException(this.logger, 3200, args2, e2222);
                }
            }
            return exists;
        }
    }
}

