/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.analysis.Analyzer;
import fr.gouv.culture.sdx.search.lucene.analysis.AnalyzerManager;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.database.Property;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;

public class FieldsDefinition
implements LogEnabled,
Configurable,
Cloneable {
    private Logger logger;
    private String id = null;
    private Locale locale;
    private Analyzer analyzer;
    private Hashtable fieldTable;
    private String defaultField = "";
    private boolean ignoreCase = false;
    private final String ATTRIBUTE_ANALYZER_CONF = "analyzerConf";
    private final String ATTRIBUTE_ID = "id";
    private final String ATTRIBUTE_ANALYZER_CLASS = "analyzerClass";
    private final String ELEMENT_NAME_FIELD = "field";
    private Hashtable props;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Utilities.checkConfiguration(configuration);
        if (!Utilities.checkString(this.getId())) {
            String flId = configuration.getAttribute("id", null);
            this.setId(flId);
        }
        String confFileRelPath = configuration.getAttribute("analyzerConf", null);
        String className = configuration.getAttribute("analyzerClass", "");
        this.locale = Utilities.buildLocale(configuration, null);
        File analyzerConfFile = null;
        try {
            if (confFileRelPath != null) {
                Utilities.checkConfAttributeValue("analyzerConf", confFileRelPath, configuration.getLocation());
                analyzerConfFile = Utilities.resolveFile(null, configuration.getLocation(), this.props, confFileRelPath, false);
            }
        }
        catch (ConfigurationException e) {
            Utilities.logWarn(this.logger, null, (Exception)((Object)e));
        }
        catch (SDXException e) {
            Utilities.logWarn(this.logger, null, e);
        }
        AnalyzerManager analyzeMgr = (AnalyzerManager)this.props.get("analyzerMgr");
        try {
            this.analyzer = Utilities.checkString(className) ? analyzeMgr.getAnalyzer(className, analyzerConfFile) : analyzeMgr.getAnalyzer(this.locale, analyzerConfFile);
        }
        catch (SDXException sdxE) {
            throw new ConfigurationException(sdxE.getMessage(), sdxE.fillInStackTrace());
        }
        this.analyzer.enableLogging(this.logger);
        this.configureFields(configuration);
    }

    public void configureFields(Configuration configuration) throws ConfigurationException {
        Configuration[] fields = new Configuration[configuration.getChildren("field").length];
        fields = configuration.getChildren("field");
        if (fields == null | fields.length == 0) {
            String[] args = new String[]{configuration.getLocation()};
            SDXException sdxE = new SDXException(null, 21, args, null);
            throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
        }
        Field firstField = null;
        for (int i = 0; i < fields.length; ++i) {
            Field field = new Field();
            field.enableLogging(this.logger);
            field.setProperties(this.props);
            field.setUp(this.locale, this.analyzer, null, null);
            field.configure(fields[i]);
            try {
                this.add(field);
                if (i != 0) continue;
                firstField = field;
                continue;
            }
            catch (SDXException e) {
                throw new ConfigurationException(e.getMessage(), e.fillInStackTrace());
            }
        }
        if (!Utilities.checkString(this.defaultField)) {
            this.defaultField = firstField.getCode();
        }
    }

    public void addInternalFields(Configuration conf) throws SDXException, ConfigurationException {
        Configuration[] fields = conf.getChildren("field");
        if (fields == null | fields.length == 0) {
            String[] args = new String[]{conf.getLocation()};
            throw new SDXException(null, 21, args, null);
        }
        for (int i = 0; i < fields.length; ++i) {
            Field field = new Field();
            field.enableLogging(this.logger);
            field.setProperties(this.props);
            field.setUp(this.locale, this.analyzer, null, null);
            field.configure(fields[i]);
            this.add(field);
        }
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public Field getDefaultField() {
        return (Field)this.fieldTable.get(this.defaultField);
    }

    public int getFieldType(String name) {
        if (name == null) {
            return 0;
        }
        Field f = (Field)this.fieldTable.get(this.normalizeName(name));
        if (f == null) {
            return 0;
        }
        return f.getFieldType();
    }

    public void add(Field field) throws SDXException {
        if (this.fieldTable == null) {
            this.fieldTable = new Hashtable();
        }
        if (Utilities.checkString(this.defaultField) & field.isDefault()) {
            String[] args = new String[]{field.getCode()};
            throw new SDXException(this.logger, 30, args, null);
        }
        if (field.isDefault()) {
            this.defaultField = field.getCode();
        }
        this.fieldTable.put(field.getCode(), field);
    }

    private String normalizeName(String name) {
        if (name == null || !this.ignoreCase) {
            return name;
        }
        return name.toLowerCase();
    }

    public org.apache.lucene.document.Field getLuceneField(Property prop) throws SDXException {
        Field f = null;
        if (prop != null) {
            f = (Field)this.fieldTable.get(prop.getName());
        }
        if (f != null) {
            return f.getLuceneField(prop.getValue());
        }
        return null;
    }

    public Field getField(String name) {
        return (Field)this.fieldTable.get(name);
    }

    public Locale getLocale(String name) {
        return ((Field)this.fieldTable.get(name)).getLocale();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setProperties(Hashtable props) {
        this.props = props;
    }

    public Enumeration getFields() {
        if (this.fieldTable != null) {
            return this.fieldTable.elements();
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Object clone() {
        try {
            return (FieldsDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone not supported: " + e.getMessage());
        }
    }
}

