/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.search.lucene.Field;
import fr.gouv.culture.sdx.search.lucene.query.Index;
import fr.gouv.culture.sdx.search.lucene.query.LuceneIndex;
import fr.gouv.culture.sdx.search.lucene.queryparser.DefaultQueryParser;
import fr.gouv.culture.sdx.search.lucene.queryparser.QueryParser;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;

public class SearchLocations
implements LogEnabled {
    private Logger logger;
    private Index singleIndex = null;
    private Vector indices = new Vector();
    private QueryParser queryParser = null;

    public void setUp(Index index) {
        this.addIndex(index);
    }

    public void addIndex(Index index) {
        if (index != null && !this.contains(index)) {
            this.indices.add(index);
            this.singleIndex = this.indices.size() > 1 ? null : index;
        }
    }

    public Field getDefaultField() throws SDXException {
        if (this.singleIndex != null) {
            try {
                return this.singleIndex.getDefaultField();
            }
            catch (IOException e) {
                throw new SDXException(this.logger, 4502, null, e);
            }
        }
        if (this.indices.size() > 0) {
            return ((LuceneIndex)this.indices.get(0)).getDefaultField();
        }
        return null;
    }

    public Field getField(String name) throws SDXException {
        return this.getFirstField(name);
    }

    public int getFieldType(String name) throws SDXException {
        Field f = this.getFirstField(name);
        if (f == null) {
            return 0;
        }
        return f.getFieldType();
    }

    public String getTypeName(String name) throws SDXException {
        Field f = this.getFirstField(name);
        if (f != null) {
            return f.getTypeName();
        }
        return null;
    }

    private Field getFirstField(String name) throws SDXException {
        if (name == null) {
            return null;
        }
        if (this.singleIndex != null) {
            try {
                return this.singleIndex.getField(name);
            }
            catch (IOException e) {
                throw new SDXException(this.logger, 4501, null, e);
            }
        }
        for (int i = 0; i < this.indices.size(); ++i) {
            LuceneIndex index = (LuceneIndex)this.indices.elementAt(i);
            if (index.getField(name) == null) continue;
            return index.getField(name);
        }
        return null;
    }

    public IndexReader getIndexReader(int idx) throws SDXException {
        if (idx >= 0 && idx <= this.size()) {
            LuceneIndex lIndex = null;
            Index index = (Index)this.indices.elementAt(idx);
            if (index instanceof LuceneIndex) {
                lIndex = (LuceneIndex)index;
            }
            if (lIndex != null) {
                return lIndex.getReader();
            }
            return null;
        }
        return null;
    }

    public Locale getLocale(String name) throws SDXException {
        Field f = this.getFirstField(name);
        if (f == null) {
            return null;
        }
        return f.getLocale();
    }

    public Searcher getSearcher() throws SDXException {
        try {
            if (this.singleIndex != null) {
                Searchable[] searchable = new Searchable[]{this.singleIndex.getSearcher()};
                return new MultiSearcher(searchable);
            }
            Searcher[] searchers = new Searcher[this.indices.size()];
            for (int i = 0; i < this.indices.size(); ++i) {
                LuceneIndex index = (LuceneIndex)this.indices.elementAt(i);
                searchers[i] = index.getSearcher();
            }
            return new MultiSearcher((Searchable[])searchers);
        }
        catch (IOException e) {
            String[] args = new String[]{e.getMessage()};
            throw new SDXException(this.logger, 4500, args, e);
        }
    }

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public int size() {
        if (this.singleIndex != null) {
            return 1;
        }
        return this.indices.size();
    }

    public QueryParser getQueryParser() {
        if (this.queryParser != null) {
            return this.queryParser;
        }
        if (this.singleIndex != null) {
            try {
                QueryParser qp = this.singleIndex.getQueryParser();
                if (qp == null) {
                    qp = new DefaultQueryParser();
                }
                return qp;
            }
            catch (SDXException e) {
                return new DefaultQueryParser();
            }
            catch (IOException e) {
                return new DefaultQueryParser();
            }
        }
        if (this.indices.size() > 0) {
            try {
                return ((LuceneIndex)this.indices.get(0)).getQueryParser();
            }
            catch (SDXException e) {
                return new DefaultQueryParser();
            }
            catch (IOException e) {
                return new DefaultQueryParser();
            }
        }
        return new DefaultQueryParser();
    }

    public void setQueryParser(QueryParser qParser) {
        this.queryParser = qParser;
    }

    public boolean contains(Index index) {
        if (this.indices == null) {
            return false;
        }
        return this.indices.contains(index);
    }
}

