/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.thesaurus;

import fr.gouv.culture.sdx.thesaurus.AbstractThesaurusBuilder;
import fr.gouv.culture.sdx.thesaurus.LuceneConcept;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.cocoon.serialization.XMLSerializer;
import org.apache.cocoon.xml.XMLConsumer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class LuceneThesaurusBuilder
extends AbstractThesaurusBuilder {
    protected int openConcepts = 0;
    protected ByteArrayOutputStream conceptBytes = null;

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        if (uri.equals("http://sdx.culture.fr/thesaurus/1.0") && loc.equals("concept")) {
            if (this.openConcepts == 0) {
                XMLSerializer cBytes = new XMLSerializer();
                this.conceptBytes = new ByteArrayOutputStream();
                cBytes.setOutputStream((OutputStream)this.conceptBytes);
                super.setConsumer((XMLConsumer)cBytes);
                super.startDocument();
            }
            ++this.openConcepts;
        }
        super.startElement(uri, loc, raw, a);
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        super.endElement(uri, loc, raw);
        if (uri.equals("http://sdx.culture.fr/thesaurus/1.0") && loc.equals("concept")) {
            --this.openConcepts;
            if (this.openConcepts == 0) {
                super.endDocument();
                if (this.conceptBytes != null) {
                    LuceneConcept concept = new LuceneConcept();
                    try {
                        this.conceptBytes.flush();
                    }
                    catch (IOException e) {
                        throw new SAXException(e.getMessage(), e);
                    }
                    concept.setContent(this.conceptBytes.toByteArray());
                    this.concepts.add(concept);
                    this.conceptBytes = null;
                }
                super.recycle();
            }
        }
    }
}

