/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils;

import fr.gouv.culture.sdx.documentbase.DefaultIDGenerator;
import fr.gouv.culture.sdx.documentbase.IDGenerator;
import fr.gouv.culture.sdx.exception.SDXException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;

public class ConfigurationUtilities {
    public static IDGenerator configureIDGenerator(Logger logger, Configuration configuration) throws ConfigurationException {
        IDGenerator idGen = new DefaultIDGenerator();
        Configuration idGenConf = configuration.getChild("idGenerator", false);
        if (idGenConf != null) {
            String idGenClassName = idGenConf.getAttribute("class", "fr.gouv.culture.sdx.documentbase.DefaultIDGenerator");
            try {
                Class<?> idGenClass = Class.forName(idGenClassName);
                Object obj = idGenClass.newInstance();
                if (obj == null) {
                    String[] args = new String[]{idGenClassName};
                    SDXException sdxE = new SDXException(logger, 220, args, null);
                    throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
                }
                if (!(obj instanceof IDGenerator)) {
                    String[] args = new String[]{"IDGenerator", idGenClass.getName(), "IDGenerator"};
                    SDXException sdxE = new SDXException(logger, 10, null, null);
                    throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
                }
                idGen = (IDGenerator)obj;
                idGen.configure(idGenConf);
            }
            catch (ClassNotFoundException e) {
                SDXException sdxE = new SDXException(logger, 39, null, e);
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
            }
            catch (InstantiationException e) {
                SDXException sdxE = new SDXException(logger, 39, null, e);
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
            }
            catch (IllegalAccessException e) {
                SDXException sdxE = new SDXException(logger, 39, null, e);
                throw new ConfigurationException(sdxE.getMessage(), (Throwable)sdxE);
            }
        }
        return idGen;
    }
}

