/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.utils.lucene;

import fr.gouv.culture.sdx.exception.SDXException;
import fr.gouv.culture.sdx.utils.SdxObjectImpl;
import fr.gouv.culture.sdx.utils.Utilities;
import fr.gouv.culture.sdx.utils.lucene.LuceneDataField;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class LuceneData
extends SdxObjectImpl {
    protected Hashtable ldFields = new Hashtable();
    public static final String allKey = "sdxall";
    public static final String allValue = "1";
    public static final String idKey = "sdxdocid";
    public static final String xmlLangKey = "xmllang";

    public LuceneData() {
        this.addLDField(allKey, allValue);
    }

    public LuceneData(Document lDoc) {
        Enumeration lFields;
        if (lDoc != null && (lFields = lDoc.fields()) != null) {
            while (lFields.hasMoreElements()) {
                Field field = (Field)lFields.nextElement();
                if (field == null) continue;
                this.addLDField(field);
            }
        }
    }

    public void setId(String id) {
        this.addLDField(idKey, id);
    }

    public void setXmlLang(String xmlLang) {
        this.addLDField(xmlLangKey, xmlLang);
    }

    public String getXmlLang() {
        LuceneDataField xmlLang = this.getField(xmlLangKey);
        if (xmlLang != null) {
            return xmlLang.getValue();
        }
        return null;
    }

    public String getId() {
        LuceneDataField id = this.getField(idKey);
        if (id != null) {
            return id.getValue();
        }
        return null;
    }

    public void addField(String fieldName, String value, String type) {
        if (Utilities.checkString(fieldName)) {
            if (this.ldFields.containsKey(fieldName)) {
                this.updateLDField(fieldName, value);
            } else {
                this.addLDField(fieldName, value, type);
            }
        }
    }

    public void removeField(String fieldName) {
        this.deleteLDField(fieldName);
    }

    public void removeValue(String fieldName, String value) {
        LuceneDataField ldf;
        if (this.ldFields.containsKey(fieldName) && Utilities.checkString(value) && (ldf = this.getField(fieldName)) != null) {
            ldf.deleteValue(value);
        }
    }

    public String[] getFieldValues(String fieldName) {
        if (Utilities.checkString(fieldName)) {
            if (this.ldFields.containsKey(fieldName)) {
                LuceneDataField ldf = this.getField(fieldName);
                if (ldf != null) {
                    return ldf.getValues();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public String getFieldValue(String fieldName) {
        if (Utilities.checkString(fieldName)) {
            if (this.ldFields.containsKey(fieldName)) {
                LuceneDataField ldf = this.getField(fieldName);
                if (ldf != null) {
                    return ldf.getValue();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public Document getLuceneDocument() {
        Document ldoc = null;
        Enumeration props = this.ldFields.elements();
        if (props != null) {
            ldoc = new Document();
            while (props.hasMoreElements()) {
                LuceneDataField ldf = (LuceneDataField)props.nextElement();
                if (ldf == null) continue;
                String[] values = ldf.getValues();
                for (int j = 0; j < values.length; ++j) {
                    ldoc.add(ldf.getLuceneField(values[j]));
                }
            }
        }
        return ldoc;
    }

    protected void addLDField(String name, String value) {
        if (Utilities.checkString(name) && Utilities.checkString(value)) {
            LuceneDataField ldf = new LuceneDataField();
            ldf.setName(name);
            ldf.setFieldType(true, true, false);
            ldf.addValue(value);
            this.ldFields.put(name, ldf);
        }
    }

    protected void addLDField(String name, String value, String type) {
        if (Utilities.checkString(name) && Utilities.checkString(value)) {
            LuceneDataField ldf = new LuceneDataField();
            ldf.setName(name);
            ldf.setFieldType(type);
            ldf.addValue(value);
            this.ldFields.put(name, ldf);
        }
    }

    protected void addLDField(Field f) {
        String name = "";
        String value = "";
        boolean store = false;
        boolean index = false;
        boolean token = false;
        if (f != null) {
            name = f.name();
            value = f.stringValue();
            store = f.isStored();
            index = f.isIndexed();
            token = f.isTokenized();
        }
        if (Utilities.checkString(name) && Utilities.checkString(value)) {
            LuceneDataField ldf = new LuceneDataField();
            ldf.setFieldType(store, index, token);
            this.addField(name, value, ldf.getTypeName());
        }
    }

    protected void updateLDField(String name, String value) {
        LuceneDataField prop;
        if (Utilities.checkString(name) && Utilities.checkString(value) && (prop = this.getField(name)) != null) {
            prop.addValue(value);
        }
    }

    protected void deleteLDField(String name) {
        if (Utilities.checkString(name) && this.ldFields.containsKey(name)) {
            this.ldFields.remove(name);
        }
    }

    public LuceneDataField getField(String key) {
        LuceneDataField ldf = null;
        if (this.ldFields.containsKey(key)) {
            ldf = (LuceneDataField)this.ldFields.get(key);
        }
        return ldf;
    }

    public Enumeration getFields() {
        return this.ldFields.elements();
    }

    public Enumeration getContentFields() {
        Hashtable contentFields = new Hashtable(this.ldFields);
        contentFields.remove(allKey);
        contentFields.remove(idKey);
        contentFields.remove(xmlLangKey);
        return contentFields.elements();
    }

    protected Field getLuceneField(String name, String value) throws SDXException {
        if (!Utilities.checkString(name) || value == null) {
            String[] args = new String[]{name, value};
            throw new SDXException(null, 300, args, null);
        }
        return Field.Keyword((String)name, (String)value);
    }
}

