/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.validationruleimpl;

import java.math.BigDecimal;
import org.apache.cocoon.forms.datatype.ValidationRule;
import org.apache.cocoon.forms.formmodel.CannotYetResolveWarning;
import org.apache.cocoon.forms.validation.ValidationError;
import org.apache.excalibur.xml.sax.XMLizable;
import org.outerj.expression.Expression;
import org.outerj.expression.ExpressionContext;
import org.outerj.expression.ExpressionException;

public abstract class AbstractValidationRule
implements ValidationRule {
    private XMLizable failMessage;

    public void setFailMessage(XMLizable object) {
        this.failMessage = object;
    }

    public ValidationError getFailMessage() {
        return new ValidationError(this.failMessage);
    }

    public boolean hasFailMessage() {
        return this.failMessage != null;
    }

    protected Object evaluateNumeric(Expression expression, ExpressionContext expressionContext, String exprName, String ruleName) {
        Object expressionResult;
        try {
            expressionResult = expression.evaluate(expressionContext);
        }
        catch (CannotYetResolveWarning w) {
            return w;
        }
        catch (ExpressionException e) {
            return new ValidationError("Error evaluating \"" + exprName + "\" expression on \"" + ruleName + "\" validation rule", false);
        }
        if (!(expressionResult instanceof BigDecimal)) {
            return new ValidationError("Got non-numeric result from \"" + exprName + "\" expression on \"" + ruleName + "\" validation rule", false);
        }
        return expressionResult;
    }

    protected Object evaluateComparable(Expression expression, ExpressionContext expressionContext, String exprName, String ruleName) {
        Object expressionResult;
        try {
            expressionResult = expression.evaluate(expressionContext);
        }
        catch (CannotYetResolveWarning w) {
            return w;
        }
        catch (ExpressionException e) {
            return new ValidationError("Error evaluating \"" + exprName + "\" expression on \"" + ruleName + "\" validation rule", false);
        }
        if (!(expressionResult instanceof Comparable)) {
            return new ValidationError("Got non-comparable result from \"" + exprName + "\" expression on \"" + ruleName + "\" validation rule", false);
        }
        return expressionResult;
    }
}

