/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components;

import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class LifecycleHelper {
    private final Logger m_logger;
    private final Context m_context;
    private final ComponentManager m_componentManager;
    private final ServiceManager m_serviceManager;
    private final Configuration m_configuration;
    private final RoleManager m_roles;

    public LifecycleHelper(Logger logger, Context context, ComponentManager componentManager, RoleManager roles, Configuration configuration) {
        this(logger, context, null, componentManager, roles, configuration);
    }

    public LifecycleHelper(Logger logger, Context context, ServiceManager serviceManager, RoleManager roles, Configuration configuration) {
        this(logger, context, serviceManager, null, roles, configuration);
    }

    public LifecycleHelper(Logger logger, Context context, ServiceManager serviceManager, ComponentManager componentManager, RoleManager roles, Configuration configuration) {
        this.m_logger = logger;
        this.m_context = context;
        this.m_serviceManager = serviceManager;
        this.m_componentManager = componentManager;
        this.m_roles = roles;
        this.m_configuration = configuration;
    }

    public Object setupComponent(Object component) throws Exception {
        return this.setupComponent(component, true);
    }

    public Object setupComponent(Object component, boolean initializeAndStart) throws Exception {
        return LifecycleHelper.setupComponent(component, this.m_logger, this.m_context, this.m_serviceManager, this.m_componentManager, this.m_roles, this.m_configuration, initializeAndStart);
    }

    public static Object setupComponent(Object component, Logger logger, Context context, ComponentManager componentManager, RoleManager roles, Configuration configuration) throws Exception {
        return LifecycleHelper.setupComponent(component, logger, context, componentManager, roles, configuration, true);
    }

    public static Object setupComponent(Object component, Logger logger, Context context, ServiceManager serviceManager, RoleManager roles, Configuration configuration) throws Exception {
        return LifecycleHelper.setupComponent(component, logger, context, serviceManager, roles, configuration, true);
    }

    public static Object setupComponent(Object component, Logger logger, Context context, ComponentManager componentManager, RoleManager roles, Configuration configuration, boolean initializeAndStart) throws Exception {
        return LifecycleHelper.setupComponent(component, logger, context, null, componentManager, roles, configuration, initializeAndStart);
    }

    public static Object setupComponent(Object component, Logger logger, Context context, ServiceManager serviceManager, RoleManager roles, Configuration configuration, boolean initializeAndStart) throws Exception {
        return LifecycleHelper.setupComponent(component, logger, context, serviceManager, null, roles, configuration, initializeAndStart);
    }

    public static Object setupComponent(Object component, Logger logger, Context context, ServiceManager serviceManager, ComponentManager componentManager, RoleManager roles, Configuration configuration, boolean initializeAndStart) throws Exception {
        if (component instanceof LogEnabled) {
            ((LogEnabled)component).enableLogging(logger);
        }
        if (null != context && component instanceof Contextualizable) {
            ((Contextualizable)component).contextualize(context);
        }
        if (null != componentManager && component instanceof Composable) {
            ((Composable)component).compose(componentManager);
        }
        if (null != serviceManager && component instanceof Serviceable) {
            ((Serviceable)component).service(serviceManager);
        }
        if (null != roles && component instanceof RoleManageable) {
            ((RoleManageable)component).setRoleManager(roles);
        }
        if (null != configuration && component instanceof Configurable) {
            ((Configurable)component).configure(configuration);
        }
        if (null != configuration && component instanceof Parameterizable) {
            ((Parameterizable)component).parameterize(Parameters.fromConfiguration((Configuration)configuration));
        }
        if (initializeAndStart && component instanceof Initializable) {
            ((Initializable)component).initialize();
        }
        if (initializeAndStart && component instanceof Startable) {
            ((Startable)component).start();
        }
        return component;
    }

    public static final void decommission(Object component) throws Exception {
        if (component instanceof Startable) {
            ((Startable)component).stop();
        }
        LifecycleHelper.dispose(component);
    }

    public static final void dispose(Object component) {
        if (component instanceof Disposable) {
            ((Disposable)component).dispose();
        }
    }
}

